/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.subscriptions;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.StreamDisseminationCrosswalk;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.discovery.IndexableObject;
import org.dspace.eperson.EPerson;
import org.dspace.subscriptions.service.SubscriptionGenerator;
import org.springframework.beans.factory.annotation.Autowired;

public class ContentGenerator
implements SubscriptionGenerator<IndexableObject> {
    private final Logger log = LogManager.getLogger(ContentGenerator.class);
    private Map<String, StreamDisseminationCrosswalk> entityType2Disseminator = new HashMap<String, StreamDisseminationCrosswalk>();
    @Autowired
    private ItemService itemService;

    @Override
    public void notifyForSubscriptions(Context context, EPerson ePerson, List<IndexableObject> indexableComm, List<IndexableObject> indexableColl) {
        try {
            if (Objects.nonNull(ePerson)) {
                Locale supportedLocale = I18nUtil.getEPersonLocale(ePerson);
                Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "subscriptions_content"));
                email.addRecipient(ePerson.getEmail());
                email.addArgument(this.generateBodyMail(context, indexableComm));
                email.addArgument(this.generateBodyMail(context, indexableColl));
                email.send();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = ePerson::getID;
            supplierArray[1] = ePerson::getEmail;
            this.log.warn("Cannot email user eperson_id: {} eperson_email: {}", supplierArray);
        }
    }

    private String generateBodyMail(Context context, List<IndexableObject> indexableObjects) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write("\n".getBytes(StandardCharsets.UTF_8));
            if (indexableObjects.size() > 0) {
                for (IndexableObject indexableObject : indexableObjects) {
                    out.write("\n".getBytes(StandardCharsets.UTF_8));
                    Item item = (Item)indexableObject.getIndexedObject();
                    String entityType = this.itemService.getEntityTypeLabel(item);
                    Optional.ofNullable(this.entityType2Disseminator.get(entityType)).orElseGet(() -> this.entityType2Disseminator.get("Item")).disseminate(context, item, out);
                }
                return out.toString();
            }
            out.write("No items".getBytes(StandardCharsets.UTF_8));
            return out.toString();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public void setEntityType2Disseminator(Map<String, StreamDisseminationCrosswalk> entityType2Disseminator) {
        this.entityType2Disseminator = entityType2Disseminator;
    }
}

