/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.discovery.SearchServiceException;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SubmissionConfigReader {
    public static final String DEFAULT_COLLECTION = "default";
    static final String SUBMIT_DEF_FILE_PREFIX = "item-submission";
    static final String SUBMIT_DEF_FILE_SUFFIX = ".xml";
    private static Logger log = LogManager.getLogger(SubmissionConfigReader.class);
    private String configDir = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + File.separator + "config" + File.separator;
    private Map<String, String> collectionToSubmissionConfig = null;
    private Map<String, String> communityToSubmissionConfig = null;
    private Map<String, Map<String, String>> stepDefns = null;
    private Map<String, List<Map<String, String>>> submitDefns = null;
    private SubmissionConfig lastSubmissionConfig = null;
    protected static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();

    public SubmissionConfigReader() throws SubmissionConfigReaderException {
        this.buildInputs(this.configDir + "item-submission.xml");
    }

    public void reload() throws SubmissionConfigReaderException {
        this.collectionToSubmissionConfig = null;
        this.communityToSubmissionConfig = null;
        this.stepDefns = null;
        this.submitDefns = null;
        this.buildInputs(this.configDir + "item-submission.xml");
    }

    private void buildInputs(String fileName) throws SubmissionConfigReaderException {
        this.collectionToSubmissionConfig = new HashMap<String, String>();
        this.communityToSubmissionConfig = new HashMap<String, String>();
        this.submitDefns = new LinkedHashMap<String, List<Map<String, String>>>();
        String uri = "file:" + new File(fileName).getAbsolutePath();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(uri);
            this.doNodes(doc);
        }
        catch (FactoryConfigurationError fe) {
            throw new SubmissionConfigReaderException("Cannot create Item Submission Configuration parser", fe);
        }
        catch (SearchServiceException se) {
            throw new SubmissionConfigReaderException("Cannot perform a discovery search for Item Submission Configuration", se);
        }
        catch (Exception e) {
            throw new SubmissionConfigReaderException("Error creating Item Submission Configuration: " + e);
        }
    }

    public String getDefaultSubmissionConfigName() {
        return this.collectionToSubmissionConfig.get(DEFAULT_COLLECTION);
    }

    public List<SubmissionConfig> getAllSubmissionConfigs(Integer limit, Integer offset) {
        int idx = 0;
        int count = 0;
        LinkedList<SubmissionConfig> subConfigs = new LinkedList<SubmissionConfig>();
        for (String key : this.submitDefns.keySet()) {
            if (offset == null || idx >= offset) {
                ++count;
                subConfigs.add(this.getSubmissionConfigByName(key));
            }
            ++idx;
            if (count < limit) continue;
            break;
        }
        return subConfigs;
    }

    public int countSubmissionConfigs() {
        return this.submitDefns.size();
    }

    public SubmissionConfig getSubmissionConfigByCollection(Collection col) {
        String submitName;
        if (col != null) {
            submitName = this.collectionToSubmissionConfig.get(col.getHandle());
            if (submitName != null) {
                return this.getSubmissionConfigByName(submitName);
            }
            if (!this.communityToSubmissionConfig.isEmpty()) {
                try {
                    List<Community> communities = col.getCommunities();
                    for (Community com : communities) {
                        submitName = this.getSubmissionConfigByCommunity(com);
                        if (submitName == null) continue;
                        return this.getSubmissionConfigByName(submitName);
                    }
                }
                catch (SQLException sqle) {
                    throw new IllegalStateException("Error occurred while getting item submission configured by community", sqle);
                }
            }
        }
        if ((submitName = this.collectionToSubmissionConfig.get(DEFAULT_COLLECTION)) == null) {
            throw new IllegalStateException("No item submission process configuration designated as 'default' in 'submission-map' section of 'item-submission.xml'.");
        }
        return this.getSubmissionConfigByName(submitName);
    }

    private String getSubmissionConfigByCommunity(Community com) {
        String submitName = this.communityToSubmissionConfig.get(com.getHandle());
        if (submitName != null) {
            return submitName;
        }
        List<Community> communities = com.getParentCommunities();
        for (Community parentCom : communities) {
            submitName = this.getSubmissionConfigByCommunity(parentCom);
            if (submitName == null) continue;
            return submitName;
        }
        return null;
    }

    public SubmissionConfig getSubmissionConfigByName(String submitName) {
        log.debug("Loading submission process config named '" + submitName + "'");
        if (this.lastSubmissionConfig != null && this.lastSubmissionConfig.getSubmissionName().equals(submitName)) {
            log.debug("Found submission process config '" + submitName + "' in cache.");
            return this.lastSubmissionConfig;
        }
        List<Map<String, String>> steps = this.submitDefns.get(submitName);
        if (steps == null) {
            throw new IllegalStateException("Missing the Item Submission process config '" + submitName + "' (or unable to load) from 'item-submission.xml'.");
        }
        log.debug("Submission process config '" + submitName + "' not in cache. Reloading from scratch.");
        this.lastSubmissionConfig = new SubmissionConfig(StringUtils.equals((CharSequence)this.getDefaultSubmissionConfigName(), (CharSequence)submitName), submitName, steps);
        log.debug("Submission process config has " + this.lastSubmissionConfig.getNumberOfSteps() + " steps listed.");
        return this.lastSubmissionConfig;
    }

    public SubmissionStepConfig getStepConfig(String stepID) throws SubmissionConfigReaderException {
        Map<String, String> stepInfo;
        if (this.stepDefns != null && (stepInfo = this.stepDefns.get(stepID)) != null) {
            return new SubmissionStepConfig(stepInfo);
        }
        return null;
    }

    private void doNodes(Node n) throws SAXException, SearchServiceException, SubmissionConfigReaderException {
        if (n == null) {
            return;
        }
        Node e = this.getElement(n);
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        boolean foundMap = false;
        boolean foundStepDefs = false;
        boolean foundSubmitDefs = false;
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (nd == null || this.isEmptyTextNode(nd)) continue;
            String tagName = nd.getNodeName();
            if (tagName.equals("submission-map")) {
                this.processMap(nd);
                foundMap = true;
                continue;
            }
            if (tagName.equals("step-definitions")) {
                this.processStepDefinition(nd);
                foundStepDefs = true;
                continue;
            }
            if (!tagName.equals("submission-definitions")) continue;
            this.processSubmissionDefinition(nd);
            foundSubmitDefs = true;
        }
        if (!foundMap) {
            throw new SubmissionConfigReaderException("No collection to item submission map ('submission-map') found in 'item-submission.xml'");
        }
        if (!foundStepDefs) {
            throw new SubmissionConfigReaderException("No 'step-definitions' section found in 'item-submission.xml'");
        }
        if (!foundSubmitDefs) {
            throw new SubmissionConfigReaderException("No 'submission-definitions' section found in 'item-submission.xml'");
        }
    }

    private void processMap(Node e) throws SAXException, SearchServiceException {
        Context context = new Context();
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals("name-map")) continue;
            String id = this.getAttribute(nd, "collection-handle");
            String communityId = this.getAttribute(nd, "community-handle");
            String entityType = this.getAttribute(nd, "collection-entity-type");
            String value = this.getAttribute(nd, "submission-name");
            String content = this.getValue(nd);
            if (id == null && communityId == null && entityType == null) {
                throw new SAXException("name-map element is missing collection-handle or community-handle or collection-entity-type attribute in 'item-submission.xml'");
            }
            if (value == null) {
                throw new SAXException("name-map element is missing submission-name attribute in 'item-submission.xml'");
            }
            if (content != null && content.length() > 0) {
                throw new SAXException("name-map element has content in 'item-submission.xml', it should be empty.");
            }
            if (id != null) {
                this.collectionToSubmissionConfig.put(id, value);
                continue;
            }
            if (communityId != null) {
                this.communityToSubmissionConfig.put(communityId, value);
                continue;
            }
            List<Collection> collections = collectionService.findAllCollectionsByEntityType(context, entityType);
            for (Collection collection : collections) {
                this.collectionToSubmissionConfig.putIfAbsent(collection.getHandle(), value);
            }
        }
    }

    private void processStepDefinition(Node e) throws SAXException, SubmissionConfigReaderException {
        this.stepDefns = new HashMap<String, Map<String, String>>();
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)nd.getNodeName(), (CharSequence)"step-definition")) continue;
            String stepID = this.getAttribute(nd, "id");
            if (stepID == null) {
                throw new SAXException("step element has no 'id' attribute in 'item-submission.xml', which is required in the 'step-definitions' section");
            }
            if (this.stepDefns.containsKey(stepID)) {
                throw new SAXException("There are two step elements with the id '" + stepID + "' in 'item-submission.xml'");
            }
            Map<String, String> stepInfo = this.processStepChildNodes("step-definition", nd);
            this.stepDefns.put(stepID, stepInfo);
        }
        if (this.stepDefns.size() < 1) {
            throw new SubmissionConfigReaderException("step-definition section has no steps! A step with id='collection' is required in 'item-submission.xml'!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSubmissionDefinition(Node e) throws SAXException, SubmissionConfigReaderException {
        int numSubmitProcesses = 0;
        ArrayList<String> submitNames = new ArrayList<String>();
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals("submission-process")) continue;
            ++numSubmitProcesses;
            String submitName = this.getAttribute(nd, "name");
            if (submitName == null) {
                throw new SAXException("'submission-process' element has no 'name' attribute in 'item-submission.xml'");
            }
            if (submitNames.contains(submitName)) {
                throw new SAXException("There are two 'submission-process' elements with the name '" + submitName + "' in 'item-submission.xml'.");
            }
            submitNames.add(submitName);
            ArrayList<Map<String, String>> steps = new ArrayList<Map<String, String>>();
            this.submitDefns.put(submitName, steps);
            NodeList pl = nd.getChildNodes();
            int lenStep = pl.getLength();
            for (int j = 0; j < lenStep; ++j) {
                Map<String, String> stepInfo;
                Node nStep = pl.item(j);
                if (!nStep.getNodeName().equals("step")) continue;
                String stepID = this.getAttribute(nStep, "id");
                if (stepID != null && stepID.length() > 0) {
                    if (!this.stepDefns.containsKey(stepID)) throw new SubmissionConfigReaderException("The Submission process config named " + submitName + " contains a step with id=" + stepID + ".  There is no step with this 'id' defined in the 'step-definition' section of 'item-submission.xml'.");
                    stepInfo = this.stepDefns.get(stepID);
                } else {
                    stepInfo = this.processStepChildNodes("submission-process", nStep);
                }
                steps.add(stepInfo);
            }
            if (steps.size() >= 1) continue;
            throw new SubmissionConfigReaderException("Item Submission process config named " + submitName + " has no steps defined in 'item-submission.xml'");
        }
        if (numSubmitProcesses != 0) return;
        throw new SubmissionConfigReaderException("No 'submission-process' elements/definitions found in 'item-submission.xml'");
    }

    private Map<String, String> processStepChildNodes(String configSection, Node nStep) throws SubmissionConfigReaderException {
        String mandatory;
        HashMap<String, String> stepInfo = new HashMap<String, String>();
        NodeList flds = nStep.getChildNodes();
        int lenflds = flds.getLength();
        for (int k = 0; k < lenflds; ++k) {
            Node nfld = flds.item(k);
            String tagName = nfld.getNodeName();
            if (!this.isEmptyTextNode(nfld)) {
                String value = this.getValue(nfld);
                stepInfo.put(tagName, value);
            }
            for (int idx = 0; idx < nfld.getAttributes().getLength(); ++idx) {
                Node nAttr = nfld.getAttributes().item(idx);
                String attrName = nAttr.getNodeName();
                String attrValue = nAttr.getNodeValue();
                stepInfo.put(tagName + "." + attrName, attrValue);
            }
        }
        String stepID = this.getAttribute(nStep, "id");
        if (StringUtils.isNotBlank((CharSequence)stepID)) {
            stepInfo.put("id", stepID);
        }
        if (StringUtils.isNotBlank((CharSequence)(mandatory = this.getAttribute(nStep, "mandatory")))) {
            stepInfo.put("mandatory", mandatory);
        }
        String missing = null;
        if (stepInfo.get("processing-class") == null) {
            missing = "'processing-class'";
        }
        if (missing != null) {
            String msg = "Required field " + missing + " missing in a 'step' in the " + configSection + " of the item submission configuration file ('item-submission.xml')";
            throw new SubmissionConfigReaderException(msg);
        }
        return stepInfo;
    }

    private Node getElement(Node nd) {
        NodeList nl = nd.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            return n;
        }
        return null;
    }

    private boolean isEmptyTextNode(Node nd) {
        String text;
        boolean isEmpty = false;
        if (nd.getNodeType() == 3 && (text = nd.getNodeValue().trim()).length() == 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    private String getAttribute(Node e, String name) {
        NamedNodeMap attrs = e.getAttributes();
        int len = attrs.getLength();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Node attr = attrs.item(i);
                if (!name.equals(attr.getNodeName())) continue;
                return attr.getNodeValue().trim();
            }
        }
        return null;
    }

    private String getValue(Node nd) {
        NodeList nl = nd.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            short type = n.getNodeType();
            if (type != 3) continue;
            return n.getNodeValue().trim();
        }
        return null;
    }

    public List<Collection> getCollectionsBySubmissionConfig(Context context, String submitName) throws IllegalStateException, SQLException {
        ArrayList<Collection> results = new ArrayList<Collection>();
        for (String handle : this.collectionToSubmissionConfig.keySet()) {
            DSpaceObject result;
            if (DEFAULT_COLLECTION.equals(handle) || !this.collectionToSubmissionConfig.get(handle).equals(submitName) || (result = HandleServiceFactory.getInstance().getHandleService().resolveToObject(context, handle)) == null) continue;
            results.add((Collection)result);
        }
        return results;
    }
}

