/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.browse.ItemCountException;
import org.dspace.browse.ItemCounter;
import org.dspace.content.Bitstream;
import org.dspace.content.CacheableDSpaceObject;
import org.dspace.content.Collection;
import org.dspace.content.CollectionNameComparator;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectServiceImpl;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.dao.CollectionDAO;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogHelper;
import org.dspace.core.service.LicenseService;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.eperson.service.SubscribeService;
import org.dspace.event.Event;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.services.ConfigurationService;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.storedcomponents.CollectionRole;
import org.dspace.xmlworkflow.storedcomponents.service.CollectionRoleService;
import org.springframework.beans.factory.annotation.Autowired;

public class CollectionServiceImpl
extends DSpaceObjectServiceImpl<Collection>
implements CollectionService {
    private static final Logger log = LogManager.getLogger(CollectionServiceImpl.class);
    @Autowired(required=true)
    protected CollectionDAO collectionDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ResourcePolicyService resourcePolicyService;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected CommunityService communityService;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected IdentifierService identifierService;
    @Autowired(required=true)
    protected LicenseService licenseService;
    @Autowired(required=true)
    protected SubscribeService subscribeService;
    @Autowired(required=true)
    protected WorkspaceItemService workspaceItemService;
    @Autowired(required=true)
    protected HarvestedCollectionService harvestedCollectionService;
    @Autowired(required=true)
    protected XmlWorkflowFactory workflowFactory;
    @Autowired(required=true)
    protected CollectionRoleService collectionRoleService;
    @Autowired(required=true)
    protected SearchService searchService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;

    protected CollectionServiceImpl() {
    }

    @Override
    public Collection create(Context context, Community community) throws SQLException, AuthorizeException {
        return this.create(context, community, null);
    }

    @Override
    public Collection create(Context context, Community community, String handle) throws SQLException, AuthorizeException {
        return this.create(context, community, handle, null);
    }

    @Override
    public Collection create(Context context, Community community, String handle, UUID uuid) throws SQLException, AuthorizeException {
        if (community == null) {
            throw new IllegalArgumentException("Community cannot be null when creating a new collection.");
        }
        Collection newCollection = uuid != null ? this.collectionDAO.create(context, new Collection(uuid)) : this.collectionDAO.create(context, new Collection());
        this.communityService.addCollection(context, community, newCollection);
        Group anonymousGroup = this.groupService.findByName(context, "Anonymous");
        this.authorizeService.createResourcePolicy(context, newCollection, anonymousGroup, null, 0, null);
        this.authorizeService.createResourcePolicy(context, newCollection, anonymousGroup, null, 10, null);
        this.authorizeService.createResourcePolicy(context, newCollection, anonymousGroup, null, 9, null);
        this.collectionDAO.save(context, newCollection);
        try {
            if (handle == null) {
                this.identifierService.register(context, newCollection);
            } else {
                this.identifierService.register(context, (DSpaceObject)newCollection, handle);
            }
        }
        catch (IllegalStateException | IdentifierException ex) {
            throw new IllegalStateException(ex);
        }
        context.addEvent(new Event(1, 3, newCollection.getID(), newCollection.getHandle(), this.getIdentifiers(context, newCollection)));
        log.info(LogHelper.getHeader(context, "create_collection", "collection_id=" + newCollection.getID()) + ",handle=" + newCollection.getHandle());
        return newCollection;
    }

    @Override
    public List<Collection> findAll(Context context) throws SQLException {
        MetadataField nameField = this.metadataFieldService.findByElement(context, MetadataSchemaEnum.DC.getName(), "title", null);
        if (nameField == null) {
            throw new IllegalArgumentException("Required metadata field '" + MetadataSchemaEnum.DC.getName() + ".title' doesn't exist!");
        }
        return this.collectionDAO.findAll(context, nameField);
    }

    @Override
    public List<Collection> findAll(Context context, Integer limit, Integer offset) throws SQLException {
        MetadataField nameField = this.metadataFieldService.findByElement(context, MetadataSchemaEnum.DC.getName(), "title", null);
        if (nameField == null) {
            throw new IllegalArgumentException("Required metadata field '" + MetadataSchemaEnum.DC.getName() + ".title' doesn't exist!");
        }
        return this.collectionDAO.findAll(context, nameField, limit, offset);
    }

    @Override
    public List<Collection> findAuthorizedOptimized(Context context, int actionID) throws SQLException {
        if (!this.configurationService.getBooleanProperty("org.dspace.content.Collection.findAuthorizedPerformanceOptimize", false)) {
            return this.findAuthorized(context, null, actionID);
        }
        ArrayList<Collection> myResults = new ArrayList<Collection>();
        if (this.authorizeService.isAdmin(context)) {
            return this.findAll(context);
        }
        List<Collection> directToCollection = this.findDirectMapped(context, actionID);
        for (int i = 0; i < directToCollection.size(); ++i) {
            if (myResults.contains(directToCollection.get(i))) continue;
            myResults.add(directToCollection.get(i));
        }
        List<Collection> groupToCollection = this.findGroupMapped(context, actionID);
        for (Collection collection : groupToCollection) {
            if (myResults.contains(collection)) continue;
            myResults.add(collection);
        }
        List<Collection> group2GroupToCollection = this.findGroup2GroupMapped(context, actionID);
        for (Collection aGroup2GroupToCollection : group2GroupToCollection) {
            if (myResults.contains(aGroup2GroupToCollection)) continue;
            myResults.add(aGroup2GroupToCollection);
        }
        List<Collection> list = this.findGroup2CommunityMapped(context);
        for (Collection group2commCollection : list) {
            if (myResults.contains(group2commCollection)) continue;
            myResults.add(group2commCollection);
        }
        Collections.sort(myResults, new CollectionNameComparator());
        return myResults;
    }

    @Override
    public List<Collection> findDirectMapped(Context context, int actionID) throws SQLException {
        return this.collectionDAO.findAuthorized(context, context.getCurrentUser(), Arrays.asList(3, 11));
    }

    @Override
    public List<Collection> findGroup2CommunityMapped(Context context) throws SQLException {
        List<Community> communities = this.communityService.findAuthorizedGroupMapped(context, Arrays.asList(3, 11));
        ArrayList<Collection> collections = new ArrayList<Collection>();
        for (Community community : communities) {
            collections.addAll(community.getCollections());
        }
        return collections;
    }

    @Override
    public List<Collection> findGroup2GroupMapped(Context context, int actionID) throws SQLException {
        return this.collectionDAO.findAuthorizedByGroup(context, context.getCurrentUser(), Collections.singletonList(actionID));
    }

    @Override
    public List<Collection> findGroupMapped(Context context, int actionID) throws SQLException {
        List<Community> communities = this.communityService.findAuthorized(context, Arrays.asList(3, 11));
        ArrayList<Collection> collections = new ArrayList<Collection>();
        for (Community community : communities) {
            collections.addAll(community.getCollections());
        }
        return collections;
    }

    @Override
    public Collection find(Context context, UUID id) throws SQLException {
        return (Collection)this.collectionDAO.findByID(context, Collection.class, id);
    }

    @Override
    public void setMetadataSingleValue(Context context, Collection collection, MetadataFieldName field, String language, String value) throws MissingResourceException, SQLException {
        if (field.equals(MD_NAME) && (value == null || value.trim().equals(""))) {
            try {
                value = I18nUtil.getMessage("org.dspace.content.untitled");
            }
            catch (MissingResourceException e) {
                value = "Untitled";
            }
        }
        if (value == null) {
            this.clearMetadata(context, collection, field.schema, field.element, field.qualifier, "*");
            collection.setMetadataModified();
        } else {
            super.setMetadataSingleValue(context, collection, field, null, value);
        }
        collection.addDetails(field.toString());
    }

    @Override
    public Bitstream setLogo(Context context, Collection collection, InputStream is) throws AuthorizeException, IOException, SQLException {
        if (is != null || !this.authorizeService.authorizeActionBoolean(context, collection, 2)) {
            this.canEdit(context, collection, true);
        }
        if (collection.getLogo() != null) {
            this.bitstreamService.delete(context, collection.getLogo());
        }
        if (is == null) {
            collection.setLogo(null);
            log.info(LogHelper.getHeader(context, "remove_logo", "collection_id=" + collection.getID()));
        } else {
            Bitstream newLogo = this.bitstreamService.create(context, is);
            collection.setLogo(newLogo);
            List<ResourcePolicy> policies = this.authorizeService.getPoliciesActionFilter(context, collection, 0);
            this.authorizeService.addPolicies(context, policies, newLogo);
            log.info(LogHelper.getHeader(context, "set_logo", "collection_id=" + collection.getID() + "logo_bitstream_id=" + newLogo.getID()));
        }
        collection.setModified();
        return collection.getLogo();
    }

    @Override
    public Group createWorkflowGroup(Context context, Collection collection, int step) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageWorkflowsGroup(context, collection);
        if (this.getWorkflowGroup(context, collection, step) == null) {
            context.turnOffAuthorisationSystem();
            Group g = this.groupService.create(context);
            this.groupService.setName(g, "COLLECTION_" + collection.getID() + "_WORKFLOW_STEP_" + step);
            this.groupService.update(context, g);
            context.restoreAuthSystemState();
            this.setWorkflowGroup(context, collection, step, g);
        }
        return this.getWorkflowGroup(context, collection, step);
    }

    @Override
    public void setWorkflowGroup(Context context, Collection collection, int step, Group group) throws SQLException {
        Workflow workflow = null;
        try {
            workflow = this.workflowFactory.getWorkflow(collection);
        }
        catch (WorkflowConfigurationException e) {
            log.error(LogHelper.getHeader(context, "setWorkflowGroup", "collection_id=" + collection.getID() + " " + e.getMessage()), (Throwable)e);
        }
        if (!StringUtils.equals((CharSequence)this.workflowFactory.getDefaultWorkflow().getID(), (CharSequence)workflow.getID())) {
            throw new IllegalArgumentException("setWorkflowGroup can be used only on collection with the default basic dspace workflow. Instead, the collection: " + collection.getID() + " has the workflow: " + workflow.getID());
        }
        String roleId = switch (step) {
            case 1 -> "reviewer";
            case 2 -> "editor";
            case 3 -> "finaleditor";
            default -> throw new IllegalArgumentException("Illegal step count: " + step);
        };
        CollectionRole colRole = this.collectionRoleService.find(context, collection, roleId);
        if (colRole == null) {
            if (group != null) {
                colRole = this.collectionRoleService.create(context, collection, roleId, group);
            }
        } else if (group != null) {
            colRole.setGroup(group);
            this.collectionRoleService.update(context, colRole);
        } else {
            this.collectionRoleService.delete(context, colRole);
        }
        collection.setModified();
    }

    @Override
    public Group getWorkflowGroup(Context context, Collection collection, int step) {
        String roleId = switch (step) {
            case 1 -> "reviewer";
            case 2 -> "editor";
            case 3 -> "finaleditor";
            default -> throw new IllegalArgumentException("Illegal step count: " + step);
        };
        try {
            CollectionRole colRole = this.collectionRoleService.find(context, collection, roleId);
            if (colRole != null) {
                return colRole.getGroup();
            }
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Group createSubmitters(Context context, Collection collection) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageSubmittersGroup(context, collection);
        Group submitters = collection.getSubmitters();
        if (submitters == null) {
            context.turnOffAuthorisationSystem();
            submitters = this.groupService.create(context);
            context.restoreAuthSystemState();
            this.groupService.setName(submitters, "COLLECTION_" + collection.getID() + "_SUBMIT");
            this.groupService.update(context, submitters);
        }
        collection.setSubmitters(submitters);
        this.authorizeService.addPolicy(context, (DSpaceObject)collection, 3, submitters);
        return submitters;
    }

    @Override
    public void removeSubmitters(Context context, Collection collection) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageSubmittersGroup(context, collection);
        if (collection.getSubmitters() == null) {
            return;
        }
        collection.setSubmitters(null);
    }

    @Override
    public Group createAdministrators(Context context, Collection collection) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageAdminGroup(context, collection);
        Group admins = collection.getAdministrators();
        if (admins == null) {
            context.turnOffAuthorisationSystem();
            admins = this.groupService.create(context);
            context.restoreAuthSystemState();
            this.groupService.setName(admins, "COLLECTION_" + collection.getID() + "_ADMIN");
            this.groupService.update(context, admins);
        }
        this.authorizeService.addPolicy(context, (DSpaceObject)collection, 11, admins);
        collection.setAdmins(admins);
        context.addEvent(new Event(2, 3, collection.getID(), null, this.getIdentifiers(context, collection)));
        return admins;
    }

    @Override
    public void removeAdministrators(Context context, Collection collection) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeRemoveAdminGroup(context, collection);
        Group admins = collection.getAdministrators();
        if (admins == null) {
            return;
        }
        collection.setAdmins(null);
        context.addEvent(new Event(2, 3, collection.getID(), null, this.getIdentifiers(context, collection)));
    }

    @Override
    public String getLicense(Collection collection) {
        String license = this.getMetadataFirstValue(collection, CollectionService.MD_LICENSE, "*");
        if (license == null || license.trim().equals("")) {
            license = this.licenseService.getDefaultSubmissionLicense();
        }
        return license;
    }

    @Override
    public boolean hasCustomLicense(Collection collection) {
        String license = collection.getLicenseCollection();
        return StringUtils.isNotBlank((CharSequence)license);
    }

    @Override
    public void createTemplateItem(Context context, Collection collection) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageTemplateItem(context, collection);
        if (collection.getTemplateItem() == null) {
            Item template = this.itemService.createTemplateItem(context, collection);
            collection.setTemplateItem(template);
            log.info(LogHelper.getHeader(context, "create_template_item", "collection_id=" + collection.getID() + ",template_item_id=" + template.getID()));
        }
    }

    @Override
    public void removeTemplateItem(Context context, Collection collection) throws SQLException, AuthorizeException, IOException {
        AuthorizeUtil.authorizeManageTemplateItem(context, collection);
        Item template = collection.getTemplateItem();
        if (template != null) {
            log.info(LogHelper.getHeader(context, "remove_template_item", "collection_id=" + collection.getID() + ",template_item_id=" + template.getID()));
            context.turnOffAuthorisationSystem();
            collection.setTemplateItem(null);
            this.itemService.delete(context, template);
            context.restoreAuthSystemState();
        }
        context.addEvent(new Event(2, 3, collection.getID(), "remove_template_item", this.getIdentifiers(context, collection)));
    }

    @Override
    public void addItem(Context context, Collection collection, Item item) throws SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, collection, 3);
        log.info(LogHelper.getHeader(context, "add_item", "collection_id=" + collection.getID() + ",item_id=" + item.getID()));
        if (!item.getCollections().contains(collection)) {
            item.addCollection(collection);
        }
        context.addEvent(new Event(8, 3, collection.getID(), 2, item.getID(), item.getHandle(), this.getIdentifiers(context, collection)));
    }

    @Override
    public void removeItem(Context context, Collection collection, Item item) throws SQLException, AuthorizeException, IOException {
        this.authorizeService.authorizeAction(context, collection, 4);
        if (item.getCollections().size() == 1) {
            this.itemService.delete(context, item);
        } else {
            item.removeCollection(collection);
        }
        context.addEvent(new Event(16, 3, collection.getID(), 2, item.getID(), item.getHandle(), this.getIdentifiers(context, collection)));
    }

    @Override
    public void update(Context context, Collection collection) throws SQLException, AuthorizeException {
        this.canEdit(context, collection, true);
        log.info(LogHelper.getHeader(context, "update_collection", "collection_id=" + collection.getID()));
        super.update(context, collection);
        this.collectionDAO.save(context, collection);
        if (collection.isModified()) {
            context.addEvent(new Event(2, 3, collection.getID(), null, this.getIdentifiers(context, collection)));
            collection.clearModified();
        }
        if (collection.isMetadataModified()) {
            context.addEvent(new Event(4, 3, collection.getID(), collection.getDetails(), this.getIdentifiers(context, collection)));
            collection.clearModified();
        }
        collection.clearDetails();
    }

    @Override
    public boolean canEditBoolean(Context context, Collection collection) throws SQLException {
        return this.canEditBoolean(context, collection, true);
    }

    @Override
    public boolean canEditBoolean(Context context, Collection collection, boolean useInheritance) throws SQLException {
        try {
            this.canEdit(context, collection, useInheritance);
            return true;
        }
        catch (AuthorizeException e) {
            return false;
        }
    }

    @Override
    public void canEdit(Context context, Collection collection) throws SQLException, AuthorizeException {
        this.canEdit(context, collection, true);
    }

    @Override
    public void canEdit(Context context, Collection collection, boolean useInheritance) throws SQLException, AuthorizeException {
        List<Community> parents = this.communityService.getAllParents(context, collection);
        for (Community parent : parents) {
            if (this.authorizeService.authorizeActionBoolean(context, parent, 1, useInheritance)) {
                return;
            }
            if (!this.authorizeService.authorizeActionBoolean(context, parent, 3, useInheritance)) continue;
            return;
        }
        this.authorizeService.authorizeAction(context, collection, 1, useInheritance);
    }

    @Override
    public void delete(Context context, Collection collection) throws SQLException, AuthorizeException, IOException {
        log.info(LogHelper.getHeader(context, "delete_collection", "collection_id=" + collection.getID()));
        HarvestedCollection hc = this.harvestedCollectionService.find(context, collection);
        if (hc != null) {
            this.harvestedCollectionService.delete(context, hc);
        }
        context.addEvent(new Event(32, 3, collection.getID(), collection.getHandle(), this.getIdentifiers(context, collection)));
        this.subscribeService.deleteByDspaceObject(context, collection);
        this.removeTemplateItem(context, collection);
        Iterator<Item> items = this.itemService.findAllByCollection(context, collection);
        while (items.hasNext()) {
            Item item = items.next();
            if (this.itemService.isOwningCollection(item, collection)) {
                this.itemService.delete(context, item);
                continue;
            }
            this.removeItem(context, collection, item);
        }
        this.setLogo(context, collection, null);
        Iterator<WorkspaceItem> workspaceItems = this.workspaceItemService.findByCollection(context, collection).iterator();
        while (workspaceItems.hasNext()) {
            WorkspaceItem workspaceItem = workspaceItems.next();
            workspaceItems.remove();
            this.workspaceItemService.deleteAll(context, workspaceItem);
        }
        WorkflowServiceFactory.getInstance().getWorkflowService().deleteCollection(context, collection);
        WorkflowServiceFactory.getInstance().getWorkflowItemService().deleteByCollection(context, collection);
        this.handleService.unbindHandle(context, collection);
        this.collectionRoleService.deleteByCollection(context, collection);
        collection.getResourcePolicies().clear();
        Group g = collection.getAdministrators();
        if (g != null) {
            collection.setAdmins(null);
            this.groupService.delete(context, g);
        }
        if ((g = collection.getSubmitters()) != null) {
            collection.setSubmitters(null);
            this.groupService.delete(context, g);
        }
        for (Community owningCommunity : collection.getCommunities()) {
            collection.removeCommunity(owningCommunity);
            owningCommunity.removeCollection(collection);
        }
        this.collectionDAO.delete(context, collection);
    }

    @Override
    public int getSupportsTypeConstant() {
        return 3;
    }

    @Override
    public List<Collection> findAuthorized(Context context, Community community, int actionID) throws SQLException {
        ArrayList<Collection> myResults = new ArrayList<Collection>();
        List<Collection> myCollections = community != null ? community.getCollections() : this.findAll(context);
        for (Collection myCollection : myCollections) {
            if (!this.authorizeService.authorizeActionBoolean(context, myCollection, actionID)) continue;
            myResults.add(myCollection);
        }
        return myResults;
    }

    @Override
    public Collection findByGroup(Context context, Group group) throws SQLException {
        return this.collectionDAO.findByGroup(context, group);
    }

    @Override
    public List<Collection> findCollectionsWithSubscribers(Context context) throws SQLException {
        return this.collectionDAO.findCollectionsWithSubscribers(context);
    }

    @Override
    public DSpaceObject getAdminObject(Context context, Collection collection, int action) throws SQLException {
        CacheableDSpaceObject adminObject = null;
        Community community = null;
        List<Community> communities = collection.getCommunities();
        if (CollectionUtils.isNotEmpty(communities)) {
            community = communities.get(0);
        }
        switch (action) {
            case 4: {
                if (AuthorizeConfiguration.canCollectionAdminPerformItemDeletion()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformItemDeletion()) break;
                adminObject = community;
                break;
            }
            case 2: {
                if (!AuthorizeConfiguration.canCommunityAdminPerformSubelementDeletion()) break;
                adminObject = community;
                break;
            }
            default: {
                adminObject = collection;
            }
        }
        return adminObject;
    }

    @Override
    public DSpaceObject getParentObject(Context context, Collection collection) throws SQLException {
        List<Community> communities = collection.getCommunities();
        if (CollectionUtils.isNotEmpty(communities)) {
            return communities.get(0);
        }
        return null;
    }

    @Override
    public void updateLastModified(Context context, Collection collection) throws SQLException, AuthorizeException {
        context.addEvent(new Event(2, 3, collection.getID(), null, this.getIdentifiers(context, collection)));
    }

    @Override
    public Collection findByIdOrLegacyId(Context context, String id) throws SQLException {
        try {
            if (StringUtils.isNumeric((CharSequence)id)) {
                return this.findByLegacyId(context, Integer.parseInt(id));
            }
            return this.find(context, UUID.fromString(id));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Collection findByLegacyId(Context context, int id) throws SQLException {
        return this.collectionDAO.findByLegacyId(context, id, Collection.class);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.collectionDAO.countRows(context);
    }

    @Override
    public List<Map.Entry<Collection, Long>> getCollectionsWithBitstreamSizesTotal(Context context) throws SQLException {
        return this.collectionDAO.getCollectionsWithBitstreamSizesTotal(context);
    }

    @Override
    public Group createDefaultReadGroup(Context context, Collection collection, String typeOfGroupString, int defaultRead) throws SQLException, AuthorizeException {
        Group role = this.groupService.create(context);
        this.groupService.setName(role, this.getDefaultReadGroupName(collection, typeOfGroupString));
        this.authorizeService.removePoliciesActionFilter(context, collection, defaultRead);
        this.authorizeService.addPolicy(context, (DSpaceObject)collection, defaultRead, role);
        this.groupService.update(context, role);
        return role;
    }

    @Override
    public String getDefaultReadGroupName(Collection collection, String typeOfGroupString) {
        return "COLLECTION_" + collection.getID().toString() + "_" + typeOfGroupString + "_DEFAULT_READ";
    }

    @Override
    public List<Collection> findCollectionsWithSubmit(String q, Context context, Community community, int offset, int limit) throws SQLException, SearchServiceException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.setDSpaceObjectFilter(IndexableCollection.TYPE);
        discoverQuery.setStart(offset);
        discoverQuery.setMaxResults(limit);
        discoverQuery.setSortField("dc.title_sort", DiscoverQuery.SORT_ORDER.asc);
        DiscoverResult resp = this.retrieveCollectionsWithSubmit(context, discoverQuery, null, community, q);
        for (IndexableObject solrCollections : resp.getIndexableObjects()) {
            Collection c = (Collection)((IndexableCollection)solrCollections).getIndexedObject();
            collections.add(c);
        }
        return collections;
    }

    @Override
    public int countCollectionsWithSubmit(String q, Context context, Community community) throws SQLException, SearchServiceException {
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.setMaxResults(0);
        discoverQuery.setDSpaceObjectFilter(IndexableCollection.TYPE);
        DiscoverResult resp = this.retrieveCollectionsWithSubmit(context, discoverQuery, null, community, q);
        return (int)resp.getTotalSearchResults();
    }

    private DiscoverResult retrieveCollectionsWithSubmit(Context context, DiscoverQuery discoverQuery, String entityType, Community community, String q) throws SQLException, SearchServiceException {
        StringBuilder query = new StringBuilder();
        EPerson currentUser = context.getCurrentUser();
        if (!this.authorizeService.isAdmin(context)) {
            String userId = "";
            if (currentUser != null) {
                userId = currentUser.getID().toString();
            }
            query.append("submit:(e").append(userId);
            Set<Group> groups = this.groupService.allMemberGroupsSet(context, currentUser);
            for (Group group : groups) {
                query.append(" OR g").append(group.getID());
            }
            query.append(")");
            discoverQuery.addFilterQueries(query.toString());
        }
        if (Objects.nonNull(community)) {
            discoverQuery.addFilterQueries("location.comm:" + community.getID().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)entityType)) {
            discoverQuery.addFilterQueries("search.entitytype:" + entityType);
        }
        if (StringUtils.isNotBlank((CharSequence)q)) {
            StringBuilder buildQuery = new StringBuilder();
            String escapedQuery = ClientUtils.escapeQueryChars((String)q);
            buildQuery.append("(").append(escapedQuery).append(" OR ").append(escapedQuery).append("*").append(")");
            discoverQuery.setQuery(buildQuery.toString());
        }
        DiscoverResult resp = this.searchService.search(context, discoverQuery);
        return resp;
    }

    @Override
    public Collection retrieveCollectionWithSubmitByEntityType(Context context, Item item, String entityType) throws SQLException {
        Collection ownCollection = item.getOwningCollection();
        return this.retrieveWithSubmitCollectionByEntityType(context, ownCollection.getCommunities(), entityType);
    }

    private Collection retrieveWithSubmitCollectionByEntityType(Context context, List<Community> communities, String entityType) {
        for (Community community : communities) {
            Collection collection = this.retrieveCollectionWithSubmitByCommunityAndEntityType(context, community, entityType);
            if (collection == null) continue;
            return collection;
        }
        for (Community community : communities) {
            List<Community> parentCommunities = community.getParentCommunities();
            Collection collection = this.retrieveWithSubmitCollectionByEntityType(context, parentCommunities, entityType);
            if (collection == null) continue;
            return collection;
        }
        return this.retrieveCollectionWithSubmitByCommunityAndEntityType(context, null, entityType);
    }

    @Override
    public Collection retrieveCollectionWithSubmitByCommunityAndEntityType(Context context, Community community, String entityType) {
        List<Collection> collections;
        context.turnOffAuthorisationSystem();
        try {
            collections = this.findCollectionsWithSubmit(null, context, community, entityType, 0, 1);
        }
        catch (SQLException | SearchServiceException e) {
            throw new RuntimeException(e);
        }
        context.restoreAuthSystemState();
        if (collections != null && collections.size() > 0) {
            return collections.get(0);
        }
        if (community != null) {
            for (Community subCommunity : community.getSubcommunities()) {
                Collection collection = this.retrieveCollectionWithSubmitByCommunityAndEntityType(context, subCommunity, entityType);
                if (collection == null) continue;
                return collection;
            }
        }
        return null;
    }

    @Override
    public List<Collection> findCollectionsWithSubmit(String q, Context context, Community community, String entityType, int offset, int limit) throws SQLException, SearchServiceException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.setDSpaceObjectFilter(IndexableCollection.TYPE);
        discoverQuery.setStart(offset);
        discoverQuery.setMaxResults(limit);
        discoverQuery.setSortField("dc.title_sort", DiscoverQuery.SORT_ORDER.asc);
        DiscoverResult resp = this.retrieveCollectionsWithSubmit(context, discoverQuery, entityType, community, q);
        for (IndexableObject solrCollections : resp.getIndexableObjects()) {
            Collection c = (Collection)((IndexableCollection)solrCollections).getIndexedObject();
            collections.add(c);
        }
        return collections;
    }

    @Override
    public int countCollectionsWithSubmit(String q, Context context, Community community, String entityType) throws SQLException, SearchServiceException {
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.setMaxResults(0);
        discoverQuery.setDSpaceObjectFilter(IndexableCollection.TYPE);
        DiscoverResult resp = this.retrieveCollectionsWithSubmit(context, discoverQuery, entityType, community, q);
        return (int)resp.getTotalSearchResults();
    }

    @Override
    public List<Collection> findAllCollectionsByEntityType(Context context, String entityType) throws SearchServiceException {
        ArrayList<Collection> collectionList = new ArrayList<Collection>();
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.setDSpaceObjectFilter(IndexableCollection.TYPE);
        discoverQuery.addFilterQueries("dspace.entity.type:" + entityType);
        DiscoverResult discoverResult = this.searchService.search(context, discoverQuery);
        List<IndexableObject> solrIndexableObjects = discoverResult.getIndexableObjects();
        for (IndexableObject solrCollection : solrIndexableObjects) {
            Collection c = (Collection)((IndexableCollection)solrCollection).getIndexedObject();
            collectionList.add(c);
        }
        return collectionList;
    }

    @Override
    public int countArchivedItems(Collection collection) throws ItemCountException {
        return ItemCounter.getInstance().getCount(collection);
    }
}

