/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.MetadataValue;
import org.dspace.core.ReloadableEntity;
import org.dspace.handle.Handle;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="dspaceobject")
public abstract class DSpaceObject
implements Serializable,
ReloadableEntity<UUID> {
    @Id
    @GeneratedValue(generator="predefined-uuid")
    @GenericGenerator(name="predefined-uuid", strategy="org.dspace.content.PredefinedUUIDGenerator")
    @Column(name="uuid", unique=true, nullable=false, insertable=true, updatable=false)
    protected UUID id;
    @Transient
    private StringBuffer eventDetails = null;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dSpaceObject", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="metadataField, place")
    private List<MetadataValue> metadata = new ArrayList<MetadataValue>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dso")
    @OrderBy(value="id ASC")
    private List<Handle> handles = new ArrayList<Handle>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dSpaceObject", cascade={CascadeType.ALL})
    private final List<ResourcePolicy> resourcePolicies = new ArrayList<ResourcePolicy>();
    @Transient
    private boolean modifiedMetadata = false;
    @Transient
    private boolean modified = false;
    @Transient
    protected UUID predefinedUUID;

    public UUID getPredefinedUUID() {
        return this.predefinedUUID;
    }

    protected DSpaceObject() {
    }

    public void clearDetails() {
        this.eventDetails = null;
    }

    protected void addDetails(String d) {
        if (this.eventDetails == null) {
            this.eventDetails = new StringBuffer(d);
        } else {
            this.eventDetails.append(", ").append(d);
        }
    }

    public String getDetails() {
        return this.eventDetails == null ? null : this.eventDetails.toString();
    }

    public abstract int getType();

    @Override
    public UUID getID() {
        return this.id;
    }

    public abstract String getName();

    public String getHandle() {
        return CollectionUtils.isNotEmpty(this.handles) ? this.handles.get(0).getHandle() : null;
    }

    void setHandle(List<Handle> handle) {
        this.handles = handle;
    }

    public void addHandle(Handle handle) {
        this.handles.add(handle);
    }

    public List<Handle> getHandles() {
        return this.handles;
    }

    public List<MetadataValue> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<MetadataValue> metadata) {
        this.metadata = metadata;
    }

    protected void removeMetadata(MetadataValue metadataValue) {
        this.setMetadataModified();
        this.getMetadata().remove(metadataValue);
    }

    protected void removeMetadata(List<MetadataValue> metadataValues) {
        this.setMetadataModified();
        this.getMetadata().removeAll(metadataValues);
    }

    protected void addMetadata(MetadataValue metadataValue) {
        this.setMetadataModified();
        this.getMetadata().add(metadataValue);
        this.addDetails(metadataValue.getMetadataField().toString());
    }

    public List<ResourcePolicy> getResourcePolicies() {
        return this.resourcePolicies;
    }

    public boolean isMetadataModified() {
        return this.modifiedMetadata;
    }

    protected void setMetadataModified() {
        this.modifiedMetadata = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void clearModified() {
        this.modified = false;
    }

    protected void setModified() {
        this.modified = true;
    }
}

