/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external;

import jakarta.el.MethodNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.service.components.QuerySource;

public class MultipleParallelImportMetadataSourceServiceImpl
implements QuerySource {
    private final List<QuerySource> innerProviders;
    private final ExecutorService executorService;
    private final String sourceName;

    public MultipleParallelImportMetadataSourceServiceImpl(List<QuerySource> innerProviders, String sourceName) {
        this.innerProviders = innerProviders;
        this.executorService = Executors.newFixedThreadPool(innerProviders.size());
        this.sourceName = sourceName;
    }

    @Override
    public String getImportSource() {
        return this.sourceName;
    }

    @Override
    public ImportRecord getRecord(String recordId) throws MetadataSourceException {
        ArrayList<Future<ImportRecord>> futureList = new ArrayList<Future<ImportRecord>>();
        ImportRecord result = null;
        for (QuerySource querySource : this.innerProviders) {
            futureList.add(this.executorService.submit(() -> innerProvider.getRecord(recordId)));
        }
        for (Future future : futureList) {
            try {
                ImportRecord importRecord = (ImportRecord)future.get();
                if (Objects.isNull(importRecord)) continue;
                result = importRecord;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        ArrayList<Future<Integer>> futureList = new ArrayList<Future<Integer>>();
        int result = 0;
        for (QuerySource querySource : this.innerProviders) {
            futureList.add(this.executorService.submit(() -> innerProvider.getRecordsCount(query)));
        }
        for (Future future : futureList) {
            try {
                Integer count = (Integer)future.get();
                result += Objects.isNull(count) ? 0 : count;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        ArrayList<Future<Integer>> futureList = new ArrayList<Future<Integer>>();
        int result = 0;
        for (QuerySource querySource : this.innerProviders) {
            futureList.add(this.executorService.submit(() -> innerProvider.getRecordsCount(query)));
        }
        for (Future future : futureList) {
            try {
                Integer count = (Integer)future.get();
                result += Objects.isNull(count) ? 0 : count;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        ArrayList<Future<Collection>> futureList = new ArrayList<Future<Collection>>();
        ArrayList<ImportRecord> result = new ArrayList<ImportRecord>();
        for (QuerySource querySource : this.innerProviders) {
            futureList.add(this.executorService.submit(() -> innerProvider.getRecords(query, start, count)));
        }
        for (Future future : futureList) {
            try {
                Collection importRecords = (Collection)future.get();
                result.addAll(Objects.isNull(importRecords) ? Collections.emptyList() : importRecords);
            }
            catch (InterruptedException | ExecutionException exception) {}
        }
        return result;
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        ArrayList<Future<Collection>> futureList = new ArrayList<Future<Collection>>();
        ArrayList<ImportRecord> result = new ArrayList<ImportRecord>();
        for (QuerySource querySource : this.innerProviders) {
            futureList.add(this.executorService.submit(() -> innerProvider.getRecords(query)));
        }
        for (Future future : futureList) {
            try {
                Collection importRecords = (Collection)future.get();
                result.addAll(Objects.isNull(importRecords) ? Collections.emptyList() : importRecords);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        throw new MethodNotFoundException("This method is not implemented for multiple external data sources");
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        ArrayList<Future<Collection>> futureList = new ArrayList<Future<Collection>>();
        ArrayList<ImportRecord> result = new ArrayList<ImportRecord>();
        for (QuerySource querySource : this.innerProviders) {
            futureList.add(this.executorService.submit(() -> innerProvider.findMatchingRecords(query)));
        }
        for (Future future : futureList) {
            try {
                Collection importRecords = (Collection)future.get();
                result.addAll(Objects.isNull(importRecords) ? Collections.emptyList() : importRecords);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        ArrayList<Future<Collection>> futureList = new ArrayList<Future<Collection>>();
        ArrayList<ImportRecord> result = new ArrayList<ImportRecord>();
        for (QuerySource querySource : this.innerProviders) {
            futureList.add(this.executorService.submit(() -> innerProvider.findMatchingRecords(item)));
        }
        for (Future future : futureList) {
            try {
                Collection importRecords = (Collection)future.get();
                result.addAll(Objects.isNull(importRecords) ? Collections.emptyList() : importRecords);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

