/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.service;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DoiCheck {
    private static final List<String> DOI_PREFIXES = Arrays.asList("http://dx.doi.org/", "https://dx.doi.org/");
    private static final Pattern PATTERN = Pattern.compile("10.\\d{4,9}/[-._;()/:A-Z0-9]+|10.1002/[^\\s]+|10.\\d{4}/\\d+-\\d+X?(\\d+)\\d+<[\\d\\w]+:[\\d\\w]*>\\d+.\\d+.\\w+;\\d|10.1021/\\w\\w\\d++|10.1207/[\\w\\d]+\\&\\d+_\\d+", 2);

    private DoiCheck() {
    }

    public static boolean isDoi(String value) {
        Matcher m = PATTERN.matcher(DoiCheck.purgeDoiValue(value));
        return m.matches();
    }

    public static String purgeDoiValue(String query) {
        String value = query.replaceAll(",", "");
        for (String prefix : DOI_PREFIXES) {
            value = value.replaceAll(prefix, "");
        }
        return value.trim();
    }
}

