/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.profile;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.app.exception.ResourceAlreadyExistsException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.orcid.service.OrcidSynchronizationService;
import org.dspace.profile.ResearcherProfile;
import org.dspace.profile.service.AfterResearcherProfileCreationAction;
import org.dspace.profile.service.ResearcherProfileService;
import org.dspace.services.ConfigurationService;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class ResearcherProfileServiceImpl
implements ResearcherProfileService {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private ItemService itemService;
    @Autowired
    private WorkspaceItemService workspaceItemService;
    @Autowired
    private InstallItemService installItemService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OrcidSynchronizationService orcidSynchronizationService;
    @Autowired(required=false)
    private List<AfterResearcherProfileCreationAction> afterCreationActions;

    @PostConstruct
    public void postConstruct() {
        if (this.afterCreationActions == null) {
            this.afterCreationActions = Collections.emptyList();
        }
    }

    @Override
    public ResearcherProfile findById(Context context, UUID id) throws SQLException, AuthorizeException {
        Assert.notNull((Object)id, (String)"An id must be provided to find a researcher profile");
        Item profileItem = this.findResearcherProfileItemById(context, id);
        if (profileItem == null) {
            return null;
        }
        return new ResearcherProfile(profileItem);
    }

    @Override
    public ResearcherProfile createAndReturn(Context context, EPerson ePerson) throws AuthorizeException, SQLException, SearchServiceException {
        Item profileItem = this.findResearcherProfileItemById(context, ePerson.getID());
        if (profileItem != null) {
            throw new ResourceAlreadyExistsException("A profile is already linked to the provided User");
        }
        Collection collection = this.findProfileCollection(context).orElseThrow(() -> new IllegalStateException("No collection found for researcher profiles"));
        context.turnOffAuthorisationSystem();
        Item item = this.createProfileItem(context, ePerson, collection);
        context.restoreAuthSystemState();
        ResearcherProfile researcherProfile = new ResearcherProfile(item);
        for (AfterResearcherProfileCreationAction afterCreationAction : this.afterCreationActions) {
            afterCreationAction.perform(context, researcherProfile, ePerson);
        }
        return researcherProfile;
    }

    @Override
    public void deleteById(Context context, UUID id) throws SQLException, AuthorizeException {
        Assert.notNull((Object)id, (String)"An id must be provided to find a researcher profile");
        Item profileItem = this.findResearcherProfileItemById(context, id);
        if (profileItem == null) {
            return;
        }
        if (this.isHardDeleteEnabled()) {
            this.deleteItem(context, profileItem);
        } else {
            this.removeOwnerMetadata(context, profileItem);
            this.orcidSynchronizationService.unlinkProfile(context, profileItem);
        }
    }

    @Override
    public void changeVisibility(Context context, ResearcherProfile profile, boolean visible) throws AuthorizeException, SQLException {
        if (profile.isVisible() == visible) {
            return;
        }
        Item item = profile.getItem();
        Group anonymous = this.groupService.findByName(context, "Anonymous");
        if (visible) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, 0, anonymous);
        } else {
            this.authorizeService.removeGroupPolicies(context, item, anonymous);
        }
    }

    @Override
    public ResearcherProfile claim(Context context, EPerson ePerson, URI uri) throws SQLException, AuthorizeException, SearchServiceException {
        Item profileItem = this.findResearcherProfileItemById(context, ePerson.getID());
        if (profileItem != null) {
            throw new ResourceAlreadyExistsException("A profile is already linked to the provided User");
        }
        Item item = this.findItemByURI(context, uri).orElseThrow(() -> new IllegalArgumentException("No item found by URI " + uri));
        if (!item.isArchived() || item.isWithdrawn()) {
            throw new IllegalArgumentException("Only archived items can be claimed to create a researcher profile. Item ID: " + item.getID());
        }
        if (!this.hasProfileType(item)) {
            throw new IllegalArgumentException("The provided item has not a profile type. Item ID: " + item.getID());
        }
        if (this.haveDifferentEmail(item, ePerson)) {
            throw new IllegalArgumentException("The provided item is not claimable because it has a different email than the given user's email. Item ID: " + item.getID());
        }
        String existingOwner = this.itemService.getMetadataFirstValue(item, "dspace", "object", "owner", "*");
        if (StringUtils.isNotBlank((String)existingOwner)) {
            throw new IllegalArgumentException("Item with provided uri has already an owner - ID: " + existingOwner);
        }
        context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(context, item, "dspace", "object", "owner", null, ePerson.getName(), ePerson.getID().toString(), 600);
        context.restoreAuthSystemState();
        return new ResearcherProfile(item);
    }

    @Override
    public boolean hasProfileType(Item item) {
        String profileType = this.getProfileType();
        if (StringUtils.isBlank((String)profileType)) {
            return false;
        }
        return profileType.equals(this.itemService.getEntityTypeLabel(item));
    }

    @Override
    public String getProfileType() {
        return this.configurationService.getProperty("researcher-profile.entity-type", "Person");
    }

    private Optional<Item> findItemByURI(Context context, URI uri) throws SQLException {
        String path = uri.getPath();
        UUID uuid = UUIDUtils.fromString(path.substring(path.lastIndexOf("/") + 1));
        return Optional.ofNullable((Item)this.itemService.find(context, uuid));
    }

    private Item findResearcherProfileItemById(Context context, UUID id) throws SQLException, AuthorizeException {
        String profileType = this.getProfileType();
        Iterator<Item> items = this.itemService.findByAuthorityValue(context, "dspace", "object", "owner", id.toString());
        while (items.hasNext()) {
            Item item = items.next();
            String entityType = this.itemService.getEntityTypeLabel(item);
            if (!profileType.equals(entityType)) continue;
            return item;
        }
        return null;
    }

    private Optional<Collection> findProfileCollection(Context context) throws SQLException, SearchServiceException {
        return this.findConfiguredProfileCollection(context).or(() -> this.findFirstCollectionByProfileEntityType(context));
    }

    private Item createProfileItem(Context context, EPerson ePerson, Collection collection) throws AuthorizeException, SQLException {
        String id = ePerson.getID().toString();
        String fullName = ePerson.getFullName();
        WorkspaceItem workspaceItem = this.workspaceItemService.create(context, collection, true);
        Item item = workspaceItem.getItem();
        this.itemService.addMetadata(context, item, "dc", "title", null, null, fullName);
        this.itemService.addMetadata(context, item, "person", "email", null, null, ePerson.getEmail());
        this.itemService.addMetadata(context, item, "dspace", "object", "owner", null, fullName, id, 600);
        item = this.installItemService.installItem(context, workspaceItem);
        if (this.isNewProfileNotVisibleByDefault()) {
            Group anonymous = this.groupService.findByName(context, "Anonymous");
            this.authorizeService.removeGroupPolicies(context, item, anonymous);
        }
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 0, ePerson);
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 1, ePerson);
        return this.reloadItem(context, item);
    }

    private Optional<Collection> findConfiguredProfileCollection(Context context) throws SQLException {
        UUID uuid = UUIDUtils.fromString(this.configurationService.getProperty("researcher-profile.collection.uuid"));
        if (uuid == null) {
            return Optional.empty();
        }
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            return Optional.empty();
        }
        if (this.isNotProfileCollection(collection)) {
            log.warn("The configured researcher-profile.collection.uuid has an invalid entity type, expected {}", new Supplier[]{this::getProfileType});
            return Optional.empty();
        }
        return Optional.of(collection);
    }

    private Optional<Collection> findFirstCollectionByProfileEntityType(Context context) {
        String profileType = this.getProfileType();
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.setDSpaceObjectFilter(IndexableCollection.TYPE);
        discoverQuery.addFilterQueries("dspace.entity.type:" + profileType);
        DiscoverResult discoverResult = this.search(context, discoverQuery);
        List<IndexableObject> indexableObjects = discoverResult.getIndexableObjects();
        if (CollectionUtils.isEmpty(indexableObjects)) {
            return Optional.empty();
        }
        return Optional.ofNullable((Collection)indexableObjects.get(0).getIndexedObject());
    }

    private boolean isHardDeleteEnabled() {
        return this.configurationService.getBooleanProperty("researcher-profile.hard-delete.enabled");
    }

    private boolean isNewProfileNotVisibleByDefault() {
        return !this.configurationService.getBooleanProperty("researcher-profile.set-new-profile-visible");
    }

    private boolean isNotProfileCollection(Collection collection) {
        String entityType = this.collectionService.getMetadataFirstValue(collection, "dspace", "entity", "type", "*");
        return entityType == null || !entityType.equals(this.getProfileType());
    }

    private boolean haveDifferentEmail(Item item, EPerson currentUser) {
        return this.itemService.getMetadataByMetadataString(item, "person.email").stream().map(MetadataValue::getValue).filter(StringUtils::isNotBlank).noneMatch(email -> email.equalsIgnoreCase(currentUser.getEmail()));
    }

    private void removeOwnerMetadata(Context context, Item profileItem) throws SQLException {
        List<MetadataValue> metadata = this.itemService.getMetadata(profileItem, "dspace", "object", "owner", "*");
        this.itemService.removeMetadataValues(context, profileItem, metadata);
    }

    private Item reloadItem(Context context, Item item) throws SQLException {
        context.uncacheEntity(item);
        return context.reloadEntity(item);
    }

    private void deleteItem(Context context, Item profileItem) throws SQLException, AuthorizeException {
        try {
            context.turnOffAuthorisationSystem();
            this.itemService.delete(context, profileItem);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    private DiscoverResult search(Context context, DiscoverQuery discoverQuery) {
        try {
            return this.searchService.search(context, discoverQuery);
        }
        catch (SearchServiceException e) {
            throw new RuntimeException(e);
        }
    }
}

