/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject_;
import org.dspace.content.Item;
import org.dspace.content.Item_;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.dao.ItemDAO;
import org.dspace.contentreport.QueryOperator;
import org.dspace.contentreport.QueryPredicate;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.core.UUIDIterator;
import org.dspace.eperson.EPerson;
import org.dspace.util.JpaCriteriaBuilderKit;

public class ItemDAOImpl
extends AbstractHibernateDSODAO<Item>
implements ItemDAO {
    private static final Logger log = LogManager.getLogger(ItemDAOImpl.class);

    protected ItemDAOImpl() {
    }

    @Override
    public Iterator<Item> findAll(Context context, boolean archived) throws SQLException {
        Query query = this.createQuery(context, "SELECT i.id FROM Item i WHERE inArchive=:in_archive ORDER BY id");
        query.setParameter("in_archive", (Object)archived);
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public Iterator<Item> findAll(Context context, boolean archived, int limit, int offset) throws SQLException {
        Query query = this.createQuery(context, "SELECT i.id FROM Item i WHERE inArchive=:in_archive ORDER BY id");
        query.setParameter("in_archive", (Object)archived);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public Iterator<Item> findAll(Context context, boolean archived, boolean withdrawn) throws SQLException {
        Query query = this.createQuery(context, "SELECT i.id FROM Item i WHERE inArchive=:in_archive or withdrawn=:withdrawn ORDER BY id");
        query.setParameter("in_archive", (Object)archived);
        query.setParameter("withdrawn", (Object)withdrawn);
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public Iterator<Item> findAllRegularItems(Context context) throws SQLException {
        Query query = this.createQuery(context, "SELECT i.id FROM Item as i LEFT JOIN Version as v ON i = v.item WHERE i.inArchive=true or i.withdrawn=true or (i.inArchive=false and v.id IS NOT NULL) ORDER BY i.id");
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public Iterator<Item> findAll(Context context, boolean archived, boolean withdrawn, boolean discoverable, Date lastModified) throws SQLException {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("SELECT i.id FROM Item i");
        queryStr.append(" WHERE (inArchive = :in_archive OR withdrawn = :withdrawn)");
        queryStr.append(" AND discoverable = :discoverable");
        if (lastModified != null) {
            queryStr.append(" AND lastModified > :last_modified");
        }
        queryStr.append(" ORDER BY i.id");
        Query query = this.createQuery(context, queryStr.toString());
        query.setParameter("in_archive", (Object)archived);
        query.setParameter("withdrawn", (Object)withdrawn);
        query.setParameter("discoverable", (Object)discoverable);
        if (lastModified != null) {
            query.setParameter("last_modified", lastModified, TemporalType.TIMESTAMP);
        }
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public Iterator<Item> findBySubmitter(Context context, EPerson eperson) throws SQLException {
        Query query = this.createQuery(context, "SELECT i.id FROM Item i WHERE inArchive=:in_archive and submitter=:submitter ORDER BY id");
        query.setParameter("in_archive", (Object)true);
        query.setParameter("submitter", (Object)eperson);
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public Iterator<Item> findBySubmitter(Context context, EPerson eperson, boolean retrieveAllItems) throws SQLException {
        if (!retrieveAllItems) {
            return this.findBySubmitter(context, eperson);
        }
        Query query = this.createQuery(context, "SELECT i.id FROM Item i WHERE submitter=:submitter ORDER BY id");
        query.setParameter("submitter", (Object)eperson);
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public Iterator<Item> findBySubmitter(Context context, EPerson eperson, MetadataField metadataField, int limit) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT item.id FROM Item as item ");
        this.addMetadataLeftJoin(query, Item.class.getSimpleName().toLowerCase(), Collections.singletonList(metadataField));
        query.append(" WHERE item.inArchive = :in_archive");
        query.append(" AND item.submitter =:submitter");
        this.addMetadataSortQuery(query, Collections.singletonList(metadataField), null, Collections.singletonList("desc"));
        Query hibernateQuery = this.createQuery(context, query.toString());
        hibernateQuery.setParameter(metadataField.toString(), (Object)metadataField.getID());
        hibernateQuery.setParameter("in_archive", (Object)true);
        hibernateQuery.setParameter("submitter", (Object)eperson);
        hibernateQuery.setMaxResults(limit);
        List uuids = hibernateQuery.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public Iterator<Item> findByMetadataField(Context context, MetadataField metadataField, String value, boolean inArchive) throws SQLException {
        Object hqlQueryString = "SELECT item.id FROM Item as item join item.metadata metadatavalue WHERE item.inArchive=:in_archive AND metadatavalue.metadataField = :metadata_field";
        if (value != null) {
            hqlQueryString = (String)hqlQueryString + " AND STR(metadatavalue.value) = :text_value";
        }
        Query query = this.createQuery(context, (String)hqlQueryString + " ORDER BY item.id");
        query.setParameter("in_archive", (Object)inArchive);
        query.setParameter("metadata_field", (Object)metadataField);
        if (value != null) {
            query.setParameter("text_value", (Object)value);
        }
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public List<Item> findByMetadataQuery(Context context, List<QueryPredicate> queryPredicates, List<UUID> collectionUuids, String regexClause, long offset, int limit) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Item> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Item.class);
        Root itemRoot = criteriaQuery.from(Item.class);
        criteriaQuery.select((Selection)itemRoot);
        List<Predicate> predicates = this.toPredicates(criteriaBuilder, criteriaQuery, (Root<Item>)itemRoot, queryPredicates, collectionUuids, regexClause);
        criteriaQuery.where((Expression)criteriaBuilder.and((Predicate[])predicates.stream().toArray(Predicate[]::new)));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)itemRoot.get(DSpaceObject_.id))});
        try {
            return this.list(context, criteriaQuery, false, Item.class, limit, (int)offset);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public long countForMetadataQuery(Context context, List<QueryPredicate> queryPredicates, List<UUID> collectionUuids, String regexClause) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root itemRoot = criteriaQuery.from(Item.class);
        List<Predicate> predicates = this.toPredicates(criteriaBuilder, criteriaQuery, (Root<Item>)itemRoot, queryPredicates, collectionUuids, regexClause);
        criteriaQuery.where((Expression)criteriaBuilder.and((Predicate[])predicates.stream().toArray(Predicate[]::new)));
        return this.countLong(context, criteriaQuery, criteriaBuilder, itemRoot);
    }

    private <T> List<Predicate> toPredicates(CriteriaBuilder criteriaBuilder, CriteriaQuery<T> query, Root<Item> root, List<QueryPredicate> queryPredicates, List<UUID> collectionUuids, String regexClause) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!collectionUuids.isEmpty()) {
            Subquery scollQuery = query.subquery(Collection.class);
            Root collRoot = scollQuery.from(Collection.class);
            CriteriaBuilder.In inColls = criteriaBuilder.in((Expression)collRoot.get("id"));
            collectionUuids.forEach(arg_0 -> ((CriteriaBuilder.In)inColls).value(arg_0));
            scollQuery.select((Expression)collRoot.get("id")).where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)collRoot.get("id"), (Expression)root.get("owningCollection").get("id")), (Expression)collRoot.get("id").in(collectionUuids)));
            predicates.add(criteriaBuilder.exists(scollQuery));
        }
        for (int i = 0; i < queryPredicates.size(); ++i) {
            QueryPredicate predicate = queryPredicates.get(i);
            QueryOperator op = predicate.getOperator();
            if (op == null) {
                log.warn("Skipping Invalid Operator: null");
                continue;
            }
            if (op.getUsesRegex() && regexClause.isEmpty()) {
                log.warn("Skipping Unsupported Regex Operator: " + op);
                continue;
            }
            ArrayList<Object> mvPredicates = new ArrayList<Object>();
            Subquery mvQuery = query.subquery(MetadataValue.class);
            Root mvRoot = mvQuery.from(MetadataValue.class);
            mvPredicates.add(criteriaBuilder.equal((Expression)mvRoot.get("dSpaceObject"), root));
            if (!predicate.getFields().isEmpty()) {
                CriteriaBuilder.In inFields = criteriaBuilder.in((Expression)mvRoot.get("metadataField"));
                predicate.getFields().forEach(arg_0 -> ((CriteriaBuilder.In)inFields).value(arg_0));
                mvPredicates.add(inFields);
            }
            JpaCriteriaBuilderKit<MetadataValue> jpaKit = new JpaCriteriaBuilderKit<MetadataValue>(criteriaBuilder, (AbstractQuery<MetadataValue>)mvQuery, (Root<MetadataValue>)mvRoot);
            mvPredicates.add(op.buildJpaPredicate(predicate.getValue(), regexClause, jpaKit));
            mvQuery.select((Expression)mvRoot.get("dSpaceObject")).where((Predicate[])mvPredicates.stream().toArray(Predicate[]::new));
            if (op.getNegate()) {
                predicates.add(criteriaBuilder.not((Expression)criteriaBuilder.exists(mvQuery)));
                continue;
            }
            predicates.add(criteriaBuilder.exists(mvQuery));
        }
        log.debug(String.format("Running custom query with %d filters", queryPredicates.size()));
        return predicates;
    }

    @Override
    public Iterator<Item> findByAuthorityValue(Context context, MetadataField metadataField, String authority, boolean inArchive) throws SQLException {
        Query query = this.createQuery(context, "SELECT item.id FROM Item as item join item.metadata metadatavalue WHERE item.inArchive=:in_archive AND metadatavalue.metadataField = :metadata_field AND metadatavalue.authority = :authority ORDER BY item.id");
        query.setParameter("in_archive", (Object)inArchive);
        query.setParameter("metadata_field", (Object)metadataField);
        query.setParameter("authority", (Object)authority);
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public Iterator<Item> findArchivedByCollection(Context context, Collection collection, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(UUID.class);
        Root itemRoot = criteriaQuery.from(Item.class);
        criteriaQuery.select((Selection)itemRoot.get(Item_.id));
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.isTrue((Expression)itemRoot.get(Item_.inArchive)), (Expression)criteriaBuilder.isMember((Object)collection, itemRoot.get(Item_.collections))));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)itemRoot.get(Item_.id))});
        Query query = this.createQuery(context, criteriaQuery);
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public Iterator<Item> findArchivedByCollectionExcludingOwning(Context context, Collection collection, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Item> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Item.class);
        Root itemRoot = criteriaQuery.from(Item.class);
        criteriaQuery.select((Selection)itemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.notEqual((Expression)itemRoot.get(Item_.owningCollection), (Object)collection), criteriaBuilder.isMember((Object)collection, itemRoot.get(Item_.collections)), criteriaBuilder.isTrue((Expression)itemRoot.get(Item_.inArchive))}));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)itemRoot.get(DSpaceObject_.id))});
        return this.list(context, criteriaQuery, false, Item.class, limit, offset).iterator();
    }

    @Override
    public int countArchivedByCollectionExcludingOwning(Context context, Collection collection) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root itemRoot = criteriaQuery.from(Item.class);
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)itemRoot));
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.notEqual((Expression)itemRoot.get(Item_.owningCollection), (Object)collection), criteriaBuilder.isMember((Object)collection, itemRoot.get(Item_.collections)), criteriaBuilder.isTrue((Expression)itemRoot.get(Item_.inArchive))}));
        return this.count(context, criteriaQuery, criteriaBuilder, itemRoot);
    }

    @Override
    public Iterator<Item> findAllByCollection(Context context, Collection collection) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(UUID.class);
        Root itemRoot = criteriaQuery.from(Item.class);
        criteriaQuery.select((Selection)itemRoot.get(Item_.id));
        criteriaQuery.where((Expression)criteriaBuilder.isMember((Object)collection, itemRoot.get(Item_.collections)));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)itemRoot.get(Item_.id))});
        Query query = this.createQuery(context, criteriaQuery);
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public Iterator<Item> findAllByCollection(Context context, Collection collection, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(UUID.class);
        Root itemRoot = criteriaQuery.from(Item.class);
        criteriaQuery.select((Selection)itemRoot.get(Item_.id));
        criteriaQuery.where((Expression)criteriaBuilder.isMember((Object)collection, itemRoot.get(Item_.collections)));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)itemRoot.get(Item_.id))});
        Query query = this.createQuery(context, criteriaQuery);
        if (offset != null) {
            query.setFirstResult(offset.intValue());
        }
        if (limit != null) {
            query.setMaxResults(limit.intValue());
        }
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public int countItems(Context context, Collection collection, boolean includeArchived, boolean includeWithdrawn, boolean discoverable) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root itemRoot = criteriaQuery.from(Item.class);
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)itemRoot));
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)itemRoot.get(Item_.inArchive), (Object)includeArchived), criteriaBuilder.equal((Expression)itemRoot.get(Item_.withdrawn), (Object)includeWithdrawn), criteriaBuilder.equal((Expression)itemRoot.get(Item_.discoverable), (Object)discoverable), criteriaBuilder.isMember((Object)collection, itemRoot.get(Item_.collections))}));
        return this.count(context, criteriaQuery, criteriaBuilder, itemRoot);
    }

    @Override
    public int countItems(Context context, List<Collection> collections, boolean includeArchived, boolean includeWithdrawn, boolean discoverable) throws SQLException {
        if (collections.size() == 0) {
            return 0;
        }
        Query query = this.createQuery(context, "select count(distinct i) from Item i join i.collections collection WHERE collection IN (:collections) AND i.inArchive=:in_archive AND i.withdrawn=:withdrawn AND discoverable=:discoverable");
        query.setParameter("collections", collections);
        query.setParameter("in_archive", (Object)includeArchived);
        query.setParameter("withdrawn", (Object)includeWithdrawn);
        query.setParameter("discoverable", (Object)discoverable);
        return this.count(query);
    }

    @Override
    public Iterator<Item> findByLastModifiedSince(Context context, Date since) throws SQLException {
        Query query = this.createQuery(context, "SELECT i.id FROM Item i WHERE last_modified > :last_modified ORDER BY id");
        query.setParameter("last_modified", since, TemporalType.TIMESTAMP);
        List uuids = query.getResultList();
        return new UUIDIterator<Item>(context, uuids, Item.class, this);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Item"));
    }

    @Override
    public int countItems(Context context, boolean includeArchived, boolean includeWithdrawn, boolean discoverable) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM Item i WHERE i.inArchive=:in_archive AND i.withdrawn=:withdrawn AND discoverable=:discoverable");
        query.setParameter("in_archive", (Object)includeArchived);
        query.setParameter("withdrawn", (Object)includeWithdrawn);
        query.setParameter("discoverable", (Object)discoverable);
        return this.count(query);
    }

    @Override
    public int countItems(Context context, EPerson submitter, boolean includeArchived, boolean includeWithdrawn, boolean discoverable) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM Item i join i.submitter submitter WHERE i.inArchive=:in_archive AND i.withdrawn=:withdrawn AND submitter = :submitter AND discoverable=:discoverable");
        query.setParameter("submitter", (Object)submitter);
        query.setParameter("in_archive", (Object)includeArchived);
        query.setParameter("withdrawn", (Object)includeWithdrawn);
        query.setParameter("discoverable", (Object)discoverable);
        return this.count(query);
    }
}

