/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.ezid;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.ezid.EZIDResponse;

public class EZIDRequest {
    private static final Logger log = LogManager.getLogger();
    private static final String ID_PATH = "/id/doi:";
    private static final String SHOULDER_PATH = "/shoulder/doi:";
    private static final String UTF_8 = "UTF-8";
    private static final String MD_KEY_STATUS = "_status";
    private final CloseableHttpClient client;
    private final HttpClientContext httpContext;
    private final String scheme;
    private final String host;
    private final String path;
    private final String authority;

    @Deprecated
    EZIDRequest(String scheme, String host, String authority, String username, String password) throws URISyntaxException {
        this.scheme = scheme;
        this.host = host;
        this.path = "ezid";
        this.authority = authority.charAt(authority.length() - 1) == '/' ? authority.substring(0, authority.length() - 1) : authority;
        this.client = HttpClientBuilder.create().build();
        this.httpContext = HttpClientContext.create();
        if (null != username) {
            URI uri = new URI(scheme, host, this.path, null);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        }
    }

    EZIDRequest(String scheme, String host, String path, String authority, String username, String password) throws URISyntaxException {
        this.scheme = scheme;
        this.host = host;
        this.path = path;
        this.authority = authority.charAt(authority.length() - 1) == '/' ? authority.substring(0, authority.length() - 1) : authority;
        this.client = HttpClientBuilder.create().build();
        this.httpContext = HttpClientContext.create();
        if (null != username) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            URI uri = new URI(scheme, host, path, null);
            credentialsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
            this.httpContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    public EZIDResponse lookup(String name) throws IdentifierException, IOException, URISyntaxException {
        URI uri = new URI(this.scheme, this.host, this.path + ID_PATH + this.authority + name, null);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = uri::toASCIIString;
        log.debug("EZID lookup {}", supplierArray);
        HttpGet request = new HttpGet(uri);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, (HttpContext)this.httpContext);
        return new EZIDResponse((HttpResponse)response);
    }

    public EZIDResponse create(String name, Map<String, String> metadata) throws IOException, IdentifierException, URISyntaxException {
        URI uri = new URI(this.scheme, this.host, this.path + ID_PATH + this.authority + "/" + name, null);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = uri::toASCIIString;
        log.debug("EZID create {}", supplierArray);
        HttpPut request = new HttpPut(uri);
        if (null != metadata) {
            request.setEntity((HttpEntity)new StringEntity(EZIDRequest.formatMetadata(metadata), UTF_8));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, (HttpContext)this.httpContext);
        return new EZIDResponse((HttpResponse)response);
    }

    public EZIDResponse mint(Map<String, String> metadata) throws IOException, IdentifierException, URISyntaxException {
        URI uri = new URI(this.scheme, this.host, this.path + SHOULDER_PATH + this.authority, null);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = uri::toASCIIString;
        log.debug("EZID mint {}", supplierArray);
        HttpPost request = new HttpPost(uri);
        if (null != metadata) {
            request.setEntity((HttpEntity)new StringEntity(EZIDRequest.formatMetadata(metadata), UTF_8));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, (HttpContext)this.httpContext);
        EZIDResponse myResponse = new EZIDResponse((HttpResponse)response);
        return myResponse;
    }

    public EZIDResponse modify(String name, Map<String, String> metadata) throws IOException, IdentifierException, URISyntaxException {
        if (null == metadata) {
            throw new IllegalArgumentException("metadata must not be null");
        }
        URI uri = new URI(this.scheme, this.host, this.path + ID_PATH + this.authority + name, null);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = uri::toASCIIString;
        log.debug("EZID modify {}", supplierArray);
        HttpPost request = new HttpPost(uri);
        request.setEntity((HttpEntity)new StringEntity(EZIDRequest.formatMetadata(metadata), UTF_8));
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, (HttpContext)this.httpContext);
        return new EZIDResponse((HttpResponse)response);
    }

    public EZIDResponse delete(String name) throws IOException, IdentifierException, URISyntaxException {
        URI uri = new URI(this.scheme, this.host, this.path + ID_PATH + this.authority + name, null);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = uri::toASCIIString;
        log.debug("EZID delete {}", supplierArray);
        HttpDelete request = new HttpDelete(uri);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, (HttpContext)this.httpContext);
        return new EZIDResponse((HttpResponse)response);
    }

    public EZIDResponse withdraw(String name) throws IOException, IdentifierException, URISyntaxException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(MD_KEY_STATUS, "unavailable");
        return this.modify(name, metadata);
    }

    public EZIDResponse withdraw(String name, String reason) throws IOException, IdentifierException, URISyntaxException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(MD_KEY_STATUS, "unavailable | " + EZIDRequest.escape(reason));
        return this.modify(name, metadata);
    }

    private static String formatMetadata(Map<String, String> raw) {
        StringBuilder formatted = new StringBuilder();
        for (Map.Entry<String, String> entry : raw.entrySet()) {
            formatted.append(EZIDRequest.escape(entry.getKey())).append(": ").append(EZIDRequest.escape(entry.getValue())).append('\n');
        }
        return formatted.toString();
    }

    private static String escape(String s) {
        if (null == s) {
            return s;
        }
        return s.replace("%", "%25").replace("\n", "%0A").replace("\r", "%0D").replace(":", "%3A");
    }
}

