/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.dspace.orcid.client.OrcidClient;
import org.dspace.orcid.client.OrcidConfiguration;
import org.dspace.orcid.client.OrcidResponse;
import org.dspace.orcid.exception.OrcidClientException;
import org.dspace.orcid.model.OrcidEntityType;
import org.dspace.orcid.model.OrcidProfileSectionType;
import org.dspace.orcid.model.OrcidTokenResponseDTO;
import org.dspace.util.ThrowingSupplier;
import org.orcid.jaxb.model.v3.release.record.Address;
import org.orcid.jaxb.model.v3.release.record.Funding;
import org.orcid.jaxb.model.v3.release.record.Keyword;
import org.orcid.jaxb.model.v3.release.record.OtherName;
import org.orcid.jaxb.model.v3.release.record.Person;
import org.orcid.jaxb.model.v3.release.record.PersonExternalIdentifier;
import org.orcid.jaxb.model.v3.release.record.ResearcherUrl;
import org.orcid.jaxb.model.v3.release.record.Work;
import org.orcid.jaxb.model.v3.release.record.WorkBulk;
import org.orcid.jaxb.model.v3.release.record.summary.Works;

public class OrcidClientImpl
implements OrcidClient {
    private static final Map<Class<?>, String> PATHS_MAP = OrcidClientImpl.initializePathsMap();
    private final OrcidConfiguration orcidConfiguration;
    private final ObjectMapper objectMapper;

    public OrcidClientImpl(OrcidConfiguration orcidConfiguration) {
        this.orcidConfiguration = orcidConfiguration;
        this.objectMapper = new ObjectMapper();
    }

    private static Map<Class<?>, String> initializePathsMap() {
        HashMap map = new HashMap();
        map.put(Work.class, OrcidEntityType.PUBLICATION.getPath());
        map.put(Funding.class, OrcidEntityType.FUNDING.getPath());
        map.put(Address.class, OrcidProfileSectionType.COUNTRY.getPath());
        map.put(OtherName.class, OrcidProfileSectionType.OTHER_NAMES.getPath());
        map.put(ResearcherUrl.class, OrcidProfileSectionType.RESEARCHER_URLS.getPath());
        map.put(PersonExternalIdentifier.class, OrcidProfileSectionType.EXTERNAL_IDS.getPath());
        map.put(Keyword.class, OrcidProfileSectionType.KEYWORDS.getPath());
        return map;
    }

    @Override
    public OrcidTokenResponseDTO getAccessToken(String code) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("code", code));
        params.add(new BasicNameValuePair("grant_type", "authorization_code"));
        params.add(new BasicNameValuePair("client_id", this.orcidConfiguration.getClientId()));
        params.add(new BasicNameValuePair("client_secret", this.orcidConfiguration.getClientSecret()));
        HttpUriRequest httpUriRequest = RequestBuilder.post((String)this.orcidConfiguration.getTokenEndpointUrl()).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Accept", "application/json").setEntity((HttpEntity)new UrlEncodedFormEntity(params, Charset.defaultCharset())).build();
        return this.executeAndParseJson(httpUriRequest, OrcidTokenResponseDTO.class);
    }

    @Override
    public Person getPerson(String accessToken, String orcid) {
        HttpUriRequest httpUriRequest = this.buildGetUriRequest(accessToken, "/" + orcid + "/person");
        return this.executeAndUnmarshall(httpUriRequest, false, Person.class);
    }

    @Override
    public Works getWorks(String accessToken, String orcid) {
        HttpUriRequest httpUriRequest = this.buildGetUriRequest(accessToken, "/" + orcid + "/works");
        Works works = this.executeAndUnmarshall(httpUriRequest, true, Works.class);
        return works != null ? works : new Works();
    }

    @Override
    public Works getWorks(String orcid) {
        HttpUriRequest httpUriRequest = this.buildGetUriRequestToPublicEndpoint("/" + orcid + "/works");
        Works works = this.executeAndUnmarshall(httpUriRequest, true, Works.class);
        return works != null ? works : new Works();
    }

    @Override
    public WorkBulk getWorkBulk(String accessToken, String orcid, List<String> putCodes) {
        String putCode = String.join((CharSequence)",", putCodes);
        HttpUriRequest httpUriRequest = this.buildGetUriRequest(accessToken, "/" + orcid + "/works/" + putCode);
        WorkBulk workBulk = this.executeAndUnmarshall(httpUriRequest, true, WorkBulk.class);
        return workBulk != null ? workBulk : new WorkBulk();
    }

    @Override
    public WorkBulk getWorkBulk(String orcid, List<String> putCodes) {
        String putCode = String.join((CharSequence)",", putCodes);
        HttpUriRequest httpUriRequest = this.buildGetUriRequestToPublicEndpoint("/" + orcid + "/works/" + putCode);
        WorkBulk workBulk = this.executeAndUnmarshall(httpUriRequest, true, WorkBulk.class);
        return workBulk != null ? workBulk : new WorkBulk();
    }

    @Override
    public <T> Optional<T> getObject(String accessToken, String orcid, String putCode, Class<T> clazz) {
        String path = this.getOrcidPathFromOrcidObjectType(clazz);
        HttpUriRequest httpUriRequest = this.buildGetUriRequest(accessToken, "/" + orcid + path + "/" + putCode);
        return Optional.ofNullable(this.executeAndUnmarshall(httpUriRequest, true, clazz));
    }

    @Override
    public <T> Optional<T> getObject(String orcid, String putCode, Class<T> clazz) {
        String path = this.getOrcidPathFromOrcidObjectType(clazz);
        HttpUriRequest httpUriRequest = this.buildGetUriRequestToPublicEndpoint("/" + orcid + path + "/" + putCode);
        return Optional.ofNullable(this.executeAndUnmarshall(httpUriRequest, true, clazz));
    }

    @Override
    public OrcidResponse push(String accessToken, String orcid, Object object) {
        String path = this.getOrcidPathFromOrcidObjectType(object.getClass());
        return this.execute(this.buildPostUriRequest(accessToken, "/" + orcid + path, object), false);
    }

    @Override
    public OrcidResponse update(String accessToken, String orcid, Object object, String putCode) {
        String path = this.getOrcidPathFromOrcidObjectType(object.getClass());
        return this.execute(this.buildPutUriRequest(accessToken, "/" + orcid + path + "/" + putCode, object), false);
    }

    @Override
    public OrcidResponse deleteByPutCode(String accessToken, String orcid, String putCode, String path) {
        return this.execute(this.buildDeleteUriRequest(accessToken, "/" + orcid + path + "/" + putCode), true);
    }

    @Override
    public OrcidTokenResponseDTO getReadPublicAccessToken() {
        return this.getClientCredentialsAccessToken("/read-public");
    }

    private OrcidTokenResponseDTO getClientCredentialsAccessToken(String scope) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("scope", scope));
        params.add(new BasicNameValuePair("grant_type", "client_credentials"));
        params.add(new BasicNameValuePair("client_id", this.orcidConfiguration.getClientId()));
        params.add(new BasicNameValuePair("client_secret", this.orcidConfiguration.getClientSecret()));
        HttpUriRequest httpUriRequest = RequestBuilder.post((String)this.orcidConfiguration.getTokenEndpointUrl()).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Accept", "application/json").setEntity((HttpEntity)new UrlEncodedFormEntity(params, Charset.defaultCharset())).build();
        return this.executeAndParseJson(httpUriRequest, OrcidTokenResponseDTO.class);
    }

    private HttpUriRequest buildGetUriRequest(String accessToken, String relativePath) {
        return RequestBuilder.get((String)(this.orcidConfiguration.getApiUrl() + relativePath.trim())).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", "Bearer " + accessToken).build();
    }

    private HttpUriRequest buildGetUriRequestToPublicEndpoint(String relativePath) {
        return RequestBuilder.get((String)(this.orcidConfiguration.getPublicUrl() + relativePath.trim())).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
    }

    private HttpUriRequest buildPostUriRequest(String accessToken, String relativePath, Object object) {
        return RequestBuilder.post((String)(this.orcidConfiguration.getApiUrl() + relativePath.trim())).addHeader("Content-Type", "application/vnd.orcid+xml").addHeader("Authorization", "Bearer " + accessToken).setEntity(this.convertToEntity(object)).build();
    }

    private HttpUriRequest buildPutUriRequest(String accessToken, String relativePath, Object object) {
        return RequestBuilder.put((String)(this.orcidConfiguration.getApiUrl() + relativePath.trim())).addHeader("Content-Type", "application/vnd.orcid+xml").addHeader("Authorization", "Bearer " + accessToken).setEntity(this.convertToEntity(object)).build();
    }

    private HttpUriRequest buildDeleteUriRequest(String accessToken, String relativePath) {
        return RequestBuilder.delete((String)(this.orcidConfiguration.getApiUrl() + relativePath.trim())).addHeader("Authorization", "Bearer " + accessToken).build();
    }

    private <T> T executeAndParseJson(HttpUriRequest httpUriRequest, Class<T> clazz) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        return (T)this.executeAndReturns(() -> this.lambda$executeAndParseJson$0((HttpClient)client, httpUriRequest, clazz));
    }

    private <T> T executeAndUnmarshall(HttpUriRequest httpUriRequest, boolean handleNotFoundAsNull, Class<T> clazz) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        return (T)this.executeAndReturns(() -> this.lambda$executeAndUnmarshall$1((HttpClient)client, httpUriRequest, handleNotFoundAsNull, clazz));
    }

    private OrcidResponse execute(HttpUriRequest httpUriRequest, boolean handleNotFoundAsNull) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        return this.executeAndReturns(() -> this.lambda$execute$2((HttpClient)client, httpUriRequest, handleNotFoundAsNull));
    }

    private <T> T executeAndReturns(ThrowingSupplier<T, Exception> supplier) {
        try {
            return supplier.get();
        }
        catch (OrcidClientException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OrcidClientException(ex);
        }
    }

    private String marshall(Object object) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal(object, (Writer)stringWriter);
        return stringWriter.toString();
    }

    private <T> T unmarshall(HttpEntity entity, Class<T> clazz) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(entity.getContent());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (T)unmarshaller.unmarshal(xmlStreamReader);
    }

    private HttpEntity convertToEntity(Object object) {
        try {
            return new StringEntity(this.marshall(object), StandardCharsets.UTF_8);
        }
        catch (JAXBException ex) {
            throw new IllegalArgumentException("The given object cannot be sent to ORCID", ex);
        }
    }

    private String formatErrorMessage(HttpResponse response) {
        try {
            return IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
        }
        catch (IOException | UnsupportedOperationException e) {
            return "Generic error";
        }
    }

    private boolean isNotSuccessfull(HttpResponse response) {
        int statusCode = this.getStatusCode(response);
        return statusCode < 200 || statusCode > 299;
    }

    private boolean isNotFound(HttpResponse response) {
        return this.getStatusCode(response) == 404;
    }

    private int getStatusCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private String getOrcidPathFromOrcidObjectType(Class<?> clazz) {
        String path = PATHS_MAP.get(clazz);
        if (path == null) {
            throw new IllegalArgumentException("The given class is not an ORCID object's class: " + clazz);
        }
        return path;
    }

    private String getContent(HttpResponse response) throws UnsupportedOperationException, IOException {
        HttpEntity entity = response.getEntity();
        return entity != null ? IOUtils.toString((InputStream)entity.getContent(), (String)StandardCharsets.UTF_8.name()) : null;
    }

    private String getPutCode(HttpResponse response) {
        Header[] headers = response.getHeaders("Location");
        if (headers.length == 0) {
            return null;
        }
        String value = headers[0].getValue();
        return value.substring(value.lastIndexOf("/") + 1);
    }

    private /* synthetic */ OrcidResponse lambda$execute$2(HttpClient client, HttpUriRequest httpUriRequest, boolean handleNotFoundAsNull) throws Exception {
        HttpResponse response = client.execute(httpUriRequest);
        if (handleNotFoundAsNull && this.isNotFound(response)) {
            return new OrcidResponse(this.getStatusCode(response), null, this.getContent(response));
        }
        if (this.isNotSuccessfull(response)) {
            throw new OrcidClientException(this.getStatusCode(response), this.formatErrorMessage(response));
        }
        return new OrcidResponse(this.getStatusCode(response), this.getPutCode(response), this.getContent(response));
    }

    private /* synthetic */ Object lambda$executeAndUnmarshall$1(HttpClient client, HttpUriRequest httpUriRequest, boolean handleNotFoundAsNull, Class clazz) throws Exception {
        HttpResponse response = client.execute(httpUriRequest);
        if (handleNotFoundAsNull && this.isNotFound(response)) {
            return null;
        }
        if (this.isNotSuccessfull(response)) {
            throw new OrcidClientException(this.getStatusCode(response), this.formatErrorMessage(response));
        }
        return this.unmarshall(response.getEntity(), clazz);
    }

    private /* synthetic */ Object lambda$executeAndParseJson$0(HttpClient client, HttpUriRequest httpUriRequest, Class clazz) throws Exception {
        HttpResponse response = client.execute(httpUriRequest);
        if (this.isNotSuccessfull(response)) {
            throw new OrcidClientException(this.getStatusCode(response), this.formatErrorMessage(response));
        }
        return this.objectMapper.readValue(response.getEntity().getContent(), clazz);
    }
}

