/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.dao.impl;

import jakarta.persistence.Query;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.dspace.content.Item;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.dao.OrcidQueueDAO;

public class OrcidQueueDAOImpl
extends AbstractHibernateDAO<OrcidQueue>
implements OrcidQueueDAO {
    @Override
    public List<OrcidQueue> findByProfileItemId(Context context, UUID profileItemId, Integer limit, Integer offset) throws SQLException {
        Query query = this.createQuery(context, "FROM OrcidQueue WHERE profileItem.id= :profileItemId");
        query.setParameter("profileItemId", (Object)profileItemId);
        if (limit != null && limit > 0) {
            query.setMaxResults(limit.intValue());
        }
        query.setFirstResult(offset.intValue());
        return query.getResultList();
    }

    @Override
    public List<OrcidQueue> findByProfileItemAndEntity(Context context, Item profileItem, Item entity) throws SQLException {
        Query query = this.createQuery(context, "FROM OrcidQueue WHERE profileItem = :profileItem AND entity = :entity");
        query.setParameter("profileItem", (Object)profileItem);
        query.setParameter("entity", (Object)entity);
        return query.getResultList();
    }

    @Override
    public long countByProfileItemId(Context context, UUID profileItemId) throws SQLException {
        Query query = this.createQuery(context, "SELECT COUNT(queue) FROM OrcidQueue queue WHERE profileItem.id= :profileItemId");
        query.setParameter("profileItemId", (Object)profileItemId);
        return (Long)query.getSingleResult();
    }

    @Override
    public List<OrcidQueue> findByProfileItemOrEntity(Context context, Item item) throws SQLException {
        Query query = this.createQuery(context, "FROM OrcidQueue WHERE profileItem.id= :itemId OR entity.id = :itemId");
        query.setParameter("itemId", (Object)item.getID());
        return query.getResultList();
    }

    @Override
    public List<OrcidQueue> findByEntityAndRecordType(Context context, Item entity, String type) throws SQLException {
        Query query = this.createQuery(context, "FROM OrcidQueue WHERE entity = :entity AND recordType = :type");
        query.setParameter("entity", (Object)entity);
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    @Override
    public List<OrcidQueue> findByProfileItemAndRecordType(Context context, Item profileItem, String type) throws SQLException {
        Query query = this.createQuery(context, "FROM OrcidQueue WHERE profileItem = :profileItem AND recordType = :type");
        query.setParameter("profileItem", (Object)profileItem);
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    @Override
    public List<OrcidQueue> findByAttemptsLessThan(Context context, int attempts) throws SQLException {
        Query query = this.createQuery(context, "FROM OrcidQueue WHERE attempts IS NULL OR attempts < :attempts");
        query.setParameter("attempts", (Object)attempts);
        return query.getResultList();
    }
}

