/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataFieldName;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionAdvancedInfo;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.state.actions.processingaction.ScoreReviewActionAdvancedInfo;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class ScoreReviewAction
extends ProcessingAction {
    private static final Logger log = LogManager.getLogger(ScoreReviewAction.class);
    public static final String SUBMIT_SCORE = "submit_score";
    private static final String SCORE = "score";
    private static final String REVIEW = "review";
    public static final MetadataFieldName SCORE_FIELD = new MetadataFieldName("workflow", "score", null);
    public static final MetadataFieldName REVIEW_FIELD = new MetadataFieldName("workflow", "review", null);
    private boolean descriptionRequired;
    private int maxValue;

    @Override
    public void activate(Context c, XmlWorkflowItem wf) {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException {
        if (super.isOptionInParam(request) && StringUtils.equalsIgnoreCase((String)Util.getSubmitButton(request, "submit_cancel"), (String)SUBMIT_SCORE)) {
            return this.processSetRating(c, wfi, request);
        }
        return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
    }

    private ActionResult processSetRating(Context c, XmlWorkflowItem wfi, HttpServletRequest request) throws SQLException, AuthorizeException {
        String review;
        int score = Util.getIntParameter(request, SCORE);
        if (!this.checkRequestValid(score, review = request.getParameter(REVIEW))) {
            return new ActionResult(ActionResult.TYPE.TYPE_ERROR);
        }
        this.itemService.addMetadata(c, wfi.getItem(), ScoreReviewAction.SCORE_FIELD.schema, ScoreReviewAction.SCORE_FIELD.element, ScoreReviewAction.SCORE_FIELD.qualifier, null, String.valueOf(score));
        if (StringUtils.isNotBlank((String)review)) {
            this.itemService.addMetadata(c, wfi.getItem(), ScoreReviewAction.REVIEW_FIELD.schema, ScoreReviewAction.REVIEW_FIELD.element, ScoreReviewAction.REVIEW_FIELD.qualifier, null, String.format("%s - %s", score, review));
        }
        this.itemService.update(c, wfi.getItem());
        return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
    }

    private boolean checkRequestValid(int score, String review) {
        if (score > this.maxValue) {
            log.error("{} only allows max rating {} (config workflow-actions.xml), given rating of {} not allowed.", (Object)this.getClass().toString(), (Object)this.maxValue, (Object)score);
            return false;
        }
        if (StringUtils.isBlank((String)review) && this.descriptionRequired) {
            log.error("{} has config descriptionRequired=true (workflow-actions.xml), so rating requests without 'review' query param containing description are not allowed", (Object)this.getClass().toString());
            return false;
        }
        return true;
    }

    @Override
    public List<String> getOptions() {
        return List.of(SUBMIT_SCORE, "return_to_pool");
    }

    @Override
    protected List<String> getAdvancedOptions() {
        return Arrays.asList(SUBMIT_SCORE);
    }

    @Override
    protected List<ActionAdvancedInfo> getAdvancedInfo() {
        ScoreReviewActionAdvancedInfo scoreReviewActionAdvancedInfo = new ScoreReviewActionAdvancedInfo();
        scoreReviewActionAdvancedInfo.setDescriptionRequired(this.descriptionRequired);
        scoreReviewActionAdvancedInfo.setMaxValue(this.maxValue);
        scoreReviewActionAdvancedInfo.setType(SUBMIT_SCORE);
        scoreReviewActionAdvancedInfo.generateId(SUBMIT_SCORE);
        return Collections.singletonList(scoreReviewActionAdvancedInfo);
    }

    public void setDescriptionRequired(boolean descriptionRequired) {
        this.descriptionRequired = descriptionRequired;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }
}

