/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_head_all_of_dspace = Navigation.message((String)"xmlui.ArtifactBrowser.Navigation.head_all_of_dspace");
    private static final Message T_head_browse = Navigation.message((String)"xmlui.ArtifactBrowser.Navigation.head_browse");
    private static final Message T_communities_and_collections = Navigation.message((String)"xmlui.ArtifactBrowser.Navigation.communities_and_collections");
    private static final Message T_head_this_collection = Navigation.message((String)"xmlui.ArtifactBrowser.Navigation.head_this_collection");
    private static final Message T_head_this_community = Navigation.message((String)"xmlui.ArtifactBrowser.Navigation.head_this_community");

    public Serializable getKey() {
        try {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            String key = request.getScheme() + request.getServerName() + request.getServerPort() + request.getSitemapURI() + request.getQueryString();
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso != null) {
                key = key + "-" + dso.getHandle();
            }
            return Long.valueOf(HashUtil.hash((String)key));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        List browse = options.addList("browse");
        options.addList("account");
        options.addList("context");
        options.addList("administrative");
        browse.setHead(T_head_browse);
        List browseGlobal = browse.addList("global");
        List browseContext = browse.addList("context");
        browseGlobal.setHead(T_head_all_of_dspace);
        browseGlobal.addItemXref(this.contextPath + "/community-list", T_communities_and_collections);
        this.addBrowseOptions(browseGlobal, this.contextPath + "/browse");
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso != null) {
            if (dso instanceof Item) {
                dso = ((Item)dso).getOwningCollection();
            }
            if (dso instanceof Collection) {
                browseContext.setHead(T_head_this_collection);
            }
            if (dso instanceof Community) {
                browseContext.setHead(T_head_this_community);
            }
            String handle = dso.getHandle();
            this.addBrowseOptions(browseContext, this.contextPath + "/handle/" + handle + "/browse");
        }
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String analyticsKey;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        pageMeta.addMetadata("contextPath").addContent(this.contextPath);
        pageMeta.addMetadata("request", "queryString").addContent(request.getQueryString());
        pageMeta.addMetadata("request", "scheme").addContent(request.getScheme());
        pageMeta.addMetadata("request", "serverPort").addContent(request.getServerPort());
        pageMeta.addMetadata("request", "serverName").addContent(request.getServerName());
        pageMeta.addMetadata("request", "URI").addContent(request.getSitemapURI());
        String dspaceVersion = Util.getSourceVersion();
        if (dspaceVersion != null) {
            pageMeta.addMetadata("dspace", "version").addContent(dspaceVersion);
        }
        if ((analyticsKey = ConfigurationManager.getProperty((String)"xmlui.google.analytics.key")) != null && analyticsKey.length() > 0) {
            analyticsKey = analyticsKey.trim();
            pageMeta.addMetadata("google", "analytics").addContent(analyticsKey);
        }
        if (ConfigurationManager.getBooleanProperty((String)"websvc.opensearch.autolink")) {
            pageMeta.addMetadata("opensearch", "shortName").addContent(ConfigurationManager.getProperty((String)"websvc.opensearch.shortname"));
            pageMeta.addMetadata("opensearch", "context").addContent(ConfigurationManager.getProperty((String)"websvc.opensearch.svccontext"));
        }
        pageMeta.addMetadata("search", "simpleURL").addContent(this.contextPath + "/search");
        pageMeta.addMetadata("search", "advancedURL").addContent(this.contextPath + "/advanced-search");
        pageMeta.addMetadata("search", "queryField").addContent("query");
        pageMeta.addMetadata("page", "contactURL").addContent(this.contextPath + "/contact");
        pageMeta.addMetadata("page", "feedbackURL").addContent(this.contextPath + "/feedback");
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso != null) {
            if (dso instanceof Item) {
                pageMeta.addMetadata("focus", "object").addContent("hdl:" + dso.getHandle());
                this.getObjectManager().manageObject((Object)dso);
                dso = ((Item)dso).getOwningCollection();
            }
            if (dso instanceof Collection || dso instanceof Community) {
                pageMeta.addMetadata("focus", "container").addContent("hdl:" + dso.getHandle());
                this.getObjectManager().manageObject((Object)dso);
            }
        }
    }

    private void addBrowseOptions(List browseList, String browseURL) throws WingException {
        try {
            BrowseIndex[] bis;
            for (BrowseIndex bix : bis = BrowseIndex.getBrowseIndices()) {
                HashMap<String, String> queryParams = new HashMap<String, String>();
                queryParams.put("type", bix.getName());
                browseList.addItemXref(AbstractDSpaceTransformer.generateURL((String)browseURL, queryParams), Navigation.message((String)("xmlui.ArtifactBrowser.Navigation.browse_" + bix.getName())));
            }
        }
        catch (BrowseException bex) {
            throw new UIException("Unable to get browse indicies", (Throwable)bex);
        }
    }
}

