/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.item;

import java.sql.SQLException;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class EditItemStatusForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = EditItemStatusForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_submit_return = EditItemStatusForm.message((String)"xmlui.general.return");
    private static final Message T_item_trail = EditItemStatusForm.message((String)"xmlui.administrative.item.general.item_trail");
    private static final Message T_option_head = EditItemStatusForm.message((String)"xmlui.administrative.item.general.option_head");
    private static final Message T_option_status = EditItemStatusForm.message((String)"xmlui.administrative.item.general.option_status");
    private static final Message T_option_bitstreams = EditItemStatusForm.message((String)"xmlui.administrative.item.general.option_bitstreams");
    private static final Message T_option_metadata = EditItemStatusForm.message((String)"xmlui.administrative.item.general.option_metadata");
    private static final Message T_option_view = EditItemStatusForm.message((String)"xmlui.administrative.item.general.option_view");
    private static final Message T_option_curate = EditItemStatusForm.message((String)"xmlui.administrative.item.general.option_curate");
    private static final Message T_title = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.title");
    private static final Message T_trail = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.trail");
    private static final Message T_para1 = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.para1");
    private static final Message T_label_id = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_id");
    private static final Message T_label_handle = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_handle");
    private static final Message T_label_modified = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_modified");
    private static final Message T_label_in = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_in");
    private static final Message T_label_page = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_page");
    private static final Message T_label_auth = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_auth");
    private static final Message T_label_withdraw = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_withdraw");
    private static final Message T_label_reinstate = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_reinstate");
    private static final Message T_label_move = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_move");
    private static final Message T_label_delete = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_delete");
    private static final Message T_submit_authorizations = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.submit_authorizations");
    private static final Message T_submit_withdraw = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.submit_withdraw");
    private static final Message T_submit_reinstate = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.submit_reinstate");
    private static final Message T_submit_move = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.submit_move");
    private static final Message T_submit_delete = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.submit_delete");
    private static final Message T_na = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.na");
    private static final Message T_not_allowed = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.not_allowed");
    private static final Message T_collectionadmins_only = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.collection_admins_only");
    private static final Message T_label_private = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_private");
    private static final Message T_label_public = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.label_public");
    private static final Message T_submit_private = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.submit_private");
    private static final Message T_submit_public = EditItemStatusForm.message((String)"xmlui.administrative.item.EditItemStatusForm.submit_public");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/item", T_item_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SQLException, WingException {
        Collection[] collections;
        int itemID = this.parameters.getParameterAsInteger("itemID", -1);
        Item item = Item.find((Context)this.context, (int)itemID);
        String baseURL = this.contextPath + "/admin/item?administrative-continue=" + this.knot.getId();
        Division main = body.addInteractiveDivision("edit-item-status", this.contextPath + "/admin/item", "post", "primary administrative edit-item-status");
        main.setHead(T_option_head);
        List options = main.addList("options", "simple", "horizontal");
        options.addItem().addHighlight("bold").addXref(baseURL + "&submit_status", T_option_status);
        options.addItem().addXref(baseURL + "&submit_bitstreams", T_option_bitstreams);
        options.addItem().addXref(baseURL + "&submit_metadata", T_option_metadata);
        options.addItem().addXref(baseURL + "&view_item", T_option_view);
        options.addItem().addXref(baseURL + "&submit_curate", T_option_curate);
        main.addPara(T_para1);
        List itemInfo = main.addList("item-info");
        itemInfo.addLabel(T_label_id);
        itemInfo.addItem(String.valueOf(item.getID()));
        itemInfo.addLabel(T_label_handle);
        itemInfo.addItem(item.getHandle() == null ? "None" : item.getHandle());
        itemInfo.addLabel(T_label_modified);
        itemInfo.addItem(item.getLastModified().toString());
        itemInfo.addLabel(T_label_in);
        List subList = itemInfo.addList("collections", "simple");
        for (Collection collection : collections = item.getCollections()) {
            subList.addItem(collection.getMetadata("name"));
        }
        itemInfo.addLabel(T_label_page);
        if (item.getHandle() == null) {
            itemInfo.addItem(T_na);
        } else {
            itemInfo.addItem().addXref(ConfigurationManager.getProperty((String)"dspace.url") + "/handle/" + item.getHandle(), ConfigurationManager.getProperty((String)"dspace.url") + "/handle/" + item.getHandle());
        }
        itemInfo.addLabel(T_label_auth);
        try {
            AuthorizeUtil.authorizeManageItemPolicy((Context)this.context, (Item)item);
            itemInfo.addItem().addButton("submit_authorization").setValue(T_submit_authorizations);
        }
        catch (AuthorizeException authex) {
            this.addNotAllowedButton(itemInfo.addItem(), "submit_authorization", T_submit_authorizations);
        }
        if (!item.isWithdrawn()) {
            itemInfo.addLabel(T_label_withdraw);
            try {
                AuthorizeUtil.authorizeWithdrawItem((Context)this.context, (Item)item);
                itemInfo.addItem().addButton("submit_withdraw").setValue(T_submit_withdraw);
            }
            catch (AuthorizeException authex) {
                this.addNotAllowedButton(itemInfo.addItem(), "submit_withdraw", T_submit_withdraw);
            }
        } else {
            itemInfo.addLabel(T_label_reinstate);
            try {
                AuthorizeUtil.authorizeReinstateItem((Context)this.context, (Item)item);
                itemInfo.addItem().addButton("submit_reinstate").setValue(T_submit_reinstate);
            }
            catch (AuthorizeException authex) {
                this.addNotAllowedButton(itemInfo.addItem(), "submit_reinstate", T_submit_reinstate);
            }
        }
        itemInfo.addLabel(T_label_move);
        this.addCollectionAdminOnlyButton(itemInfo.addItem(), item.getOwningCollection(), "submit_move", T_submit_move);
        this.privateOrPublicAccess(item, itemInfo);
        itemInfo.addLabel(T_label_delete);
        if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)item, (int)2)) {
            itemInfo.addItem().addButton("submit_delete").setValue(T_submit_delete);
        } else {
            this.addNotAllowedButton(itemInfo.addItem(), "submit_delete", T_submit_delete);
        }
        main.addPara().addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private void privateOrPublicAccess(Item item, List itemInfo) throws WingException, SQLException {
        if (item.isDiscoverable()) {
            itemInfo.addLabel(T_label_private);
            try {
                AuthorizeUtil.authorizeWithdrawItem((Context)this.context, (Item)item);
                itemInfo.addItem().addButton("submit_private").setValue(T_submit_private);
            }
            catch (AuthorizeException authex) {
                this.addNotAllowedButton(itemInfo.addItem(), "submit_private", T_submit_private);
            }
        } else {
            itemInfo.addLabel(T_label_public);
            try {
                AuthorizeUtil.authorizeReinstateItem((Context)this.context, (Item)item);
                itemInfo.addItem().addButton("submit_public").setValue(T_submit_public);
            }
            catch (AuthorizeException authex) {
                this.addNotAllowedButton(itemInfo.addItem(), "submit_public", T_submit_public);
            }
        }
    }

    private void addNotAllowedButton(org.dspace.app.xmlui.wing.element.Item item, String buttonName, Message buttonLabel) throws WingException, SQLException {
        Button button = item.addButton(buttonName);
        button.setValue(buttonLabel);
        button.setDisabled();
        item.addHighlight("fade").addContent(T_not_allowed);
    }

    private void addCollectionAdminOnlyButton(org.dspace.app.xmlui.wing.element.Item item, Collection collection, String buttonName, Message buttonLabel) throws WingException, SQLException {
        Button button = item.addButton(buttonName);
        button.setValue(buttonLabel);
        if (!AuthorizeManager.isAdmin((Context)this.context, (DSpaceObject)collection)) {
            button.setDisabled();
            item.addHighlight("fade").addContent(T_collectionadmins_only);
        }
    }
}

