/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.cocoon.SafeResourceReader;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

public class ThemeResourceReader
extends SafeResourceReader
implements CacheableProcessingComponent,
Configurable {
    protected String[] DEFAULT_WHITELIST = new String[]{"css", "js", "json", "gif", "jpg", "jpeg", "png", "ico", "bmp", "htm", "html", "svg", "ttf", "woff"};

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        if (par.getParameterAsBoolean("bypass-whitelist", false)) {
            super.setup(resolver, objectModel, src, par);
            return;
        }
        String whitelistProp = ConfigurationManager.getProperty((String)"xmlui.theme.whitelist");
        String[] whitelist = StringUtils.isEmpty((String)whitelistProp) ? this.DEFAULT_WHITELIST : whitelistProp.split(",");
        for (String suffix : whitelist) {
            if (src == null || !src.toLowerCase().endsWith("." + suffix.trim())) continue;
            super.setup(resolver, objectModel, src, par);
            return;
        }
        throw new ResourceNotFoundException("Resource not found (" + src + ")");
    }
}

