/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemAuthorExtractor;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.content.Bitstream;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.utils.DSpace;

public class SendItemRequestAction
extends AbstractAction {
    private static Logger log = Logger.getLogger(SendItemRequestAction.class);

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String requesterName = request.getParameter("requesterName");
        String requesterEmail = request.getParameter("requesterEmail");
        String allFiles = request.getParameter("allFiles");
        String message = request.getParameter("message");
        String bitstreamId = request.getParameter("bitstreamId");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        EPerson loggedin = context.getCurrentUser();
        String eperson = null;
        if (loggedin != null) {
            eperson = loggedin.getEmail();
        }
        if (StringUtils.isEmpty((String)requesterName) || StringUtils.isEmpty((String)requesterEmail) || StringUtils.isEmpty((String)allFiles) || StringUtils.isEmpty((String)message)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("bitstreamId", bitstreamId);
            if (StringUtils.isEmpty((String)requesterEmail)) {
                map.put("requesterEmail", eperson);
            } else {
                map.put("requesterEmail", requesterEmail);
            }
            map.put("requesterName", requesterName);
            map.put("allFiles", allFiles);
            map.put("message", message);
            return map;
        }
        DSpaceObject dso = HandleUtil.obtainHandle((Map)objectModel);
        if (!(dso instanceof Item)) {
            throw new Exception("Invalid DspaceObject at ItemRequest.");
        }
        Item item = (Item)dso;
        String title = "";
        DCValue[] titleDC = item.getDC("title", null, "*");
        if (titleDC != null || titleDC.length > 0) {
            title = titleDC[0].value;
        }
        RequestItemAuthor author = ((RequestItemAuthorExtractor)new DSpace().getServiceManager().getServiceByName(RequestItemAuthorExtractor.class.getName(), RequestItemAuthorExtractor.class)).getRequestItemAuthor(context, item);
        String authorEmail = author.getEmail();
        String authorName = author.getFullName();
        String emailRequest = authorEmail != null ? authorEmail : ConfigurationManager.getProperty((String)"mail.helpdesk");
        if (emailRequest == null) {
            emailRequest = ConfigurationManager.getProperty((String)"mail.admin");
        }
        Email email = Email.getEmail((String)I18nUtil.getEmailFilename((Locale)context.getCurrentLocale(), (String)"request_item.author"));
        email.addRecipient(emailRequest);
        email.addArgument((Object)requesterName);
        email.addArgument((Object)requesterEmail);
        email.addArgument((Object)(allFiles.equals("true") ? I18nUtil.getMessage((String)"itemRequest.all") : Bitstream.find((Context)context, (int)Integer.parseInt(bitstreamId)).getName()));
        email.addArgument((Object)HandleManager.getCanonicalForm((String)item.getHandle()));
        email.addArgument((Object)title);
        email.addArgument((Object)message);
        email.addArgument((Object)this.getLinkTokenEmail(context, request, bitstreamId, item.getID(), requesterEmail, requesterName, Boolean.parseBoolean(allFiles)));
        email.addArgument((Object)authorName);
        email.addArgument((Object)authorEmail);
        email.addArgument((Object)ConfigurationManager.getProperty((String)"dspace.name"));
        email.addArgument((Object)ConfigurationManager.getProperty((String)"mail.helpdesk"));
        email.setReplyTo(requesterEmail);
        email.send();
        return null;
    }

    protected String getLinkTokenEmail(Context context, Request request, String bitstreamId, int itemID, String reqEmail, String reqName, boolean allfiles) throws SQLException {
        String base = ConfigurationManager.getProperty((String)"dspace.url");
        request.getPathInfo();
        String specialLink = new StringBuffer().append(base).append(base.endsWith("/") ? "" : "/").append("itemRequestResponse/").append(this.getNewToken(context, Integer.parseInt(bitstreamId), itemID, reqEmail, reqName, allfiles)).toString() + "/";
        return specialLink;
    }

    protected String getNewToken(Context context, int bitstreamId, int itemID, String reqEmail, String reqName, boolean allfiles) throws SQLException {
        TableRow rd = DatabaseManager.create((Context)context, (String)"requestitem");
        rd.setColumn("token", Utils.generateHexKey());
        rd.setColumn("bitstream_id", bitstreamId);
        rd.setColumn("item_id", itemID);
        rd.setColumn("allfiles", allfiles);
        rd.setColumn("request_email", reqEmail);
        rd.setColumn("request_name", reqName);
        rd.setColumnNull("accept_request");
        rd.setColumn("request_date", new Date());
        rd.setColumnNull("decision_date");
        rd.setColumnNull("expires");
        DatabaseManager.update((Context)context, (TableRow)rd);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created requestitem_token " + rd.getIntColumn("requestitem_id") + " with token " + rd.getStringColumn("token") + "\""));
        }
        return rd.getStringColumn("token");
    }
}

