/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.opensearch;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.util.HashUtil;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.util.OpenSearch;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DescriptionOpenSearchGenerator
extends AbstractGenerator
implements CacheableProcessingComponent,
Recyclable {
    protected DSpaceObject scope = null;

    public Serializable getKey() {
        StringBuffer key = new StringBuffer("key:");
        key.append(DescriptionOpenSearchGenerator.class.getName());
        if (this.scope != null) {
            key.append(":" + this.scope.getHandle());
        }
        return Long.valueOf(HashUtil.hash((String)key.toString()));
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        Context context = null;
        try {
            context = ContextUtil.obtainContext((Map)objectModel);
        }
        catch (SQLException e) {
            throw new ProcessingException("Couldn't get DSpace Context object", (Throwable)e);
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String scopeParam = request.getParameter("scope");
        try {
            this.scope = OpenSearch.resolveScope((Context)context, (String)scopeParam);
        }
        catch (SQLException e) {
            throw new ProcessingException("Error resolving scope handle param " + scopeParam, (Throwable)e);
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Document retDoc = OpenSearch.getDescriptionDoc(this.scope == null ? null : this.scope.getHandle());
        DOMStreamer streamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
        streamer.stream((Node)retDoc);
    }

    public void recycle() {
        this.scope = null;
        super.recycle();
    }
}

