/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.Constants;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.aspect.administrative.ControlPanel;
import org.dspace.app.xmlui.aspect.administrative.CurrentActivityAction;
import org.dspace.app.xmlui.aspect.administrative.SystemwideAlerts;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.OAIHarvester;
import org.xml.sax.SAXException;

public class ControlPanel
extends AbstractDSpaceTransformer
implements Serviceable,
Disposable {
    private static final Message T_DSPACE_HOME = ControlPanel.message((String)"xmlui.general.dspace_home");
    private static final Message T_title = ControlPanel.message((String)"xmlui.administrative.ControlPanel.title");
    private static final Message T_trail = ControlPanel.message((String)"xmlui.administrative.ControlPanel.trail");
    private static final Message T_head = ControlPanel.message((String)"xmlui.administrative.ControlPanel.head");
    private static final Message T_option_java = ControlPanel.message((String)"xmlui.administrative.ControlPanel.option_java");
    private static final Message T_option_dspace = ControlPanel.message((String)"xmlui.administrative.ControlPanel.option_dspace");
    private static final Message T_option_alerts = ControlPanel.message((String)"xmlui.administrative.ControlPanel.option_alerts");
    private static final Message T_seconds = ControlPanel.message((String)"xmlui.administrative.ControlPanel.seconds");
    private static final Message T_hours = ControlPanel.message((String)"xmlui.administrative.ControlPanel.hours");
    private static final Message T_minutes = ControlPanel.message((String)"xmlui.administrative.ControlPanel.minutes");
    private static final Message T_JAVA_HEAD = ControlPanel.message((String)"xmlui.administrative.ControlPanel.java_head");
    private static final Message T_JAVA_VERSION = ControlPanel.message((String)"xmlui.administrative.ControlPanel.java_version");
    private static final Message T_JAVA_VENDOR = ControlPanel.message((String)"xmlui.administrative.ControlPanel.java_vendor");
    private static final Message T_OS_NAME = ControlPanel.message((String)"xmlui.administrative.ControlPanel.os_name");
    private static final Message T_OS_ARCH = ControlPanel.message((String)"xmlui.administrative.ControlPanel.os_arch");
    private static final Message T_OS_VERSION = ControlPanel.message((String)"xmlui.administrative.ControlPanel.os_version");
    private static final Message T_RUNTIME_HEAD = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_head");
    private static final Message T_RUNTIME_PROCESSORS = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_processors");
    private static final Message T_RUNTIME_MAX = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_max");
    private static final Message T_RUNTIME_TOTAL = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_total");
    private static final Message T_RUNTIME_USED = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_used");
    private static final Message T_RUNTIME_FREE = ControlPanel.message((String)"xmlui.administrative.ControlPanel.runtime_free");
    private static final Message T_COCOON_HEAD = ControlPanel.message((String)"xmlui.administrative.ControlPanel.cocoon_head");
    private static final Message T_COCOON_VERSION = ControlPanel.message((String)"xmlui.administrative.ControlPanel.cocoon_version");
    private static final Message T_COCOON_CACHE_DIR = ControlPanel.message((String)"xmlui.administrative.ControlPanel.cocoon_cache_dir");
    private static final Message T_COCOON_WORK_DIR = ControlPanel.message((String)"xmlui.administrative.ControlPanel.cocoon_work_dir");
    private static final Message T_COCOON_MAIN_CACHE_SIZE = ControlPanel.message((String)"xmlui.administrative.ControlPanel.cocoon_main_cache_size");
    private static final Message T_COCOON_PERSISTENT_CACHE_SIZE = ControlPanel.message((String)"xmlui.administrative.ControlPanel.cocoon_persistent_cache_size");
    private static final Message T_COCOON_TRANS_CACHE_SIZE = ControlPanel.message((String)"xmlui.administrative.ControlPanel.cocoon_transient_cache_size");
    private static final Message T_COCOON_CACHE_CLEAR = ControlPanel.message((String)"xmlui.administrative.ControlPanel.cocoon_cache_clear");
    private static final Message T_DSPACE_HEAD = ControlPanel.message((String)"xmlui.administrative.ControlPanel.dspace_head");
    private static final Message T_DSPACE_DIR = ControlPanel.message((String)"xmlui.administrative.ControlPanel.dspace_dir");
    private static final Message T_DSPACE_URL = ControlPanel.message((String)"xmlui.administrative.ControlPanel.dspace_url");
    private static final Message T_DSPACE_HOST_NAME = ControlPanel.message((String)"xmlui.administrative.ControlPanel.dspace_hostname");
    private static final Message T_DSPACE_NAME = ControlPanel.message((String)"xmlui.administrative.ControlPanel.dspace_name");
    private static final Message T_DSPACE_VERSION = ControlPanel.message((String)"xmlui.administrative.ControlPanel.dspace_version");
    private static final Message T_DB_NAME = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_name");
    private static final Message T_DB_URL = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_url");
    private static final Message T_DB_DRIVER = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_driver");
    private static final Message T_DB_MAX_CONN = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_maxconnections");
    private static final Message T_DB_MAX_WAIT = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_maxwait");
    private static final Message T_DB_MAX_IDLE = ControlPanel.message((String)"xmlui.administrative.ControlPanel.db_maxidle");
    private static final Message T_MAIL_SERVER = ControlPanel.message((String)"xmlui.administrative.ControlPanel.mail_server");
    private static final Message T_MAIL_FROM_ADDRESS = ControlPanel.message((String)"xmlui.administrative.ControlPanel.mail_from_address");
    private static final Message T_FEEDBACK_RECIPIENT = ControlPanel.message((String)"xmlui.administrative.ControlPanel.mail_feedback_recipient");
    private static final Message T_MAIL_ADMIN = ControlPanel.message((String)"xmlui.administrative.ControlPanel.mail_admin");
    private static final Message T_alerts_head = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_head");
    private static final Message T_alerts_warning = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_warning");
    private static final Message T_alerts_message_label = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_message_label");
    private static final Message T_alerts_message_default = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_message_default");
    private static final Message T_alerts_countdown_label = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_label");
    private static final Message T_alerts_countdown_none = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_none");
    private static final Message T_alerts_countdown_5 = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_5");
    private static final Message T_alerts_countdown_15 = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_15");
    private static final Message T_alerts_countdown_30 = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_30");
    private static final Message T_alerts_countdown_60 = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_60");
    private static final Message T_alerts_countdown_keep = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_countdown_keep");
    private static final Message T_alerts_session_label = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_session_label");
    private static final Message T_alerts_session_all_sessions = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_session_all_sessions");
    private static final Message T_alerts_session_current_sessions = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_session_current_sessions");
    private static final Message T_alerts_session_only_administrative = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_session_only_administrative_sessions");
    private static final Message T_alerts_session_note = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_session_note");
    private static final Message T_alerts_submit_activate = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_submit_activate");
    private static final Message T_alerts_submit_deactivate = ControlPanel.message((String)"xmlui.administrative.ControlPanel.alerts_submit_deactivate");
    private static final Message T_activity_head = ControlPanel.message((String)"xmlui.administrative.ControlPanel.activity_head");
    private static final Message T_stop_anonymous = ControlPanel.message((String)"xmlui.administrative.ControlPanel.stop_anonymous");
    private static final Message T_start_anonymous = ControlPanel.message((String)"xmlui.administrative.ControlPanel.start_anonymous");
    private static final Message T_stop_bot = ControlPanel.message((String)"xmlui.administrative.ControlPanel.stop_bot");
    private static final Message T_start_bot = ControlPanel.message((String)"xmlui.administrative.ControlPanel.start_bot");
    private static final Message T_activity_sort_time = ControlPanel.message((String)"xmlui.administrative.ControlPanel.activity_sort_time");
    private static final Message T_activity_sort_user = ControlPanel.message((String)"xmlui.administrative.ControlPanel.activity_sort_user");
    private static final Message T_activity_sort_ip = ControlPanel.message((String)"xmlui.administrative.ControlPanel.activity_sort_ip");
    private static final Message T_activity_sort_url = ControlPanel.message((String)"xmlui.administrative.ControlPanel.activity_sort_url");
    private static final Message T_activity_sort_agent = ControlPanel.message((String)"xmlui.administrative.ControlPanel.activity_sort_Agent");
    private static final Message T_activity_anonymous = ControlPanel.message((String)"xmlui.administrative.ControlPanel.activity_anonymous");
    private static final Message T_activity_none = ControlPanel.message((String)"xmlui.administrative.ControlPanel.activity_none");
    private static final Message T_select_panel = ControlPanel.message((String)"xmlui.administrative.ControlPanel.select_panel");
    private static final Message T_option_harvest = ControlPanel.message((String)"xmlui.administrative.ControlPanel.option_harvest");
    private static final Message T_harvest_scheduler_head = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_scheduler_head");
    private static final Message T_harvest_label_status = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_label_status");
    private static final Message T_harvest_label_actions = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_label_actions");
    private static final Message T_harvest_submit_start = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_submit_start");
    private static final Message T_harvest_submit_reset = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_submit_reset");
    private static final Message T_harvest_submit_resume = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_submit_resume");
    private static final Message T_harvest_submit_pause = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_submit_pause");
    private static final Message T_harvest_submit_stop = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_submit_stop");
    private static final Message T_harvest_label_collections = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_label_collections");
    private static final Message T_harvest_label_active = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_label_active");
    private static final Message T_harvest_label_queued = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_label_queued");
    private static final Message T_harvest_label_oai_errors = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_label_oai_errors");
    private static final Message T_harvest_label_internal_errors = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_label_internal_errors");
    private static final Message T_harvest_head_generator_settings = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_head_generator_settings");
    private static final Message T_harvest_label_oai_url = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_label_oai_url");
    private static final Message T_harvest_label_oai_source = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_label_oai_source");
    private static final Message T_harvest_head_harvester_settings = ControlPanel.message((String)"xmlui.administrative.ControlPanel.harvest_head_harvester_settings");
    private ServiceManager serviceManager;
    private Settings settings;
    private StoreJanitor storeJanitor;
    private Store storeDefault;
    private Store storePersistent;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
        this.settings = (Settings)this.serviceManager.lookup(Settings.ROLE);
        if (this.serviceManager.hasService(StoreJanitor.ROLE)) {
            this.storeJanitor = (StoreJanitor)this.serviceManager.lookup(StoreJanitor.ROLE);
        }
        if (this.serviceManager.hasService(Store.ROLE)) {
            this.storeDefault = (Store)this.serviceManager.lookup(Store.ROLE);
        }
        if (this.serviceManager.hasService(Store.PERSISTENT_STORE)) {
            this.storePersistent = (Store)this.serviceManager.lookup(Store.PERSISTENT_STORE);
        }
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_DSPACE_HOME);
        pageMeta.addTrailLink(null, T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        if (!AuthorizeManager.isAdmin((Context)this.context)) {
            throw new AuthorizeException("You are not authorized to view this page.");
        }
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        OPTIONS option = null;
        if (request.getParameter("java") != null) {
            option = OPTIONS.java;
        }
        if (request.getParameter("dspace") != null) {
            option = OPTIONS.dspace;
        }
        if (request.getParameter("alerts") != null) {
            option = OPTIONS.alerts;
        }
        if (request.getParameter("activity") != null) {
            option = OPTIONS.activity;
        }
        if (request.getParameter("harvest") != null) {
            option = OPTIONS.harvest;
        }
        Division div = body.addInteractiveDivision("control-panel", this.contextPath + "/admin/panel", "post", "primary administrative");
        div.setHead(T_head);
        org.dspace.app.xmlui.wing.element.List options = div.addList("options", "simple", "horizontal");
        if (option == OPTIONS.java) {
            options.addItem().addHighlight("bold").addXref("?java", T_option_java);
        } else {
            options.addItemXref("?java", T_option_java);
        }
        if (option == OPTIONS.dspace) {
            options.addItem().addHighlight("bold").addXref("?dspace", T_option_dspace);
        } else {
            options.addItemXref("?dspace", T_option_dspace);
        }
        if (option == OPTIONS.alerts) {
            options.addItem().addHighlight("bold").addXref("?alerts", T_option_alerts);
        } else {
            options.addItemXref("?alerts", T_option_alerts);
        }
        if (option == OPTIONS.harvest) {
            options.addItem().addHighlight("bold").addXref("?harvest", T_option_harvest);
        } else {
            options.addItemXref("?harvest", T_option_harvest);
        }
        String userSortTarget = "?activity";
        if (request.getParameter("sortBy") != null) {
            userSortTarget = userSortTarget + "&sortBy=" + request.getParameter("sortBy");
        }
        if (option == OPTIONS.activity) {
            options.addItem().addHighlight("bold").addXref(userSortTarget, "Current Activity");
        } else {
            options.addItemXref(userSortTarget, "Current Activity");
        }
        if (option == OPTIONS.java) {
            this.addJavaInformation(div);
        } else if (option == OPTIONS.dspace) {
            this.addDSpaceConfiguration(div);
        } else if (option == OPTIONS.alerts) {
            this.addAlerts(div);
        } else if (option == OPTIONS.activity) {
            this.addActivity(div);
        } else if (option == OPTIONS.harvest) {
            this.addHarvest(div);
        } else {
            div.addPara(T_select_panel);
        }
    }

    private void addJavaInformation(Division div) throws WingException {
        int processors = Runtime.getRuntime().availableProcessors();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        maxMemory = maxMemory / 1024L / 1024L;
        totalMemory = totalMemory / 1024L / 1024L;
        usedMemory = usedMemory / 1024L / 1024L;
        freeMemory = freeMemory / 1024L / 1024L;
        org.dspace.app.xmlui.wing.element.List list = div.addList("javaOs");
        list.setHead(T_JAVA_HEAD);
        list.addLabel(T_JAVA_VERSION);
        list.addItem(System.getProperty("java.version"));
        list.addLabel(T_JAVA_VENDOR);
        list.addItem(System.getProperty("java.vm.name"));
        list.addLabel(T_OS_NAME);
        list.addItem(System.getProperty("os.name"));
        list.addLabel(T_OS_ARCH);
        list.addItem(System.getProperty("os.arch"));
        list.addLabel(T_OS_VERSION);
        list.addItem(System.getProperty("os.version"));
        org.dspace.app.xmlui.wing.element.List runtime = div.addList("runtime");
        runtime.setHead(T_RUNTIME_HEAD);
        runtime.addLabel(T_RUNTIME_PROCESSORS);
        runtime.addItem(String.valueOf(processors));
        runtime.addLabel(T_RUNTIME_MAX);
        runtime.addItem(String.valueOf(maxMemory) + " MiB");
        runtime.addLabel(T_RUNTIME_TOTAL);
        runtime.addItem(String.valueOf(totalMemory) + " MiB");
        runtime.addLabel(T_RUNTIME_USED);
        runtime.addItem(String.valueOf(usedMemory) + " MiB");
        runtime.addLabel(T_RUNTIME_FREE);
        runtime.addItem(String.valueOf(freeMemory) + " MiB");
        this.addCocoonInformation(div);
    }

    private void addCocoonInformation(Division div) throws WingException {
        String storeName;
        org.dspace.app.xmlui.wing.element.List cocoon = div.addList("cocoon");
        cocoon.setHead(T_COCOON_HEAD);
        cocoon.addLabel(T_COCOON_VERSION);
        cocoon.addItem(Constants.VERSION);
        if (this.settings != null) {
            cocoon.addLabel(T_COCOON_WORK_DIR);
            cocoon.addItem(this.settings.getWorkDirectory());
            cocoon.addLabel(T_COCOON_CACHE_DIR);
            cocoon.addItem(this.settings.getCacheDirectory());
        }
        if (this.storeDefault != null) {
            storeName = this.storeDefault.getClass().getName();
            storeName = storeName.substring(storeName.lastIndexOf(".") + 1);
            cocoon.addLabel(T_COCOON_MAIN_CACHE_SIZE.parameterize(new Object[]{storeName + ", 0x" + Integer.toHexString(this.storeDefault.hashCode())}));
            Item defaultSize = cocoon.addItem();
            defaultSize.addContent(String.valueOf(this.storeDefault.size()) + "  ");
            defaultSize.addXref(this.contextPath + "/admin/panel?java=true&clearcache=true", T_COCOON_CACHE_CLEAR);
        }
        if (this.storePersistent != null) {
            storeName = this.storeDefault.getClass().getName();
            storeName = storeName.substring(storeName.lastIndexOf(".") + 1);
            cocoon.addLabel(T_COCOON_PERSISTENT_CACHE_SIZE.parameterize(new Object[]{storeName + ", 0x" + Integer.toHexString(this.storePersistent.hashCode())}));
            cocoon.addItem(String.valueOf(this.storePersistent.size()));
        }
        if (this.storeJanitor != null) {
            for (Store store : this.storeJanitor) {
                String storeName2 = store.getClass().getName();
                storeName2 = storeName2.substring(storeName2.lastIndexOf(".") + 1);
                cocoon.addLabel(T_COCOON_TRANS_CACHE_SIZE.parameterize(new Object[]{storeName2 + ", 0x" + Integer.toHexString(store.hashCode())}));
                cocoon.addItem(String.valueOf(store.size()));
            }
        }
    }

    private void addDSpaceConfiguration(Division div) throws WingException {
        org.dspace.app.xmlui.wing.element.List dspace = div.addList("dspace");
        dspace.setHead(T_DSPACE_HEAD);
        dspace.addLabel(T_DSPACE_VERSION);
        dspace.addItem(Util.getSourceVersion());
        dspace.addLabel(T_DSPACE_DIR);
        dspace.addItem(ConfigurationManager.getProperty((String)"dspace.dir"));
        dspace.addLabel(T_DSPACE_URL);
        dspace.addItem(ConfigurationManager.getProperty((String)"dspace.url"));
        dspace.addLabel(T_DSPACE_HOST_NAME);
        dspace.addItem(ConfigurationManager.getProperty((String)"dspace.hostname"));
        dspace.addLabel(T_DSPACE_NAME);
        dspace.addItem(ConfigurationManager.getProperty((String)"dspace.name"));
        dspace.addLabel(T_DB_NAME);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.name"));
        dspace.addLabel(T_DB_URL);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.url"));
        dspace.addLabel(T_DB_DRIVER);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.driver"));
        dspace.addLabel(T_DB_MAX_CONN);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.maxconnections"));
        dspace.addLabel(T_DB_MAX_WAIT);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.maxwait"));
        dspace.addLabel(T_DB_MAX_IDLE);
        dspace.addItem(ConfigurationManager.getProperty((String)"db.maxidle"));
        dspace.addLabel(T_MAIL_SERVER);
        dspace.addItem(ConfigurationManager.getProperty((String)"mail.server"));
        dspace.addLabel(T_MAIL_FROM_ADDRESS);
        dspace.addItem(ConfigurationManager.getProperty((String)"mail.from.address"));
        dspace.addLabel(T_FEEDBACK_RECIPIENT);
        dspace.addItem(ConfigurationManager.getProperty((String)"feedback.recipient"));
        dspace.addLabel(T_MAIL_ADMIN);
        dspace.addItem(ConfigurationManager.getProperty((String)"mail.admin"));
    }

    private void addAlerts(Division div) throws WingException {
        div.addHidden("alerts").setValue("true");
        org.dspace.app.xmlui.wing.element.List form = div.addList("system-wide-alerts", "form");
        form.setHead(T_alerts_head);
        form.addItem(T_alerts_warning);
        TextArea message = form.addItem().addTextArea("message");
        message.setAutofocus("autofocus");
        message.setLabel(T_alerts_message_label);
        message.setSize(5, 45);
        if (SystemwideAlerts.getMessage() == null) {
            message.setValue(T_alerts_message_default);
        } else {
            message.setValue(SystemwideAlerts.getMessage());
        }
        Select countdown = form.addItem().addSelect("countdown");
        countdown.setLabel(T_alerts_countdown_label);
        countdown.addOption(0, T_alerts_countdown_none);
        countdown.addOption(5, T_alerts_countdown_5);
        countdown.addOption(15, T_alerts_countdown_15);
        countdown.addOption(30, T_alerts_countdown_30);
        countdown.addOption(60, T_alerts_countdown_60);
        if (SystemwideAlerts.isAlertActive() && SystemwideAlerts.getCountDownToo() - System.currentTimeMillis() > 0L) {
            countdown.addOption(true, -1, T_alerts_countdown_keep);
        } else {
            countdown.setOptionSelected(0);
        }
        Select restrictsessions = form.addItem().addSelect("restrictsessions");
        restrictsessions.setLabel(T_alerts_session_label);
        restrictsessions.addOption(1, T_alerts_session_all_sessions);
        restrictsessions.addOption(2, T_alerts_session_current_sessions);
        restrictsessions.addOption(3, T_alerts_session_only_administrative);
        restrictsessions.setOptionSelected(SystemwideAlerts.getRestrictSessions());
        form.addItem(T_alerts_session_note);
        Item actions = form.addItem();
        actions.addButton("submit_activate").setValue(T_alerts_submit_activate);
        actions.addButton("submit_deactivate").setValue(T_alerts_submit_deactivate);
    }

    private void addActivity(Division div) throws WingException, SQLException {
        String recordBotString;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String recordAnonymousString = request.getParameter("recordanonymous");
        if (recordAnonymousString != null) {
            if ("ON".equals(recordAnonymousString)) {
                CurrentActivityAction.setRecordAnonymousEvents((boolean)true);
            }
            if ("OFF".equals(recordAnonymousString)) {
                CurrentActivityAction.setRecordAnonymousEvents((boolean)false);
            }
        }
        if ((recordBotString = request.getParameter("recordbots")) != null) {
            if ("ON".equals(recordBotString)) {
                CurrentActivityAction.setRecordBotEvents((boolean)true);
            }
            if ("OFF".equals(recordBotString)) {
                CurrentActivityAction.setRecordBotEvents((boolean)false);
            }
        }
        EventSort sortBy = EventSort.TIME;
        String sortByString = request.getParameter("sortBy");
        if (EventSort.TIME.toString().equals(sortByString)) {
            sortBy = EventSort.TIME;
        }
        if (EventSort.URL.toString().equals(sortByString)) {
            sortBy = EventSort.URL;
        }
        if (EventSort.SESSION.toString().equals(sortByString)) {
            sortBy = EventSort.SESSION;
        }
        if (EventSort.AGENT.toString().equals(sortByString)) {
            sortBy = EventSort.AGENT;
        }
        if (EventSort.IP.toString().equals(sortByString)) {
            sortBy = EventSort.IP;
        }
        List events = CurrentActivityAction.getEvents();
        Collections.sort(events, new ActivitySort(sortBy));
        Collections.reverse(events);
        if (CurrentActivityAction.getRecordAnonymousEvents()) {
            div.addPara().addXref("?activity&sortBy=" + sortBy + "&recordanonymous=OFF").addContent(T_stop_anonymous);
        } else {
            div.addPara().addXref("?activity&sortBy=" + sortBy + "&recordanonymous=ON").addContent(T_start_anonymous);
        }
        if (CurrentActivityAction.getRecordBotEvents()) {
            div.addPara().addXref("?activity&sortBy=" + sortBy + "&recordbots=OFF").addContent(T_stop_bot);
        } else {
            div.addPara().addXref("?activity&sortBy=" + sortBy + "&recordbots=ON").addContent(T_start_bot);
        }
        Table activeUsers = div.addTable("users", 1, 1);
        activeUsers.setHead(T_activity_head.parameterize(new Object[]{CurrentActivityAction.MAX_EVENTS}));
        Row row = activeUsers.addRow("header");
        if (sortBy == EventSort.TIME) {
            row.addCell().addHighlight("bold").addXref("?activity&sortBy=" + EventSort.TIME).addContent(T_activity_sort_time);
        } else {
            row.addCell().addXref("?activity&sortBy=" + EventSort.TIME).addContent(T_activity_sort_time);
        }
        if (sortBy == EventSort.SESSION) {
            row.addCell().addHighlight("bold").addXref("?activity&sortBy=" + EventSort.SESSION).addContent(T_activity_sort_user);
        } else {
            row.addCell().addXref("?activity&sortBy=" + EventSort.SESSION).addContent(T_activity_sort_user);
        }
        if (sortBy == EventSort.IP) {
            row.addCell().addHighlight("bold").addXref("?activity&sortBy=" + EventSort.IP).addContent(T_activity_sort_ip);
        } else {
            row.addCell().addXref("?activity&sortBy=" + EventSort.IP).addContent(T_activity_sort_ip);
        }
        if (sortBy == EventSort.URL) {
            row.addCell().addHighlight("bold").addXref("?activity&sortBy=" + EventSort.URL).addContent(T_activity_sort_url);
        } else {
            row.addCell().addXref("?activity&sortBy=" + EventSort.URL).addContent(T_activity_sort_url);
        }
        if (sortBy == EventSort.AGENT) {
            row.addCell().addHighlight("bold").addXref("?activity&sortBy=" + EventSort.AGENT).addContent(T_activity_sort_agent);
        } else {
            row.addCell().addXref("?activity&sortBy=" + EventSort.AGENT).addContent(T_activity_sort_agent);
        }
        HashMap<String, Integer> anonymousHash = new HashMap<String, Integer>();
        int anonymousCount = 1;
        int shown = 0;
        for (CurrentActivityAction.Event event : events) {
            if (event == null) continue;
            ++shown;
            Message timeStampMessage = null;
            long ago = System.currentTimeMillis() - event.getTimeStamp();
            timeStampMessage = ago > 0x6DDD00L ? T_hours.parameterize(new Object[]{ago / 3600000L}) : (ago > 60000L ? T_minutes.parameterize(new Object[]{ago / 60000L}) : T_seconds.parameterize(new Object[]{ago / 1000L}));
            Row eventRow = activeUsers.addRow();
            eventRow.addCellContent(timeStampMessage);
            int eid = event.getEPersonID();
            EPerson eperson = EPerson.find((Context)this.context, (int)eid);
            if (eperson != null) {
                String name = eperson.getFullName();
                eventRow.addCellContent(name);
            } else {
                if (!anonymousHash.containsKey(event.getSessionID())) {
                    anonymousHash.put(event.getSessionID(), anonymousCount++);
                }
                eventRow.addCellContent(T_activity_anonymous.parameterize(new Object[]{anonymousHash.get(event.getSessionID())}));
            }
            eventRow.addCellContent(event.getIP());
            eventRow.addCell().addXref(this.contextPath + "/" + event.getURL()).addContent("/" + event.getURL());
            eventRow.addCellContent(event.getDectectedBrowser());
        }
        if (shown == 0) {
            activeUsers.addRow().addCell(1, 5).addContent(T_activity_none);
        }
    }

    private void addHarvest(Division div) throws WingException, SQLException {
        div.addHidden("harvest").setValue("true");
        org.dspace.app.xmlui.wing.element.List harvesterControls = div.addList("oai-harvester-controls", "form");
        harvesterControls.setHead(T_harvest_scheduler_head);
        harvesterControls.addLabel(T_harvest_label_status);
        Item status = harvesterControls.addItem();
        status.addContent(OAIHarvester.HarvestScheduler.getStatus());
        status.addXref(this.contextPath + "/admin/panel?harvest", "(refresh)");
        harvesterControls.addLabel(T_harvest_label_actions);
        Item actionsItem = harvesterControls.addItem();
        if (OAIHarvester.HarvestScheduler.hasStatus((int)4)) {
            actionsItem.addButton("submit_harvest_start").setValue(T_harvest_submit_start);
            actionsItem.addButton("submit_harvest_reset").setValue(T_harvest_submit_reset);
        }
        if (OAIHarvester.HarvestScheduler.hasStatus((int)3)) {
            actionsItem.addButton("submit_harvest_resume").setValue(T_harvest_submit_resume);
        }
        if (OAIHarvester.HarvestScheduler.hasStatus((int)1) || OAIHarvester.HarvestScheduler.hasStatus((int)2)) {
            actionsItem.addButton("submit_harvest_pause").setValue(T_harvest_submit_pause);
        }
        if (!OAIHarvester.HarvestScheduler.hasStatus((int)4)) {
            actionsItem.addButton("submit_harvest_stop").setValue(T_harvest_submit_stop);
        }
        String baseURL = this.contextPath + "/admin/collection?collectionID=";
        harvesterControls.addLabel(T_harvest_label_collections);
        Item allCollectionsItem = harvesterControls.addItem();
        List allCollections = HarvestedCollection.findAll((Context)this.context);
        for (Integer oaiCollection : allCollections) {
            allCollectionsItem.addXref(baseURL + oaiCollection, oaiCollection.toString());
        }
        harvesterControls.addLabel(T_harvest_label_active);
        Item busyCollectionsItem = harvesterControls.addItem();
        List busyCollections = HarvestedCollection.findByStatus((Context)this.context, (int)1);
        for (Integer busyCollection : busyCollections) {
            busyCollectionsItem.addXref(baseURL + busyCollection, busyCollection.toString());
        }
        harvesterControls.addLabel(T_harvest_label_queued);
        Item queuedCollectionsItem = harvesterControls.addItem();
        List queuedCollections = HarvestedCollection.findByStatus((Context)this.context, (int)2);
        for (Integer queuedCollection : queuedCollections) {
            queuedCollectionsItem.addXref(baseURL + queuedCollection, queuedCollection.toString());
        }
        harvesterControls.addLabel(T_harvest_label_oai_errors);
        Item oaiErrorsItem = harvesterControls.addItem();
        List oaiErrors = HarvestedCollection.findByStatus((Context)this.context, (int)3);
        for (Integer oaiError : oaiErrors) {
            oaiErrorsItem.addXref(baseURL + oaiError, oaiError.toString());
        }
        harvesterControls.addLabel(T_harvest_label_internal_errors);
        Item internalErrorsItem = harvesterControls.addItem();
        List internalErrors = HarvestedCollection.findByStatus((Context)this.context, (int)-1);
        for (Integer internalError : internalErrors) {
            internalErrorsItem.addXref(baseURL + internalError, internalError.toString());
        }
        org.dspace.app.xmlui.wing.element.List generatorSettings = div.addList("oai-generator-settings");
        generatorSettings.setHead(T_harvest_head_generator_settings);
        generatorSettings.addLabel(T_harvest_label_oai_url);
        String oaiUrl = ConfigurationManager.getProperty((String)"oai", (String)"dspace.oai.url");
        if (!StringUtils.isEmpty((String)oaiUrl)) {
            generatorSettings.addItem(oaiUrl);
        }
        generatorSettings.addLabel(T_harvest_label_oai_source);
        String oaiAuthoritativeSource = ConfigurationManager.getProperty((String)"oai", (String)"ore.authoritative.source");
        if (!StringUtils.isEmpty((String)oaiAuthoritativeSource)) {
            generatorSettings.addItem(oaiAuthoritativeSource);
        } else {
            generatorSettings.addItem("oai");
        }
        org.dspace.app.xmlui.wing.element.List harvesterSettings = div.addList("oai-harvester-settings");
        harvesterSettings.setHead(T_harvest_head_harvester_settings);
        String metaString = "harvester.";
        Enumeration pe = ConfigurationManager.propertyNames();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(metaString)) continue;
            harvesterSettings.addLabel(key);
            harvesterSettings.addItem(ConfigurationManager.getProperty((String)key) + " ");
        }
    }

    public void dispose() {
        if (this.serviceManager != null) {
            this.serviceManager.release((Object)this.storePersistent);
            this.serviceManager.release((Object)this.storeJanitor);
            this.serviceManager.release((Object)this.storeDefault);
            this.serviceManager.release((Object)this.settings);
            this.storePersistent = null;
            this.storeJanitor = null;
            this.storeDefault = null;
            this.settings = null;
        }
        super.dispose();
    }
}

