/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.eperson;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

public class DeleteEPeopleConfirm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = DeleteEPeopleConfirm.message((String)"xmlui.general.dspace_home");
    private static final Message T_eperson_trail = DeleteEPeopleConfirm.message((String)"xmlui.administrative.eperson.general.epeople_trail");
    private static final Message T_title = DeleteEPeopleConfirm.message((String)"xmlui.administrative.eperson.DeleteEPeopleConfirm.title");
    private static final Message T_trail = DeleteEPeopleConfirm.message((String)"xmlui.administrative.eperson.DeleteEPeopleConfirm.trail");
    private static final Message T_confirm_head = DeleteEPeopleConfirm.message((String)"xmlui.administrative.eperson.DeleteEPeopleConfirm.confirm_head");
    private static final Message T_confirm_para = DeleteEPeopleConfirm.message((String)"xmlui.administrative.eperson.DeleteEPeopleConfirm.confirm_para");
    private static final Message T_head_id = DeleteEPeopleConfirm.message((String)"xmlui.administrative.eperson.DeleteEPeopleConfirm.head_id");
    private static final Message T_head_name = DeleteEPeopleConfirm.message((String)"xmlui.administrative.eperson.DeleteEPeopleConfirm.head_name");
    private static final Message T_head_email = DeleteEPeopleConfirm.message((String)"xmlui.administrative.eperson.DeleteEPeopleConfirm.head_email");
    private static final Message T_submit_confirm = DeleteEPeopleConfirm.message((String)"xmlui.administrative.eperson.DeleteEPeopleConfirm.submit_confirm");
    private static final Message T_submit_cancel = DeleteEPeopleConfirm.message((String)"xmlui.general.cancel");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/epeople", T_eperson_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        String idsString = this.parameters.getParameter("epeopleIDs", null);
        ArrayList<EPerson> epeople = new ArrayList<EPerson>();
        for (String id : idsString.split(",")) {
            EPerson person = EPerson.find((Context)this.context, (int)Integer.valueOf(id));
            epeople.add(person);
        }
        Division deleted = body.addInteractiveDivision("epeople-confirm-delete", this.contextPath + "/admin/epeople", "post", "primary administrative eperson");
        deleted.setHead(T_confirm_head);
        deleted.addPara(T_confirm_para);
        Table table = deleted.addTable("epeople-confirm-delete", epeople.size() + 1, 1);
        Row header = table.addRow("header");
        header.addCell().addContent(T_head_id);
        header.addCell().addContent(T_head_name);
        header.addCell().addContent(T_head_email);
        for (EPerson eperson : epeople) {
            Row row = table.addRow();
            row.addCell().addContent(eperson.getID());
            row.addCell().addContent(eperson.getFullName());
            row.addCell().addContent(eperson.getEmail());
        }
        Para buttons = deleted.addPara();
        buttons.addButton("submit_confirm").setValue(T_submit_confirm);
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
        deleted.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

