/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.mapper;

import java.sql.SQLException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class MapperMain
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = MapperMain.message((String)"xmlui.general.dspace_home");
    private static final Message T_submit_return = MapperMain.message((String)"xmlui.general.return");
    private static final Message T_mapper_trail = MapperMain.message((String)"xmlui.administrative.mapper.general.mapper_trail");
    private static final Message T_title = MapperMain.message((String)"xmlui.administrative.mapper.MapperMain.title");
    private static final Message T_head1 = MapperMain.message((String)"xmlui.administrative.mapper.MapperMain.head1");
    private static final Message T_para1 = MapperMain.message((String)"xmlui.administrative.mapper.MapperMain.para1");
    private static final Message T_para2 = MapperMain.message((String)"xmlui.administrative.mapper.MapperMain.para2");
    private static final Message T_stat_label = MapperMain.message((String)"xmlui.administrative.mapper.MapperMain.stat_label");
    private static final Message T_stat_info = MapperMain.message((String)"xmlui.administrative.mapper.MapperMain.stat_info");
    private static final Message T_search_label = MapperMain.message((String)"xmlui.administrative.mapper.MapperMain.search_label");
    private static final Message T_submit_search = MapperMain.message((String)"xmlui.administrative.mapper.MapperMain.submit_search");
    private static final Message T_submit_browse = MapperMain.message((String)"xmlui.administrative.mapper.MapperMain.submit_browse");
    private static final Message T_no_add = MapperMain.message((String)"xmlui.administrative.mapper.MapperMain.no_add");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_mapper_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, SQLException {
        int collectionID = this.parameters.getParameterAsInteger("collectionID", -1);
        Collection collection = Collection.find((Context)this.context, (int)collectionID);
        int[] counts = this.getNumberOfMappedAndUnmappedItems(collection);
        int count_native = counts[0];
        int count_import = counts[1];
        Division div = body.addInteractiveDivision("manage-mapper", this.contextPath + "/admin/mapper", "get", "primary administrative mapper");
        div.setHead(T_head1);
        div.addPara(T_para1.parameterize(new Object[]{collection.getMetadata("name")}));
        div.addPara(T_para2);
        List form = div.addList("mapper-form");
        form.addLabel(T_stat_label);
        form.addItem(T_stat_info.parameterize(new Object[]{count_import, count_native + count_import}));
        form.addLabel(T_search_label);
        org.dspace.app.xmlui.wing.element.Item queryItem = form.addItem();
        Text query = queryItem.addText("query");
        Button button = queryItem.addButton("submit_author");
        button.setValue(T_submit_search);
        if (!AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)collection, (int)3)) {
            query.setDisabled();
            button.setDisabled();
            queryItem.addHighlight("fade").addContent(T_no_add);
        }
        Para actions = div.addPara();
        actions.addButton("submit_browse").setValue(T_submit_browse);
        actions.addButton("submit_return").setValue(T_submit_return);
        div.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getNumberOfMappedAndUnmappedItems(Collection collection) throws SQLException {
        int count_native = 0;
        int count_import = 0;
        ItemIterator iterator = collection.getItems();
        try {
            while (iterator.hasNext()) {
                Item item = iterator.next();
                if (item.isOwningCollection(collection)) {
                    ++count_native;
                    continue;
                }
                ++count_import;
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        int[] counts = new int[]{count_native, count_import};
        return counts;
    }
}

