/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dspace.vocabulary.ControlledVocabulary;
import org.xml.sax.SAXException;

public class JSONControlledVocabularyReader
extends AbstractReader {
    private static final Logger log = Logger.getLogger(JSONControlledVocabularyReader.class);

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String vocabularyIdentifier = request.getParameter("vocabularyIdentifier");
        try {
            ControlledVocabulary controlledVocabulary = ControlledVocabulary.loadVocabulary((String)vocabularyIdentifier);
            if (controlledVocabulary != null) {
                Gson gson = new Gson();
                String jsonString = gson.toJson((Object)controlledVocabulary);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonString.getBytes("UTF-8"));
                IOUtils.copy((InputStream)inputStream, (OutputStream)this.out);
                this.out.flush();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while generating controlled vocabulary json, vocabulary identifier: " + vocabularyIdentifier), (Throwable)e);
        }
    }
}

