/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */
package org.dspace.app.xmlui.utils;

import org.dspace.app.xmlui.wing.WingException;

/**
 * A class representing an error generated by the Manakin.
 * 
 * I'm not sure if we are going to use this Exception class at this point.
 * 
 * @author Scott Phillips
 */
public class UIException extends WingException
{
    // Because exception is serializable.
    public static final long serialVersionUID = 1;

    public UIException(String message)
    {
        super(message);
    }

    public UIException(Throwable t)
    {
        super(t.getMessage(), t);
    }

    public UIException(String message, Throwable t)
    {
        super(message, t);
    }

}
