/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.Map;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.Namespace;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingInvalidArgument;
import org.dspace.app.xmlui.wing.element.WingElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractWingElement
implements WingElement {
    protected WingContext context;

    protected AbstractWingElement(WingContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Context may not be null.");
        }
        this.context = context;
    }

    protected AbstractWingElement() {
    }

    protected WingContext getWingContext() {
        return this.context;
    }

    protected void setWingContext(WingContext context) {
        this.context = context;
    }

    protected void require(String parameter, String message) throws WingInvalidArgument {
        if (parameter == null || parameter.equals("")) {
            throw new WingInvalidArgument(message);
        }
    }

    protected void require(Message parameter, String message) throws WingInvalidArgument {
        if (parameter == null) {
            throw new WingInvalidArgument(message);
        }
    }

    protected void restrict(String parameter, String[] options, String message) throws WingInvalidArgument {
        if (parameter == null) {
            return;
        }
        for (String test : options) {
            if (!parameter.equals(test)) continue;
            return;
        }
        throw new WingInvalidArgument(message);
    }

    protected void greater(int parameter, int greater, String message) throws WingInvalidArgument {
        if (parameter <= greater) {
            throw new WingInvalidArgument(message);
        }
    }

    protected void lesser(int parameter, int lesser, String message) throws WingInvalidArgument {
        if (parameter >= lesser) {
            throw new WingInvalidArgument(message);
        }
    }

    protected void requireFalse(boolean test, String message) throws WingInvalidArgument {
        if (test) {
            throw new WingInvalidArgument(message);
        }
    }

    protected void requireTrue(boolean test, String message) throws WingInvalidArgument {
        if (!test) {
            throw new WingInvalidArgument(message);
        }
    }

    protected void startElement(ContentHandler contentHandler, NamespaceSupport namespaces, String name, AttributeMap attributes) throws SAXException {
        this.startElement(contentHandler, namespaces, WingConstants.DRI, name, attributes);
    }

    protected void startElement(ContentHandler contentHandler, NamespaceSupport namespaces, Namespace namespace, String name, AttributeMap attributes) throws SAXException {
        String prefix = namespaces.getPrefix(namespace.URI);
        contentHandler.startElement(namespace.URI, name, this.qName(prefix, name), this.map2sax(namespace, namespaces, attributes));
    }

    protected void sendCharacters(ContentHandler contentHandler, String characters) throws SAXException {
        if (characters != null) {
            char[] contentArray = characters.toCharArray();
            contentHandler.characters(contentArray, 0, contentArray.length);
        }
    }

    protected void endElement(ContentHandler contentHandler, NamespaceSupport namespaces, String name) throws SAXException {
        this.endElement(contentHandler, namespaces, WingConstants.DRI, name);
    }

    protected void endElement(ContentHandler contentHandler, NamespaceSupport namespaces, Namespace namespace, String name) throws SAXException {
        String prefix = namespaces.getPrefix(namespace.URI);
        contentHandler.endElement(namespace.URI, name, this.qName(prefix, name));
    }

    private Attributes map2sax(Namespace elementNamespace, NamespaceSupport namespaces, AttributeMap attributeMap) {
        return this.map2sax(elementNamespace, namespaces, null, attributeMap);
    }

    private AttributesImpl map2sax(Namespace elementNamespace, NamespaceSupport namespaces, AttributesImpl attributes, AttributeMap attributeMap) {
        if (attributes == null) {
            attributes = new AttributesImpl();
        }
        if (attributeMap != null) {
            Namespace namespace = attributeMap.getNamespace();
            String uri = namespace != null ? namespace.URI : WingConstants.DRI.URI;
            String prefix = namespaces.getPrefix(uri);
            for (Map.Entry attr : attributeMap.entrySet()) {
                if (attr.getValue() == null) continue;
                if (elementNamespace.URI.equals(uri)) {
                    attributes.addAttribute("", (String)attr.getKey(), (String)attr.getKey(), "CDATA", (String)attr.getValue());
                    continue;
                }
                attributes.addAttribute(uri, (String)attr.getKey(), this.qName(prefix, (String)attr.getKey()), "CDATA", (String)attr.getValue());
            }
        }
        return attributes;
    }

    private String qName(String prefix, String localName) {
        if (prefix == null || prefix.equals("")) {
            return localName;
        }
        return prefix + ":" + localName;
    }

    public void dispose() {
        this.context = null;
    }
}

