/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.sitemap.PatternException;
import org.dspace.app.xmlui.configuration.Theme;
import org.dspace.app.xmlui.configuration.XMLUIConfiguration;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;

public class ThemeMatcher
extends AbstractLogEnabled
implements Matcher {
    public Map match(String src, Map objectModel, Parameters parameters) throws PatternException {
        try {
            String themePathOverride;
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            String uri = request.getSitemapURI();
            DSpaceObject dso = HandleUtil.obtainHandle((Map)objectModel);
            if (ConfigurationManager.getBooleanProperty((String)"xmlui.theme.allowoverrides", (boolean)false) && (themePathOverride = request.getParameter("themepath")) != null && themePathOverride.length() > 0) {
                if (!themePathOverride.matches("^[a-zA-Z0-9][a-zA-Z0-9/_\\-]*/?$")) {
                    throw new IllegalArgumentException("The user specified theme path, \"" + themePathOverride + "\", may be an exploit attempt. To use this feature please limit your theme paths to only letters (a-Z), numbers(0-9), dashes(-), underscores (_), and trailing forward slashes (/).");
                }
                String themeNameOverride = request.getParameter("themename");
                String themeIdOverride = request.getParameter("themeid");
                if (themeNameOverride == null || themeNameOverride.length() == 0) {
                    themeNameOverride = "User specified theme";
                }
                this.getLogger().debug("User as specified to override theme selection with theme (name=\"" + themeNameOverride + "\", path=\"" + themePathOverride + "\", id=\"" + themeIdOverride + "\")");
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("themeName", themeNameOverride);
                result.put("theme", themePathOverride);
                result.put("themeID", themeIdOverride);
                return result;
            }
            List rules = XMLUIConfiguration.getThemeRules();
            this.getLogger().debug("Checking if URL=" + uri + " matches any theme rules.");
            for (Theme rule : rules) {
                Pattern pattern;
                this.getLogger().debug("rule=" + rule.getName());
                if (!rule.hasRegex() && !rule.hasHandle()) continue;
                this.getLogger().debug("checking for patterns");
                if (rule.hasRegex() && !(pattern = rule.getPattern()).matcher(uri).find()) continue;
                this.getLogger().debug("checking for handles");
                if (rule.hasHandle() && !HandleUtil.inheritsFrom((DSpaceObject)dso, (String)rule.getHandle())) continue;
                this.getLogger().debug("rule selected!!");
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("themeName", rule.getName());
                result.put("theme", rule.getPath());
                result.put("themeID", rule.getId());
                request.getSession().setAttribute("themeName", (Object)rule.getName());
                request.getSession().setAttribute("theme", (Object)rule.getPath());
                request.getSession().setAttribute("themeID", (Object)rule.getId());
                return result;
            }
        }
        catch (SQLException sqle) {
            throw new PatternException((Exception)sqle);
        }
        return null;
    }
}

