/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.aspect.administrative.CurrentActivityAction;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class CurrentActivityAction
extends AbstractAction {
    public static final int MAX_EVENTS;
    public static final String IP_HEADER;
    private static Queue<Event> events;
    private static boolean recordAnonymousEvents;
    private static boolean recordBotEvents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Context context = ContextUtil.obtainContext((Map)objectModel);
        Queue queue = events;
        synchronized (queue) {
            Event event = new Event(context, request);
            boolean record = true;
            if (!recordAnonymousEvents && event.isAnonymous()) {
                record = false;
            }
            if (!recordBotEvents && event.isBot()) {
                record = false;
            }
            if (record) {
                events.add(event);
            }
            while (events.size() > MAX_EVENTS) {
                events.poll();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Event> getEvents() {
        ArrayList<Event> list = new ArrayList<Event>();
        Queue queue = events;
        synchronized (queue) {
            list.addAll(events);
        }
        return list;
    }

    public static boolean getRecordAnonymousEvents() {
        return recordAnonymousEvents;
    }

    public static void setRecordAnonymousEvents(boolean record) {
        recordAnonymousEvents = record;
    }

    public static boolean getRecordBotEvents() {
        return recordBotEvents;
    }

    public static void setRecordBotEvents(boolean record) {
        recordBotEvents = record;
    }

    static {
        events = new LinkedList();
        recordAnonymousEvents = true;
        recordBotEvents = false;
        MAX_EVENTS = ConfigurationManager.getProperty((String)"xmlui.controlpanel.activity.max") != null ? ConfigurationManager.getIntProperty((String)"xmlui.controlpanel.activity.max") : 250;
        IP_HEADER = ConfigurationManager.getProperty((String)"xmlui.controlpanel.activity.ipheader") != null ? ConfigurationManager.getProperty((String)"xmlui.controlpanel.activity.ipheader") : "X-Forwarded-For";
    }
}

