/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.app.util.CollectionDropDown;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.xml.sax.SAXException;

public class SelectCollectionStep
extends AbstractSubmissionStep {
    protected static final Message T_head = SelectCollectionStep.message((String)"xmlui.Submission.submit.SelectCollection.head");
    protected static final Message T_collection = SelectCollectionStep.message((String)"xmlui.Submission.submit.SelectCollection.collection");
    protected static final Message T_collection_help = SelectCollectionStep.message((String)"xmlui.Submission.submit.SelectCollection.collection_help");
    protected static final Message T_collection_default = SelectCollectionStep.message((String)"xmlui.Submission.submit.SelectCollection.collection_default");
    protected static final Message T_submit_next = SelectCollectionStep.message((String)"xmlui.general.next");

    public SelectCollectionStep() {
        this.requireHandle = true;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException {
        pageMeta.addMetadata("title").addContent(T_submission_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_submission_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        CollectionDropDown.CollectionPathEntry[] collectionPaths;
        String actionURL = this.contextPath + "/submit/" + this.knot.getId() + ".continue";
        DSpaceObject dso = HandleManager.resolveToObject((Context)this.context, (String)this.handle);
        Collection[] collections = dso instanceof Community ? Collection.findAuthorized((Context)this.context, (Community)((Community)dso), (int)3) : Collection.findAuthorizedOptimized((Context)this.context, (int)3);
        Division div = body.addInteractiveDivision("select-collection", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        List list = div.addList("select-collection", "form");
        list.setHead(T_head);
        Select select = list.addItem().addSelect("handle");
        select.setAutofocus("autofocus");
        select.setLabel(T_collection);
        select.setHelp(T_collection_help);
        select.addOption("", T_collection_default);
        for (CollectionDropDown.CollectionPathEntry entry : collectionPaths = CollectionDropDown.annotateWithPaths((Collection[])collections)) {
            select.addOption(entry.collection.getHandle(), entry.path);
        }
        Button submit = list.addItem().addButton("submit");
        submit.setValue(T_submit_next);
    }

    public List addReviewSection(List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        return null;
    }

    public void recycle() {
        this.handle = null;
        super.recycle();
    }
}

