/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.community;

import java.sql.SQLException;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.eperson.Group;

public class AssignCommunityRoles
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = AssignCommunityRoles.message((String)"xmlui.general.dspace_home");
    private static final Message T_community_trail = AssignCommunityRoles.message((String)"xmlui.administrative.community.general.community_trail");
    private static final Message T_options_metadata = AssignCommunityRoles.message((String)"xmlui.administrative.community.general.options_metadata");
    private static final Message T_options_roles = AssignCommunityRoles.message((String)"xmlui.administrative.community.general.options_roles");
    private static final Message T_options_curate = AssignCommunityRoles.message((String)"xmlui.administrative.community.general.options_curate");
    private static final Message T_submit_return = AssignCommunityRoles.message((String)"xmlui.general.return");
    private static final Message T_title = AssignCommunityRoles.message((String)"xmlui.administrative.community.AssignCommunityRoles.title");
    private static final Message T_trail = AssignCommunityRoles.message((String)"xmlui.administrative.community.AssignCommunityRoles.trail");
    private static final Message T_main_head = AssignCommunityRoles.message((String)"xmlui.administrative.community.AssignCommunityRoles.main_head");
    private static final Message T_no_role = AssignCommunityRoles.message((String)"xmlui.administrative.community.AssignCommunityRoles.no_role");
    private static final Message T_create = AssignCommunityRoles.message((String)"xmlui.administrative.community.AssignCommunityRoles.create");
    private static final Message T_delete = AssignCommunityRoles.message((String)"xmlui.general.delete");
    private static final Message T_help_admins = AssignCommunityRoles.message((String)"xmlui.administrative.community.AssignCommunityRoles.help_admins");
    private static final Message T_edit_authorizations = AssignCommunityRoles.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.edit_authorizations");
    private static final Message T_role_name = AssignCommunityRoles.message((String)"xmlui.administrative.community.AssignCommunityRoles.role_name");
    private static final Message T_role_group = AssignCommunityRoles.message((String)"xmlui.administrative.community.AssignCommunityRoles.role_group");
    private static final Message T_role_buttons = AssignCommunityRoles.message((String)"xmlui.administrative.community.AssignCommunityRoles.role_buttons");
    private static final Message T_label_admins = AssignCommunityRoles.message((String)"xmlui.administrative.community.AssignCommunityRoles.label_admins");
    private static final Message T_sysadmins_only = AssignCommunityRoles.message((String)"xmlui.administrative.community.AssignCommunityRoles.sysadmins_only");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_community_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        int communityID = this.parameters.getParameterAsInteger("communityID", -1);
        Community thisCommunity = Community.find((Context)this.context, (int)communityID);
        String baseURL = this.contextPath + "/admin/community?administrative-continue=" + this.knot.getId();
        Group admins = thisCommunity.getAdministrators();
        Division main = body.addInteractiveDivision("community-assign-roles", this.contextPath + "/admin/community", "post", "primary administrative community");
        main.setHead(T_main_head.parameterize(new Object[]{thisCommunity.getName()}));
        List options = main.addList("options", "simple", "horizontal");
        options.addItem().addXref(baseURL + "&submit_metadata", T_options_metadata);
        options.addItem().addHighlight("bold").addXref(baseURL + "&submit_roles", T_options_roles);
        options.addItem().addXref(baseURL + "&submit_curate", T_options_curate);
        Table rolesTable = main.addTable("roles-table", 6, 5);
        Row tableHeader = rolesTable.addRow("header");
        tableHeader.addCell().addContent(T_role_name);
        tableHeader.addCell().addContent(T_role_group);
        tableHeader.addCell().addContent(T_role_buttons);
        rolesTable.addRow();
        Row tableRow = rolesTable.addRow("data");
        tableRow.addCell("header").addContent(T_label_admins);
        if (admins != null) {
            try {
                AuthorizeUtil.authorizeManageAdminGroup((Context)this.context, (Community)thisCommunity);
                tableRow.addCell().addXref(baseURL + "&submit_edit_admin", admins.getName());
            }
            catch (AuthorizeException authex) {
                tableRow.addCell().addContent(T_sysadmins_only);
            }
            try {
                AuthorizeUtil.authorizeRemoveAdminGroup((Context)this.context, (Community)thisCommunity);
                tableRow.addCell().addButton("submit_delete_admin").setValue(T_delete);
            }
            catch (AuthorizeException authex) {}
        } else {
            tableRow.addCell().addContent(T_no_role);
            Cell commAdminCell = tableRow.addCell();
            try {
                AuthorizeUtil.authorizeManageAdminGroup((Context)this.context, (Community)thisCommunity);
                commAdminCell.addButton("submit_create_admin").setValue(T_create);
            }
            catch (AuthorizeException authex) {
                this.addAdministratorOnlyButton(commAdminCell, "submit_create_admin", T_create);
            }
        }
        tableRow = rolesTable.addRow("data");
        tableRow.addCell();
        tableRow.addCell(1, 2).addHighlight("fade offset").addContent(T_help_admins);
        try {
            AuthorizeUtil.authorizeManageCommunityPolicy((Context)this.context, (Community)thisCommunity);
            Cell authCell = rolesTable.addRow().addCell(1, 3);
            authCell.addXref(baseURL + "&submit_authorizations", T_edit_authorizations);
        }
        catch (AuthorizeException authex) {
            // empty catch block
        }
        Para buttonList = main.addPara();
        buttonList.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private void addAdministratorOnlyButton(Cell cell, String buttonName, Message buttonLabel) throws WingException, SQLException {
        Button button = cell.addButton(buttonName);
        button.setValue(buttonLabel);
        if (!AuthorizeManager.isAdmin((Context)this.context)) {
            button.setDisabled();
            cell.addHighlight("fade").addContent(T_sysadmins_only);
        }
    }
}

