/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Reference;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.ItemCountException;
import org.dspace.browse.ItemCounter;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

public class CommunityViewer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_dspace_home = CommunityViewer.message((String)"xmlui.general.dspace_home");
    public static final Message T_untitled = CommunityViewer.message((String)"xmlui.general.untitled");
    private static final Message T_head_sub_communities = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.head_sub_communities");
    private static final Message T_head_sub_collections = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.head_sub_collections");
    private SourceValidity validity;

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            Community community = null;
            try {
                boolean showCount;
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (dso == null) {
                    return null;
                }
                if (!(dso instanceof Community)) {
                    return null;
                }
                community = (Community)dso;
                DSpaceValidity validity = new DSpaceValidity();
                validity.add((DSpaceObject)community);
                Community[] subCommunities = community.getSubcommunities();
                Collection[] collections = community.getCollections();
                for (Community community2 : subCommunities) {
                    validity.add((DSpaceObject)community2);
                    showCount = ConfigurationManager.getBooleanProperty((String)"webui.strengths.show");
                    if (!showCount) continue;
                    try {
                        int size = new ItemCounter(this.context).getCount((DSpaceObject)community2);
                        validity.add("size:" + size);
                    }
                    catch (ItemCountException e) {
                        // empty catch block
                    }
                }
                for (Community community3 : collections) {
                    validity.add((DSpaceObject)community3);
                    showCount = ConfigurationManager.getBooleanProperty((String)"webui.strengths.show");
                    if (!showCount) continue;
                    try {
                        int size = new ItemCounter(this.context).getCount((DSpaceObject)community3);
                        validity.add("size:" + size);
                    }
                    catch (ItemCountException e) {
                        // empty catch block
                    }
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Community)) {
            return;
        }
        Community community = (Community)dso;
        String name = community.getMetadata("name");
        if (name == null || name.length() == 0) {
            pageMeta.addMetadata("title").addContent(T_untitled);
        } else {
            pageMeta.addMetadata("title").addContent(name);
        }
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        HandleUtil.buildHandleTrail((DSpaceObject)community, (PageMeta)pageMeta, (String)this.contextPath);
        String formats = ConfigurationManager.getProperty((String)"webui.feed.formats");
        if (formats != null) {
            for (String format : formats.split(",")) {
                String[] parts = format.split("_");
                if (parts.length < 1) continue;
                String feedFormat = parts[0].trim() + "+xml";
                String feedURL = this.contextPath + "/feed/" + format.trim() + "/" + community.getHandle();
                pageMeta.addMetadata("feed", feedFormat).addContent(feedURL);
            }
        }
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        ReferenceSet communityReferenceSet;
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Community)) {
            return;
        }
        Community community = (Community)dso;
        Community[] subCommunities = community.getSubcommunities();
        Collection[] collections = community.getCollections();
        Division home = body.addDivision("community-home", "primary repository community");
        String name = community.getMetadata("name");
        if (name == null || name.length() == 0) {
            home.setHead(T_untitled);
        } else {
            home.setHead(name);
        }
        home.addDivision("community-search-browse", "secondary search-browse");
        Division viewer = home.addDivision("community-view", "secondary");
        ReferenceSet referenceSet = viewer.addReferenceSet("community-view", "detailView");
        Reference communityInclude = referenceSet.addReference((Object)community);
        if (subCommunities != null && subCommunities.length > 0) {
            communityReferenceSet = communityInclude.addReferenceSet("summaryList", null, "hierarchy");
            communityReferenceSet.setHead(T_head_sub_communities);
            for (Community community2 : subCommunities) {
                communityReferenceSet.addReference((Object)community2);
            }
        }
        if (collections != null && collections.length > 0) {
            communityReferenceSet = communityInclude.addReferenceSet("summaryList", null, "hierarchy");
            communityReferenceSet.setHead(T_head_sub_collections);
            for (Community community3 : collections) {
                communityReferenceSet.addReference((Object)community3);
            }
        }
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

