/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.statisticsElasticSearch;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.statistics.StatisticsTransformer;
import org.dspace.app.xmlui.aspect.statisticsElasticSearch.ElasticSearchStatsViewer;
import org.dspace.app.xmlui.aspect.statisticsElasticSearch.ReportGenerator;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.Context;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.xml.sax.SAXException;

public class CSVOutputter
extends AbstractReader
implements Recyclable {
    protected static final Logger log = Logger.getLogger(CSVOutputter.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected Response response;
    protected Request request;
    protected Context context;
    protected CSVWriter writer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(SourceResolver sourceResolver, Map objectModel, String src, Parameters parameters) throws IOException, SAXException, ProcessingException {
        log.info((Object)"CSV Writer for stats");
        super.setup(sourceResolver, objectModel, src, parameters);
        try {
            this.request = ObjectModelHelper.getRequest((Map)objectModel);
            this.response = ObjectModelHelper.getResponse((Map)objectModel);
            this.context = ContextUtil.obtainContext((Map)objectModel);
            String requestURI = this.request.getRequestURI();
            String[] uriSegments = requestURI.split("/");
            String requestedReport = uriSegments[uriSegments.length - 1];
            if (requestedReport == null || requestedReport.length() < 1) {
                this.response.setStatus(400);
                return;
            }
            this.response.setContentType("text/csv; encoding='UTF-8'");
            this.response.setStatus(200);
            this.writer = new CSVWriter((Writer)this.response.getWriter());
            DSpaceObject dso = HandleUtil.obtainHandle((Map)objectModel);
            this.response.setHeader("Content-Disposition", "attachment; filename=KBStats-" + dso.getHandle() + "-" + requestedReport + ".csv");
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration paramNames = this.request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String param = (String)paramNames.nextElement();
                params.put(param, this.request.getParameter(param));
            }
            String fromValue = "";
            if (params.containsKey("from")) {
                fromValue = (String)params.get("from");
            }
            String toValue = "";
            if (params.containsKey("to")) {
                toValue = (String)params.get("to");
            }
            ReportGenerator reportGeneratorInstance = new ReportGenerator();
            Date fromDate = fromValue.length() > 0 ? reportGeneratorInstance.tryParse(fromValue) : null;
            Date toDate = toValue.length() > 0 ? reportGeneratorInstance.tryParse(toValue) : null;
            ElasticSearchStatsViewer esStatsViewer = new ElasticSearchStatsViewer(dso, fromDate, toDate);
            StatisticsTransformer statisticsTransformerInstance = new StatisticsTransformer(fromDate, toDate);
            if (requestedReport.equalsIgnoreCase("topCountries")) {
                SearchRequestBuilder requestBuilder = esStatsViewer.facetedQueryBuilder(ElasticSearchStatsViewer.facetTopCountries);
                SearchResponse searchResponse = (SearchResponse)requestBuilder.execute().actionGet();
                TermsFacet topCountriesFacet = (TermsFacet)searchResponse.getFacets().facet(TermsFacet.class, "top_countries");
                this.addTermFacetToWriter(topCountriesFacet, "");
            } else if (requestedReport.equalsIgnoreCase("fileDownloads")) {
                SearchRequestBuilder requestBuilder = esStatsViewer.facetedQueryBuilder(ElasticSearchStatsViewer.facetMonthlyDownloads);
                SearchResponse searchResponse = (SearchResponse)requestBuilder.execute().actionGet();
                DateHistogramFacet monthlyDownloadsFacet = (DateHistogramFacet)searchResponse.getFacets().facet(DateHistogramFacet.class, "monthly_downloads");
                this.addDateHistogramFacetToWriter(monthlyDownloadsFacet);
            } else if (requestedReport.equalsIgnoreCase("topDownloads")) {
                SearchRequestBuilder requestBuilder = esStatsViewer.facetedQueryBuilder(ElasticSearchStatsViewer.facetTopBitstreamsAllTime);
                SearchResponse searchResponse = (SearchResponse)requestBuilder.execute().actionGet();
                log.info((Object)searchResponse.toString());
                TermsFacet topBitstreams = (TermsFacet)searchResponse.getFacets().facet(TermsFacet.class, "top_bitstreams_alltime");
                this.addTermFacetToWriter(topBitstreams, "bitstream");
            } else {
                this.response.setStatus(400);
            }
        }
        catch (SQLException e) {
            log.error((Object)("Some Error:" + e.getMessage()));
        }
        catch (WingException e) {
            log.error((Object)("Some Error:" + e.getMessage()));
        }
        catch (IOException e) {
            log.error((Object)("Some Error:" + e.getMessage()));
        }
        finally {
            try {
                if (this.writer != null) {
                    this.writer.close();
                } else {
                    log.error((Object)"CSV Writer was null!!");
                }
            }
            catch (IOException e) {
                log.error((Object)"Hilarity Ensues... IO Exception while closing the csv writer.");
            }
        }
    }

    private void addTermFacetToWriter(TermsFacet termsFacet, String termType) throws SQLException {
        List termsFacetEntries = termsFacet.getEntries();
        if (termType.equalsIgnoreCase("bitstream")) {
            this.writer.writeNext(new String[]{"BitstreamID", "Bitstream Name", "Bitstream Bundle", "Item Title", "Item Handle", "Item Creator", "Item Publisher", "Item Issue Date", "Count"});
        } else {
            this.writer.writeNext(new String[]{"term", "count"});
        }
        if (termsFacetEntries.size() == 0) {
            return;
        }
        for (TermsFacet.Entry facetEntry : termsFacetEntries) {
            if (termType.equalsIgnoreCase("bitstream")) {
                Bitstream bitstream = Bitstream.find((Context)this.context, (int)Integer.parseInt(facetEntry.getTerm().string()));
                Item item = (Item)bitstream.getParentObject();
                String[] entryValues = new String[]{bitstream.getID() + "", bitstream.getName(), bitstream.getBundles()[0].getName(), item.getName(), "http://hdl.handle.net/" + item.getHandle(), this.wrapInDelimitedString(item.getMetadataByMetadataString("dc.creator")), this.wrapInDelimitedString(item.getMetadataByMetadataString("dc.publisher")), this.wrapInDelimitedString(item.getMetadataByMetadataString("dc.date.issued")), facetEntry.getCount() + ""};
                this.writer.writeNext(entryValues);
                continue;
            }
            this.writer.writeNext(new String[]{facetEntry.getTerm().string(), String.valueOf(facetEntry.getCount())});
        }
    }

    public String wrapInDelimitedString(Metadatum[] metadataEntries) {
        StringBuilder metadataString = new StringBuilder();
        for (Metadatum metadataEntry : metadataEntries) {
            if (metadataString.length() > 0) {
                metadataString.append("\\|\\|");
            }
            metadataString.append(metadataEntry.value);
        }
        return metadataString.toString();
    }

    private void addDateHistogramFacetToWriter(DateHistogramFacet dateHistogramFacet) {
        List monthlyFacetEntries = dateHistogramFacet.getEntries();
        if (monthlyFacetEntries.size() == 0) {
            return;
        }
        this.writer.writeNext(new String[]{"Month", "Count"});
        for (DateHistogramFacet.Entry histogramEntry : monthlyFacetEntries) {
            Date facetDate = new Date(histogramEntry.getTime());
            this.writer.writeNext(new String[]{dateFormat.format(facetDate), String.valueOf(histogramEntry.getCount())});
        }
    }

    public void generate() throws IOException {
        log.info((Object)"CSV Writer generator for stats");
        this.out.flush();
        this.out.close();
    }

    public void recycle() {
        this.request = null;
        this.response = null;
    }
}

