/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmltest;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.xml.sax.SAXException;

public class StructureTest
extends AbstractDSpaceTransformer {
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent("Structural Test");
        pageMeta.addTrailLink(this.contextPath + "/", "DSpace Home");
        pageMeta.addTrail().addContent("Structural Test");
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Division test = body.addDivision("test");
        test.setHead("Structural Tests");
        test.addPara("This is a series of tests that show various options and uses of DRI's structural elements: divisions, paragraphs, lists, and tables.");
        Division paraT = test.addDivision("para");
        paraT.setHead("1) Paragraph Tests");
        paraT.addPara("This is a simple paragraph");
        Para para = paraT.addPara();
        para.addContent("This is ");
        para.addHighlight("bold").addContent("not");
        para.addContent(" a ");
        para.addHighlight("bold").addHighlight("italic").addContent("simple");
        para.addContent(" paragraph.");
        Division listT = test.addDivision("list");
        listT.setHead("2) List Tests");
        List list = listT.addList("simple");
        list.setHead("Simple list");
        list.addItem("one");
        list.addItem("two");
        list.addItem("three");
        list = listT.addList("labeled");
        list.setHead("Simple list ( with labels )");
        list.addLabel("uno");
        list.addItem("one");
        list.addLabel("dos");
        list.addItem("two");
        list.addLabel("threes");
        list.addItem("three");
        list = listT.addList("bulleted", "bulleted");
        list.setHead("Bulleted list");
        list.addItem("one");
        list.addItem("two");
        list.addItem("three");
        list = listT.addList("ordered", "ordered");
        list.setHead("Ordered list");
        list.addItem("one");
        list.addItem("two");
        list.addItem("three");
        list = listT.addList("glossary", "gloss");
        list.setHead("Glossary list");
        list.addLabel("uno");
        list.addItem("one");
        list.addLabel("dos");
        list.addItem("two");
        list.addLabel("tres");
        list.addItem("three");
        list = listT.addList("simple-nest");
        list.setHead("Simple list ( nested )");
        list.addItem("one");
        list.addItem("two");
        List nest = list.addList("nest1");
        nest.setHead("Sub list point three");
        nest.addItem("three point one");
        nest.addItem("three point two");
        nest.addItem("three point three");
        list.addItem("four");
        list = listT.addList("labeled-nest");
        list.setHead("Simple list ( with labels and nested )");
        list.addLabel("uno");
        list.addItem("one");
        list.addLabel("dos");
        list.addItem("two");
        nest = list.addList("nest2");
        nest.addLabel("dos punto uno");
        nest.addItem("two point one");
        nest.addLabel("dos punto dos");
        nest.addItem("two point two");
        nest.addLabel("dos punto tres");
        nest.addItem("two point three");
        list.addLabel("threes");
        list.addItem("three");
        list = listT.addList("bulleted-nest", "bulleted");
        list.setHead("Bulleted list ( nested )");
        list.addItem("one");
        list.addItem("two");
        nest = list.addList("nest3");
        nest.addItem("three point one");
        nest.addItem("three point two");
        nest.addItem("three point three");
        list.addItem("four");
        list = listT.addList("ordered-nest", "ordered");
        list.setHead("Ordered list ( nested )");
        list.addItem("one");
        list.addItem("two");
        nest = list.addList("nest4");
        nest.setHead("Sub list point three");
        nest.addItem("three point one");
        nest.addItem("three point two");
        nest.addItem("three point three");
        list.addItem("four");
        list = listT.addList("glossary-nest", "gloss");
        list.setHead("Glossary list ( nested )");
        list.addLabel("uno");
        list.addItem("one");
        list.addLabel("dos");
        list.addItem("two");
        nest = list.addList("nest5");
        nest.addLabel("dos punto uno");
        nest.addItem("two point one");
        nest.addLabel("dos punto dos");
        nest.addItem("two point two");
        nest.addLabel("dos punto tres");
        nest.addItem("two point three");
        list.addLabel("tres");
        list.addItem("three");
        Division tableT = test.addDivision("table");
        tableT.setHead("3) Table Tests");
        Table table = tableT.addTable("table1", 3, 3);
        table.setHead("Table: simple");
        Row row = table.addRow();
        row.addCellContent("1.1");
        row.addCellContent("1.2");
        row.addCellContent("1.3");
        row = table.addRow();
        row.addCellContent("2.1");
        row.addCellContent("2.2");
        row.addCellContent("2.3");
        row = table.addRow();
        row.addCellContent("3.1");
        row.addCellContent("3.2");
        row.addCellContent("3.3");
        table = tableT.addTable("table1", 4, 3);
        table.setHead("Table: header vs data roles");
        row = table.addRow("header");
        row.addCellContent("This whole");
        row.addCellContent("row is a");
        row.addCellContent("Header");
        row = table.addRow();
        row.addCellContent("2.1");
        row.addCellContent("2.2");
        row.addCellContent("2.3");
        row = table.addRow();
        row.addCellContent("3.1");
        row.addCell("header").addContent("3.2 - single cell header");
        row.addCellContent("3.3");
        row = table.addRow();
        row.addCellContent("4.1");
        row.addCellContent("4.2");
        row.addCellContent("4.3");
        table = tableT.addTable("table1", 6, 3);
        table.setHead("Table: column & row spans");
        row = table.addRow();
        row.addCellContent("1.1");
        row.addCellContent("1.2");
        row.addCellContent("1.3");
        row = table.addRow();
        row.addCell(null, null, 0, 3, null).addContent("2.1 - spans three columns");
        row = table.addRow();
        row.addCellContent("3.1");
        row.addCell(null, null, 3, 0, null).addContent("3.2 - spans three rows");
        row.addCellContent("3.3");
        row = table.addRow();
        row.addCellContent("4.1");
        row.addCellContent("4.3");
        row = table.addRow();
        row.addCellContent("5.1");
        row.addCellContent("5.3");
        row = table.addRow();
        row.addCellContent("6.1");
        row.addCellContent("6.2");
        row.addCellContent("6.3");
    }
}

