/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.RequestUtils;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.utils.DSpace;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class BrowseFacet
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(BrowseFacet.class);
    private static final Message T_dspace_home = BrowseFacet.message((String)"xmlui.general.dspace_home");
    protected DiscoverResult queryResults;
    protected SourceValidity validity;
    protected DiscoverQuery queryArgs;
    private int DEFAULT_PAGE_SIZE = 10;
    public static final String OFFSET = "offset";
    public static final String FACET_FIELD = "field";
    private SearchService searchService = null;

    public BrowseFacet() {
        DSpace dspace = new DSpace();
        this.searchService = (SearchService)dspace.getServiceManager().getServiceByName(SearchService.class.getName(), SearchService.class);
    }

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceValidity validity = new DSpaceValidity();
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (dso != null) {
                    validity.add(dso);
                }
                DiscoverResult response = this.getQueryResponse(dso);
                validity.add("numFound:" + response.getDspaceObjects().size());
                for (DSpaceObject resultDso : response.getDspaceObjects()) {
                    validity.add(resultDso);
                }
                for (String facetField : response.getFacetResults().keySet()) {
                    validity.add(facetField);
                    List facetValues = (List)response.getFacetResults().get(facetField);
                    for (DiscoverResult.FacetResult facetValue : facetValues) {
                        validity.add(facetValue.getAsFilterQuery() + facetValue.getCount());
                    }
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    protected DiscoverResult getQueryResponse(DSpaceObject scope) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (this.queryResults != null) {
            return this.queryResults;
        }
        this.queryArgs = new DiscoverQuery();
        this.queryArgs.setQuery("search.resourcetype: 2" + (request.getParameter("query") != null && !"".equals(request.getParameter("query")) ? " AND (" + request.getParameter("query") + ")" : ""));
        this.queryArgs.setMaxResults(0);
        this.queryArgs.setSortField(ConfigurationManager.getProperty((String)"recent.submissions.sort-option"), DiscoverQuery.SORT_ORDER.asc);
        this.queryArgs.addFilterQueries(this.getParameterFacetQueries());
        this.queryArgs.setFacetMinCount(1);
        int offset = RequestUtils.getIntParameter((Request)request, (String)"offset");
        if (offset == -1) {
            offset = 0;
        }
        this.queryArgs.setFacetOffset(offset);
        try {
            this.queryResults = this.searchService.search(this.context, scope, this.queryArgs);
        }
        catch (SearchServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.queryResults;
    }

    private Date getLowestDateValue(Context context, String query, String dateField, String ... filterquery) {
        try {
            DiscoverQuery discoverQuery = new DiscoverQuery();
            discoverQuery.setQuery(query);
            discoverQuery.setMaxResults(1);
            discoverQuery.setSortField(dateField, DiscoverQuery.SORT_ORDER.asc);
            discoverQuery.addFilterQueries(filterquery);
            DiscoverResult discoverResult = this.searchService.search(context, discoverQuery);
        }
        catch (Exception e) {
            log.error((Object)"Unable to get lowest date", (Throwable)e);
        }
        return null;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String facetField = request.getParameter("field");
        pageMeta.addMetadata("title").addContent(BrowseFacet.message((String)("xmlui.ArtifactBrowser.AbstractSearch.type_" + facetField + "_browse")));
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso instanceof Collection || dso instanceof Community) {
            HandleUtil.buildHandleTrail((DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath);
        }
        pageMeta.addTrail().addContent(BrowseFacet.message((String)("xmlui.ArtifactBrowser.AbstractSearch.type_" + facetField + "_browse")));
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        this.queryResults = this.getQueryResponse(dso);
        if (this.queryResults != null) {
            String facetField;
            List values;
            LinkedHashMap facetFields = this.queryResults.getFacetResults();
            if (facetFields == null) {
                facetFields = new LinkedHashMap();
            }
            if (facetFields.size() > 0 && (values = (List)facetFields.get(facetField = String.valueOf(facetFields.keySet().toArray(new String[facetFields.size()])[0]))) != null && 0 < values.size()) {
                Division results = body.addDivision("browse-by-" + facetField + "-results", "primary");
                results.setHead(BrowseFacet.message((String)("xmlui.ArtifactBrowser.AbstractSearch.type_" + request.getParameter("field") + "_browse")));
                int offSet = this.queryArgs.getFacetOffset();
                if (offSet == -1) {
                    offSet = 0;
                }
                String nextPageUrl = null;
                if (values.size() == this.DEFAULT_PAGE_SIZE + 1) {
                    nextPageUrl = this.getNextPageURL(request);
                }
                results.setSimplePagination(this.queryResults.getDspaceObjects().size(), offSet + 1, offSet + (values.size() - 1), this.getPreviousPageURL(request), nextPageUrl);
                Table singleTable = results.addTable("browse-by-" + facetField + "-results", this.queryResults.getDspaceObjects().size() + 1, 1);
                List<Object> filterQueries = new ArrayList();
                if (request.getParameterValues("fq") != null) {
                    filterQueries = Arrays.asList(request.getParameterValues("fq"));
                }
                for (int i = 0; i < values.size(); ++i) {
                    DiscoverResult.FacetResult value = (DiscoverResult.FacetResult)values.get(i);
                    String displayedValue = value.getDisplayedValue();
                    String filterQuery = value.getAsFilterQuery();
                    Cell cell = singleTable.addRow().addCell();
                    if (filterQueries.contains(filterQuery)) {
                        cell.addContent(displayedValue + " (" + value.getCount() + ")");
                        continue;
                    }
                    cell.addXref(this.contextPath + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/discover?" + "&fq=" + URLEncoder.encode(filterQuery, "UTF-8") + (request.getQueryString() != null ? "&" + request.getQueryString() : ""), displayedValue + " (" + value.getCount() + ")");
                }
            }
        }
    }

    private String getNextPageURL(Request request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("field", request.getParameter("field"));
        if (this.queryArgs.getFacetOffset() != -1) {
            parameters.put("offset", String.valueOf(this.queryArgs.getFacetOffset() + this.DEFAULT_PAGE_SIZE));
        }
        String url = BrowseFacet.generateURL((String)"browse-discovery", parameters);
        String[] fqs = this.getParameterFacetQueries();
        if (fqs != null) {
            StringBuilder urlBuilder = new StringBuilder(url);
            for (String fq : fqs) {
                urlBuilder.append("&fq=").append(fq);
            }
            url = urlBuilder.toString();
        }
        return url;
    }

    private String getPreviousPageURL(Request request) {
        if (0 == this.queryArgs.getFacetOffset()) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("field", request.getParameter("field"));
        if (this.queryArgs.getFacetOffset() != -1) {
            parameters.put("offset", String.valueOf(this.queryArgs.getFacetOffset() - this.DEFAULT_PAGE_SIZE));
        }
        String url = BrowseFacet.generateURL((String)"browse-discovery", parameters);
        String[] fqs = this.getParameterFacetQueries();
        if (fqs != null) {
            StringBuilder urlBuilder = new StringBuilder(url);
            for (String fq : fqs) {
                urlBuilder.append("&fq=").append(fq);
            }
            url = urlBuilder.toString();
        }
        return url;
    }

    public void recycle() {
        this.queryResults = null;
        this.validity = null;
        this.queryResults = null;
        super.recycle();
    }

    public String[] getParameterFacetQueries() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        return request.getParameterValues("fq") != null ? request.getParameterValues("fq") : new String[]{};
    }
}

