/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.Error;
import org.dspace.app.xmlui.wing.element.Help;
import org.dspace.app.xmlui.wing.element.Instance;
import org.dspace.app.xmlui.wing.element.Label;
import org.dspace.app.xmlui.wing.element.Option;
import org.dspace.app.xmlui.wing.element.Params;
import org.dspace.app.xmlui.wing.element.StructuralElement;
import org.dspace.app.xmlui.wing.element.Value;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class Field
extends AbstractWingElement
implements StructuralElement {
    public static final String E_FIELD = "field";
    public static final String A_FIELD_TYPE = "type";
    public static final String A_DISABLED = "disabled";
    public static final String A_REQUIRED = "required";
    public static final String TYPE_BUTTON = "button";
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_HIDDEN = "hidden";
    public static final String TYPE_PASSWORD = "password";
    public static final String TYPE_RADIO = "radio";
    public static final String TYPE_SELECT = "select";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_TEXTAREA = "textarea";
    public static final String TYPE_COMPOSITE = "composite";
    public static final String[] TYPES = new String[]{"button", "checkbox", "file", "hidden", "password", "radio", "select", "text", "textarea", "composite"};
    public static final String OPERATION_ADD = "add";
    public static final String OPERATION_DELETE = "delete";
    public static final String[] OPERATIONS = new String[]{"add", "delete"};
    protected String name;
    protected String type;
    protected boolean disabled;
    protected boolean required;
    protected String rend;
    protected Params params;
    protected Label label;
    protected Help help;
    protected List<Error> errors = new ArrayList();
    protected List<Field> fields = new ArrayList();
    protected List<Option> options = new ArrayList();
    protected List<Value> values = new ArrayList();
    protected List<Instance> instances = new ArrayList();

    protected Field(WingContext context, String name, String type, String rend) throws WingException {
        super(context);
        this.require(name, "The 'name' parameter is required for all fields.");
        this.require(type, "The 'type' parameter is required for all fields.");
        this.restrict(type, TYPES, "The 'type' parameter must be one of these values: 'button', 'checkbox', 'file', 'hidden', 'password', 'radio', 'select', 'text', 'textarea'.");
        this.name = name;
        this.type = type;
        this.disabled = false;
        this.required = false;
        this.rend = rend;
    }

    public void setRequired() {
        this.required = true;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setDisabled() {
        this.disabled = true;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setAuthorityControlled() {
        this.params.setAuthorityControlled(true);
    }

    public void setAuthorityControlled(boolean value) {
        this.params.setAuthorityControlled(value);
    }

    public void setAuthorityRequired() {
        this.params.setAuthorityRequired();
    }

    public void setAuthorityRequired(boolean value) {
        this.params.setAuthorityRequired(value);
    }

    public void setAutofocus(String value) {
        this.params.setAutofocus(value);
    }

    public void setChoices(String fieldKey) {
        this.params.setChoices(fieldKey);
    }

    public void setChoicesPresentation(String value) throws WingException {
        this.params.setChoicesPresentation(value);
    }

    public void setChoicesClosed(boolean value) {
        this.params.setChoicesClosed(value);
    }

    public void setChoicesClosed() {
        this.params.setChoicesClosed();
    }

    public Help setHelp() throws WingException {
        this.help = new Help(this.context);
        return this.help;
    }

    public void setHelp(String characters) throws WingException {
        this.help = new Help(this.context);
        this.help.addContent(characters);
    }

    public void setHelp(Message message) throws WingException {
        this.help = new Help(this.context);
        this.help.addContent(message);
    }

    public Error addError() throws WingException {
        Error error = new Error(this.context);
        this.errors.add(error);
        return error;
    }

    public void addError(String characters) throws WingException {
        Error error = new Error(this.context);
        error.addContent(characters);
        this.errors.add(error);
    }

    public void addError(Message message) throws WingException {
        Error error = new Error(this.context);
        error.addContent(message);
        this.errors.add(error);
    }

    public Label setLabel() throws WingException {
        this.label = new Label(this.context, null, null);
        return this.label;
    }

    public void setLabel(String characters) throws WingException {
        this.label = new Label(this.context, null, null);
        this.label.addContent(characters);
    }

    public void setLabel(Message message) throws WingException {
        this.label = new Label(this.context, null, null);
        this.label.addContent(message);
    }

    protected void removeValueOfType(String removeType) {
        ArrayList<Value> found = new ArrayList<Value>();
        for (Value value : this.values) {
            if (!value.getType().equals(removeType)) continue;
            found.add(value);
        }
        for (Value remove : found) {
            this.values.remove(remove);
            remove.dispose();
        }
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"n", (Object)this.name);
        attributes.put((Object)"id", (Object)this.context.generateID(E_FIELD, this.name));
        attributes.put((Object)A_FIELD_TYPE, (Object)this.type);
        if (this.disabled) {
            attributes.put(A_DISABLED, this.disabled);
        }
        if (this.required) {
            attributes.put(A_REQUIRED, this.required);
        }
        if (this.rend != null) {
            attributes.put((Object)"rend", (Object)this.rend);
        }
        this.startElement(contentHandler, namespaces, E_FIELD, attributes);
        if (this.params != null) {
            this.params.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (this.label != null) {
            this.label.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (this.help != null) {
            this.help.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        for (Error error : this.errors) {
            error.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        for (Field field : this.fields) {
            field.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        for (Option option : this.options) {
            option.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        for (Value value : this.values) {
            value.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        for (Instance instance : this.instances) {
            instance.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        this.endElement(contentHandler, namespaces, E_FIELD);
    }

    public void dispose() {
        if (this.params != null) {
            this.params.dispose();
        }
        if (this.label != null) {
            this.label.dispose();
        }
        if (this.help != null) {
            this.help.dispose();
        }
        if (this.errors != null) {
            for (Error error : this.errors) {
                error.dispose();
            }
            this.errors.clear();
        }
        if (this.fields != null) {
            for (Field field : this.fields) {
                field.dispose();
            }
            this.fields.clear();
        }
        if (this.options != null) {
            for (Option option : this.options) {
                option.dispose();
            }
            this.options.clear();
        }
        if (this.values != null) {
            for (Value value : this.values) {
                value.dispose();
            }
            this.values.clear();
        }
        if (this.instances != null) {
            for (Instance instance : this.instances) {
                instance.dispose();
            }
            this.instances.clear();
        }
        this.params = null;
        this.label = null;
        this.help = null;
        this.errors = null;
        this.fields = null;
        this.options = null;
        this.values = null;
        this.instances = null;
        super.dispose();
    }
}

