/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery.json;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.handle.HandleManager;
import org.dspace.kernel.ServiceManager;
import org.dspace.utils.DSpace;
import org.xml.sax.SAXException;

public class JSONDiscoverySearcher
extends AbstractReader
implements Recyclable {
    private static Logger log = Logger.getLogger(JSONDiscoverySearcher.class);
    private InputStream JSONStream;
    protected Response response;

    protected SearchService getSearchService() {
        DSpace dspace = new DSpace();
        ServiceManager manager = dspace.getServiceManager();
        return (SearchService)manager.getServiceByName(SearchService.class.getName(), SearchService.class);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        int facetMinCount;
        int facetLimit;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        this.response = ObjectModelHelper.getResponse((Map)objectModel);
        DiscoverQuery queryArgs = new DiscoverQuery();
        queryArgs.setQuery(request.getParameter("q"));
        if (request.getParameterValues("fq") != null) {
            queryArgs.addFilterQueries(request.getParameterValues("fq"));
        }
        if (request.getParameter("facet.limit") != null) {
            try {
                facetLimit = Integer.parseInt(request.getParameter("facet.limit"));
            }
            catch (Exception e) {
                facetLimit = -1;
            }
        } else {
            facetLimit = -1;
        }
        if (request.getParameterValues("facet.field") != null) {
            for (int i = 0; i < request.getParameterValues("facet.field").length; ++i) {
                DiscoveryConfigurationParameters.SORT facetSort = request.getParameter("facet.sort") == null || request.getParameter("facet.sort").equalsIgnoreCase("count") ? DiscoveryConfigurationParameters.SORT.COUNT : DiscoveryConfigurationParameters.SORT.VALUE;
                String facetField = request.getParameterValues("facet.field")[i];
                queryArgs.addFacetField(new DiscoverFacetField(facetField, "ac", facetLimit, facetSort));
            }
        }
        try {
            facetMinCount = Integer.parseInt(request.getParameter("facet.mincount"));
        }
        catch (Exception e) {
            facetMinCount = 1;
        }
        queryArgs.setFacetMinCount(facetMinCount);
        String jsonWrf = request.getParameter("json.wrf");
        try {
            Context context = ContextUtil.obtainContext((Map)objectModel);
            this.JSONStream = this.getSearchService().searchJSON(context, queryArgs, this.getScope(context, objectModel), jsonWrf);
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving JSON string for Discovery auto complete", (Throwable)e);
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.JSONStream != null) {
            int length;
            byte[] buffer = new byte[8192];
            this.response.setHeader("Content-Length", String.valueOf(this.JSONStream.available()));
            while ((length = this.JSONStream.read(buffer)) > -1) {
                this.out.write(buffer, 0, length);
            }
        }
        this.out.flush();
    }

    private DSpaceObject getScope(Context context, Map objectModel) throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String scopeString = request.getParameter("scope");
        DSpaceObject dso = scopeString == null || "".equals(scopeString) ? HandleUtil.obtainHandle((Map)objectModel) : HandleManager.resolveToObject((Context)context, (String)scopeString);
        return dso;
    }

    public void recycle() {
        this.response = null;
        this.JSONStream = null;
        super.recycle();
    }
}

