/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ResourceReader;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.ConcatenationReader;
import org.dspace.core.ConfigurationManager;
import org.mozilla.javascript.EvaluatorException;
import org.xml.sax.SAXException;

public class ConcatenationReader
extends ResourceReader {
    private static final int MINIFY_LINEBREAKPOS = 8000;
    protected List<Source> inputSources;
    private String key;
    private StreamEnumeration streamEnumeration;
    private static Logger log = Logger.getLogger(ConcatenationReader.class);
    private boolean doMinify = true;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        String[] files;
        this.key = src;
        this.setByteRanges(false);
        this.inputSources = new ArrayList();
        String path = "";
        if (src.contains("/")) {
            path = src.substring(0, src.lastIndexOf(47));
        }
        String file = src.substring(src.lastIndexOf(47) + 1);
        for (String f : files = file.split(",")) {
            String fullPath;
            Source inSource;
            if (file.endsWith(".json") && !f.endsWith(".json")) {
                f = f + ".json";
            }
            if (file.endsWith(".js") && !f.endsWith(".js")) {
                f = f + ".js";
            }
            if (file.endsWith(".css") && !f.endsWith(".css")) {
                f = f + ".css";
            }
            if (!(inSource = resolver.resolveURI(fullPath = !path.isEmpty() ? path + "/" + f : f)).exists()) {
                throw new ResourceNotFoundException("Resource not found (" + fullPath + ")");
            }
            this.inputSources.add(inSource);
        }
        super.setup(resolver, objectModel, path + "/" + files[files.length - 1], par);
        this.streamEnumeration = new StreamEnumeration(this, null);
        try {
            if ("nominify".equals(par.getParameter("requestQueryString"))) {
                this.doMinify = false;
            } else {
                this.key = this.key + "?minify";
            }
        }
        catch (ParameterException e) {
            log.error((Object)"ParameterException in setup when retrieving parameter requestQueryString", (Throwable)e);
        }
    }

    public void recycle() {
        if (this.inputSources != null) {
            for (Source s : this.inputSources) {
                this.resolver.release(s);
            }
            this.inputSources = null;
            this.streamEnumeration = null;
            this.key = null;
        }
        super.recycle();
    }

    public Serializable getKey() {
        return this.key;
    }

    public SourceValidity getValidity() {
        long lm = this.getLastModified();
        if (lm > 0L) {
            return new TimeStampValidity(lm);
        }
        return null;
    }

    public long getLastModified() {
        long modified = 0L;
        for (Source s : this.inputSources) {
            if (s.getLastModified() <= modified) continue;
            modified = s.getLastModified();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, ProcessingException {
        try (SequenceInputStream inputStream = new SequenceInputStream((Enumeration<? extends InputStream>)this.streamEnumeration);){
            if (ConfigurationManager.getBooleanProperty((String)"xmlui.theme.enableMinification", (boolean)false) && this.doMinify) {
                this.compressedOutput((InputStream)inputStream);
            } else {
                this.normalOutput((InputStream)inputStream);
            }
        }
        this.out.flush();
    }

    private void compressedOutput(InputStream inputStream) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        OutputStreamWriter outWriter = new OutputStreamWriter(bytes);
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        if (this.key.endsWith(".js?minify") || this.key.endsWith(".json?minify")) {
            try {
                JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)in, null);
                compressor.compress((Writer)outWriter, 8000, true, false, false, false);
            }
            catch (EvaluatorException e) {
                this.normalOutput(inputStream);
                return;
            }
        } else if (this.key.endsWith(".css?minify")) {
            CssCompressor compressor = new CssCompressor((Reader)in);
            compressor.compress((Writer)outWriter, 8000);
        } else {
            this.normalOutput(inputStream);
            return;
        }
        ((Writer)outWriter).flush();
        this.response.setHeader("Content-Length", Long.toString(bytes.size()));
        bytes.writeTo(this.out);
        ((Reader)in).close();
    }

    private void normalOutput(InputStream inputStream) throws IOException {
        int length;
        boolean validContentLength = true;
        byte[] buffer = new byte[this.bufferSize];
        long contentLength = 0L;
        for (Source s : this.inputSources) {
            if (s.getContentLength() < 0L) {
                validContentLength = false;
            }
            contentLength += s.getContentLength();
        }
        if (validContentLength) {
            this.response.setHeader("Content-Length", Long.toString(contentLength));
        }
        while ((length = inputStream.read(buffer)) > -1) {
            this.out.write(buffer, 0, length);
        }
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

