/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.log4j.Logger;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataImport;
import org.dspace.app.bulkedit.MetadataImportException;
import org.dspace.app.bulkedit.MetadataImportInvalidHeadingException;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.cocoon.servlet.multipart.DSpacePartOnDisk;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class FlowMetadataImportUtils {
    private static final Message T_upload_successful = new Message("default", "xmlui.administrative.metadataimport.flow.upload_successful");
    private static final Message T_upload_failed = new Message("default", "xmlui.administrative.metadataimport.flow.upload_failed");
    private static final Message T_upload_badschema = new Message("default", "xmlui.administrative.metadataimport.flow.upload_badschema");
    private static final Message T_upload_badelement = new Message("default", "xmlui.administrative.metadataimport.flow.upload_badelement");
    private static final Message T_import_successful = new Message("default", "xmlui.administrative.metadataimport.flow.import_successful");
    private static final Message T_import_failed = new Message("default", "xmlui.administrative.metadataimport.flow.import_failed");
    private static final Message T_over_limit = new Message("default", "xmlui.administrative.metadataimport.flow.over_limit");
    private static final Message T_no_changes = new Message("default", "xmlui.administrative.metadataimport.general.no_changes");
    private static final int limit = ConfigurationManager.getIntProperty((String)"bulkedit", (String)"gui-item-limit", (int)20);
    private static Logger log = Logger.getLogger(FlowMetadataImportUtils.class);

    public static FlowResult processMetadataImport(Context context, Request request) throws SQLException, AuthorizeException, IOException, Exception {
        FlowResult result;
        block5: {
            result = new FlowResult();
            result.setContinue(false);
            DSpaceCSV csv = (DSpaceCSV)request.getSession().getAttribute("csv");
            if (csv != null) {
                try {
                    MetadataImport mImport = new MetadataImport(context, csv);
                    List changes = mImport.runImport(true, false, false, false);
                    context.commit();
                    request.setAttribute("changes", (Object)changes);
                    request.getSession().removeAttribute("csv");
                    log.debug((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)(changes.size() + " items changed")));
                    if (changes.size() > 0) {
                        result.setContinue(true);
                        result.setOutcome(true);
                        result.setMessage(T_import_successful);
                        break block5;
                    }
                    result.setContinue(false);
                    result.setOutcome(false);
                    result.setMessage(T_no_changes);
                }
                catch (MetadataImportException e) {
                    result.setContinue(false);
                    result.setOutcome(false);
                    result.addError(e.getLocalizedMessage());
                    result.setMessage(T_import_failed);
                    log.debug((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)("Error encountered while making changes - " + e.getMessage())));
                }
            } else {
                result.setContinue(false);
                result.setOutcome(false);
                result.setMessage(T_import_failed);
                log.debug((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)"Changes cancelled"));
            }
        }
        return result;
    }

    public static FlowResult processUploadCSV(Context context, Request request) throws SQLException, AuthorizeException, IOException, Exception {
        FlowResult result;
        block15: {
            result = new FlowResult();
            result.setContinue(false);
            Object object = null;
            if (request.get("file") != null) {
                object = request.get("file");
            }
            Part filePart = null;
            File file = null;
            if (object instanceof Part) {
                filePart = (Part)object;
                file = ((DSpacePartOnDisk)filePart).getFile();
            }
            if (filePart != null && filePart.getSize() > 0) {
                String name = filePart.getUploadName();
                while (name.indexOf(47) > -1) {
                    name = name.substring(name.indexOf(47) + 1);
                }
                while (name.indexOf(92) > -1) {
                    name = name.substring(name.indexOf(92) + 1);
                }
                try {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)"loading file"));
                    DSpaceCSV csv = new DSpaceCSV(file, context);
                    if (!file.delete()) {
                        log.error((Object)"Unable to delete CSV file");
                    }
                    MetadataImport mImport = new MetadataImport(context, csv);
                    List changes = mImport.runImport(false, false, false, false);
                    log.debug((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)(changes.size() + " items with changes identified")));
                    if (changes.size() > 0) {
                        if (changes.size() > limit) {
                            result.setContinue(false);
                            result.setOutcome(false);
                            result.setMessage(T_over_limit);
                            log.info((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)("too many changes - " + changes.size() + " (" + limit + " allowed)")));
                        } else {
                            request.setAttribute("changes", (Object)changes);
                            request.getSession().setAttribute("csv", (Object)csv);
                            result.setContinue(true);
                            result.setOutcome(true);
                            result.setMessage(T_upload_successful);
                        }
                        break block15;
                    }
                    result.setContinue(false);
                    result.setOutcome(false);
                    result.setMessage(T_no_changes);
                }
                catch (MetadataImportInvalidHeadingException mihe) {
                    result.setContinue(false);
                    result.setOutcome(false);
                    if (mihe.getType().equals("0")) {
                        result.setMessage(T_upload_badschema);
                    } else {
                        result.setMessage(T_upload_badelement);
                    }
                    result.setCharacters(mihe.getBadHeader());
                }
                catch (MetadataImportException e) {
                    result.setContinue(false);
                    result.setOutcome(false);
                    result.setMessage(T_upload_failed);
                    result.setCharacters(e.getMessage());
                    log.debug((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)("Error encountered while looking for changes - " + e.getMessage())));
                }
            } else {
                result.setContinue(false);
                result.setOutcome(false);
                result.setMessage(T_upload_failed);
            }
        }
        return result;
    }
}

