/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.community;

import java.sql.SQLException;
import org.dspace.app.xmlui.aspect.administrative.FlowContainerUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;

public class EditCommunityMetadataForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = EditCommunityMetadataForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_community_trail = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.general.community_trail");
    private static final Message T_options_metadata = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.general.options_metadata");
    private static final Message T_options_roles = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.general.options_roles");
    private static final Message T_options_curate = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.general.options_curate");
    private static final Message T_title = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.title");
    private static final Message T_trail = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.trail");
    private static final Message T_main_head = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.main_head");
    private static final Message T_label_name = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.label_name");
    private static final Message T_label_short_description = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.label_short_description");
    private static final Message T_label_introductory_text = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.label_introductory_text");
    private static final Message T_label_copyright_text = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.label_copyright_text");
    private static final Message T_label_side_bar_text = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.label_side_bar_text");
    private static final Message T_label_logo = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.label_logo");
    private static final Message T_label_existing_logo = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.label_existing_logo");
    private static final Message T_submit_delete_logo = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.submit_delete_logo");
    private static final Message T_submit_delete = EditCommunityMetadataForm.message((String)"xmlui.administrative.community.EditCommunityMetadataForm.submit_delete");
    private static final Message T_submit_update = EditCommunityMetadataForm.message((String)"xmlui.general.update");
    private static final Message T_submit_return = EditCommunityMetadataForm.message((String)"xmlui.general.return");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_community_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        int communityID = this.parameters.getParameterAsInteger("communityID", -1);
        Community thisCommunity = Community.find((Context)this.context, (int)communityID);
        String baseURL = this.contextPath + "/admin/community?administrative-continue=" + this.knot.getId();
        String short_description_error = FlowContainerUtils.checkXMLFragment((String)thisCommunity.getMetadata("short_description"));
        String introductory_text_error = FlowContainerUtils.checkXMLFragment((String)thisCommunity.getMetadata("introductory_text"));
        String copyright_text_error = FlowContainerUtils.checkXMLFragment((String)thisCommunity.getMetadata("copyright_text"));
        String side_bar_text_error = FlowContainerUtils.checkXMLFragment((String)thisCommunity.getMetadata("side_bar_text"));
        Division main = body.addInteractiveDivision("community-metadata-edit", this.contextPath + "/admin/community", "multipart", "primary administrative community");
        main.setHead(T_main_head.parameterize(new Object[]{thisCommunity.getName()}));
        List options = main.addList("options", "simple", "horizontal");
        options.addItem().addHighlight("bold").addXref(baseURL + "&submit_metadata", T_options_metadata);
        options.addItem().addXref(baseURL + "&submit_roles", T_options_roles);
        options.addItem().addXref(baseURL + "&submit_curate", T_options_curate);
        List metadataList = main.addList("metadataList", "form");
        metadataList.addLabel(T_label_name);
        Text name = metadataList.addItem().addText("name");
        name.setSize(40);
        name.setValue(thisCommunity.getMetadata("name"));
        metadataList.addLabel(T_label_short_description);
        Text short_description = metadataList.addItem().addText("short_description");
        short_description.setValue(thisCommunity.getMetadata("short_description"));
        short_description.setSize(40);
        if (short_description_error != null) {
            short_description.addError(short_description_error);
        }
        metadataList.addLabel(T_label_introductory_text);
        TextArea introductory_text = metadataList.addItem().addTextArea("introductory_text");
        introductory_text.setValue(thisCommunity.getMetadata("introductory_text"));
        introductory_text.setSize(6, 40);
        if (introductory_text_error != null) {
            introductory_text.addError(introductory_text_error);
        }
        metadataList.addLabel(T_label_copyright_text);
        TextArea copyright_text = metadataList.addItem().addTextArea("copyright_text");
        copyright_text.setValue(thisCommunity.getMetadata("copyright_text"));
        copyright_text.setSize(6, 40);
        if (copyright_text_error != null) {
            copyright_text.addError(copyright_text_error);
        }
        metadataList.addLabel(T_label_side_bar_text);
        TextArea side_bar_text = metadataList.addItem().addTextArea("side_bar_text");
        side_bar_text.setValue(thisCommunity.getMetadata("side_bar_text"));
        side_bar_text.setSize(6, 40);
        if (side_bar_text_error != null) {
            side_bar_text.addError(side_bar_text_error);
        }
        metadataList.addLabel(T_label_logo);
        metadataList.addItem().addFile("logo");
        if (thisCommunity.getLogo() != null) {
            metadataList.addLabel(T_label_existing_logo);
            Item item = metadataList.addItem();
            item.addFigure(this.contextPath + "/bitstream/id/" + thisCommunity.getLogo().getID() + "/bob.jpg", null, null);
            item.addButton("submit_delete_logo").setValue(T_submit_delete_logo);
        }
        Para buttonList = main.addPara();
        buttonList.addButton("submit_save").setValue(T_submit_update);
        if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)thisCommunity, (int)2)) {
            buttonList.addButton("submit_delete").setValue(T_submit_delete);
        }
        buttonList.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

