/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.content.DSpaceObject;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryRecentSubmissionsConfiguration;

public abstract class AbstractRecentSubmissionTransformer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message view_more = AbstractRecentSubmissionTransformer.message((String)"xmlui.ArtifactBrowser.AbstractRecentSubmissionTransformer.recent_submissions_more");
    private static final Logger log = Logger.getLogger(AbstractRecentSubmissionTransformer.class);
    protected DiscoverResult queryResults;
    protected int maxRecentSubmissions;
    private SourceValidity validity;

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                DSpaceValidity validity = new DSpaceValidity();
                validity.add(dso);
                this.getRecentlySubmittedItems(dso);
                if (this.queryResults != null) {
                    List resultingObjects = this.queryResults.getDspaceObjects();
                    for (DSpaceObject resultObject : resultingObjects) {
                        validity.add(resultObject);
                    }
                    validity.add("numFound:" + resultingObjects.size());
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    protected void getRecentlySubmittedItems(DSpaceObject dso) {
        if (this.queryResults != null) {
            return;
        }
        try {
            DiscoverQuery queryArgs = new DiscoverQuery();
            DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)dso);
            List defaultFilterQueries = discoveryConfiguration.getDefaultFilterQueries();
            queryArgs.addFilterQueries(defaultFilterQueries.toArray(new String[defaultFilterQueries.size()]));
            queryArgs.setDSpaceObjectFilter(2);
            DiscoveryRecentSubmissionsConfiguration recentSubmissionConfiguration = discoveryConfiguration.getRecentSubmissionConfiguration();
            if (recentSubmissionConfiguration != null) {
                this.maxRecentSubmissions = recentSubmissionConfiguration.getMax();
                queryArgs.setMaxResults(this.maxRecentSubmissions);
                String sortField = SearchUtils.getSearchService().toSortFieldIndex(recentSubmissionConfiguration.getMetadataSortField(), recentSubmissionConfiguration.getType());
                if (sortField != null) {
                    queryArgs.setSortField(sortField, DiscoverQuery.SORT_ORDER.desc);
                }
                SearchService service = SearchUtils.getSearchService();
                this.queryResults = service.search(this.context, dso, queryArgs);
            } else {
                this.queryResults = null;
            }
        }
        catch (SearchServiceException se) {
            log.error((Object)("Caught SearchServiceException while retrieving recent submission for: " + (dso == null ? "home page" : dso.getHandle())), (Throwable)se);
        }
    }

    protected void addViewMoreLink(Division recentSubmissionDiv, DSpaceObject dso) throws WingException {
        String url = this.contextPath;
        if (dso != null) {
            url = url + "/handle/" + dso.getHandle();
        }
        url = url + "/recent-submissions";
        recentSubmissionDiv.addPara("recent-submission-view-more", "recentSubmissionViewMore").addXref(url).addContent(view_more);
    }

    public void recycle() {
        this.queryResults = null;
        this.validity = null;
        this.maxRecentSubmissions = 0;
        super.recycle();
    }
}

