/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing;

import org.apache.commons.logging.Log;
import org.dspace.app.xmlui.wing.ObjectManager;
import org.dspace.app.xmlui.wing.WingException;

public class WingContext {
    public static final char DIVIDER = '.';
    private String componentName;
    private Log logger;
    private ObjectManager objectManager;

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log log) {
        this.logger = log;
    }

    public String generateID(String application, String name) {
        return this.combine(new String[]{this.componentName, application, name});
    }

    public String generateID(String application, String name, String subName) {
        return this.combine(new String[]{this.componentName, application, name, subName});
    }

    public String generateName(String name) {
        return this.combine(new String[]{this.componentName, name});
    }

    private String combine(String ... parts) {
        StringBuilder combine = new StringBuilder();
        boolean skipDivider = true;
        for (String part : parts) {
            if (part == null) {
                skipDivider = true;
                continue;
            }
            if (skipDivider) {
                skipDivider = false;
            } else {
                combine.append('.');
            }
            combine.append(part);
        }
        return combine.toString();
    }

    public void setObjectManager(ObjectManager objectManager) {
        this.objectManager = objectManager;
    }

    public ObjectManager getObjectManager() {
        return this.objectManager;
    }

    public void checkValidity() throws WingException {
    }

    public void dispose() {
        this.componentName = null;
        this.objectManager = null;
    }
}

