/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.itemimport.factory.ItemImportServiceFactory;
import org.dspace.app.itemimport.service.ItemImportService;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;

public class FlowBatchImportUtils {
    private static final Message T_upload_successful = new Message("default", "xmlui.administrative.batchimport.flow.upload_successful");
    private static final Message T_upload_failed = new Message("default", "xmlui.administrative.batchimport.flow.upload_failed");
    private static final Message T_import_successful = new Message("default", "xmlui.administrative.batchimport.flow.import_successful");
    private static final Message T_import_failed = new Message("default", "xmlui.administrative.batchimport.flow.import_failed");
    private static final Message T_no_changes = new Message("default", "xmlui.administrative.batchimport.general.no_changes");
    private static final Message T_failed_no_collection = new Message("default", "xmlui.administrative.batchimport.flow.failed_no_collection");
    private static Logger log = Logger.getLogger(FlowBatchImportUtils.class);
    protected static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected static final ItemImportService itemImportService = ItemImportServiceFactory.getInstance().getItemImportService();

    public static FlowResult processBatchImport(Context context, Request request) throws SQLException, AuthorizeException, IOException, Exception {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        String zipFile = (String)request.getSession().getAttribute("zip");
        if (zipFile != null) {
            request.getSession().removeAttribute("zipFile");
            log.debug((Object)LogManager.getHeader((Context)context, (String)"batchimport", (String)" items changed"));
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_import_successful);
        } else {
            result.setContinue(false);
            result.setOutcome(false);
            result.setMessage(T_import_failed);
            log.debug((Object)LogManager.getHeader((Context)context, (String)"batchimport", (String)"Changes cancelled"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlowResult processUploadZIP(Context context, Request request) {
        try {
            FlowResult result = new FlowResult();
            result.setContinue(false);
            Object object = null;
            if (request.get("file") != null) {
                object = request.get("file");
            }
            Part filePart = null;
            File file = null;
            if (object instanceof Part) {
                filePart = (Part)object;
                file = ((PartOnDisk)filePart).getFile();
            }
            if (filePart != null && filePart.getSize() > 0) {
                String name = filePart.getUploadName();
                while (name.indexOf(47) > -1) {
                    name = name.substring(name.indexOf(47) + 1);
                }
                while (name.indexOf(92) > -1) {
                    name = name.substring(name.indexOf(92) + 1);
                }
                String collectionHandle = String.valueOf(request.get("collectionHandle"));
                if (StringUtils.isEmpty((String)collectionHandle) || !collectionHandle.contains("/")) {
                    log.error((Object)"UIBatchImport failed due to no collection.");
                    result.setContinue(false);
                    result.setOutcome(false);
                    result.setMessage(T_failed_no_collection);
                    FlowResult flowResult = result;
                    return flowResult;
                }
                ArrayList<Collection> collections = new ArrayList<Collection>();
                try {
                    Collection collection = (Collection)handleService.resolveToObject(context, collectionHandle);
                    collections.add(collection);
                }
                catch (SQLException e) {
                    log.error((Object)"UIBatchImport failed due to collection not existing.", (Throwable)e);
                    result.setContinue(false);
                    result.setOutcome(false);
                    result.setMessage(T_failed_no_collection);
                    FlowResult flowResult = result;
                    itemImportService.cleanupZipTemp();
                    return flowResult;
                }
                File mapFile = null;
                try {
                    mapFile = File.createTempFile(file.getName(), ".map", itemImportService.getTempWorkDirFile());
                }
                catch (IOException e) {
                    log.error((Object)"BatchImportUI Unable to create mapfile", (Throwable)e);
                    result.setContinue(false);
                    result.setOutcome(false);
                    result.setMessage(T_import_failed);
                    FlowResult flowResult = result;
                    itemImportService.cleanupZipTemp();
                    return flowResult;
                }
                log.info((Object)("Attempt UIBatchImport to collection: " + ((Collection)collections.get(0)).getName() + ", zip: " + file.getName() + ", map: " + mapFile.getAbsolutePath()));
                String sourceBatchDir = null;
                try {
                    sourceBatchDir = itemImportService.unzip(file);
                }
                catch (IOException e) {
                    log.error((Object)"BatchImportUI Unable to unzip", (Throwable)e);
                    result.setContinue(false);
                    result.setOutcome(false);
                    result.setMessage(T_import_failed);
                    FlowResult flowResult = result;
                    itemImportService.cleanupZipTemp();
                    return flowResult;
                }
                try {
                    itemImportService.addItemsAtomic(context, collections, sourceBatchDir, mapFile.getAbsolutePath(), true);
                }
                catch (Exception e) {
                    log.error((Object)("BatchImportUI - Failure during import: " + e.getMessage()));
                    result.setContinue(false);
                    result.setOutcome(false);
                    result.setMessage(T_import_failed);
                    try {
                        result.setCharacters(FileUtils.readFileToString((File)mapFile) + e.getMessage());
                    }
                    catch (IOException ioe) {
                        result.setCharacters("Unable to show map file: " + ioe.getMessage());
                        log.error((Object)"BatchImportUI - Unable to print the mapfile to response", (Throwable)ioe);
                    }
                    FlowResult flowResult = result;
                    itemImportService.cleanupZipTemp();
                    return flowResult;
                }
                result.setContinue(true);
                result.setOutcome(true);
                result.setMessage(T_upload_successful);
                try {
                    result.setCharacters(FileUtils.readFileToString((File)mapFile));
                }
                catch (IOException e) {
                    log.error((Object)"BatchImportUI - Unable to print the mapfile to response", (Throwable)e);
                }
                log.info((Object)("Success! UIBatchImport to collection: " + ((Collection)collections.get(0)).getName() + ", zip: " + file.getName() + ", map: " + mapFile.getAbsolutePath()));
            } else {
                result.setContinue(false);
                result.setOutcome(false);
                result.setMessage(T_upload_failed);
            }
            FlowResult flowResult = result;
            return flowResult;
        }
        finally {
            itemImportService.cleanupZipTemp();
        }
    }
}

