/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.RequestUtils;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowRegistryUtils {
    private static final Message T_add_metadata_schema_success_notice = new Message("default", "xmlui.administrative.FlowRegistryUtils.add_metadata_schema_success_notice");
    private static final Message T_delete_metadata_schema_success_notice = new Message("default", "xmlui.administrative.FlowRegistryUtils.delete_metadata_schema_success_notice");
    private static final Message T_add_metadata_field_success_notice = new Message("default", "xmlui.administrative.FlowRegistryUtils.add_metadata_field_success_notice");
    private static final Message T_edit_metadata_field_success_notice = new Message("default", "xmlui.administrative.FlowRegistryUtils.edit_metadata_field_success_notice");
    private static final Message T_move_metadata_field_sucess_notice = new Message("default", "xmlui.administrative.FlowRegistryUtils.move_metadata_field_success_notice");
    private static final Message T_delete_metadata_field_success_notice = new Message("default", "xmlui.administrative.FlowRegistryUtils.delete_metadata_field_success_notice");
    private static final Message T_edit_bitstream_format_success_notice = new Message("default", "xmlui.administrative.FlowRegistryUtils.edit_bitstream_format_success_notice");
    private static final Message T_delete_bitstream_format_success_notice = new Message("default", "xmlui.administrative.FlowRegistryUtils.delete_bitstream_format_success_notice");
    protected static final MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected static final BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected static final MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();

    public static FlowResult processAddMetadataSchema(Context context, String namespace, String name) throws SQLException, AuthorizeException, NonUniqueMetadataException, UIException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        try {
            namespace = URLDecoder.decode(namespace, "UTF-8");
            name = URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new UIException((Throwable)uee);
        }
        if (namespace == null || namespace.length() <= 0) {
            result.addError("namespace");
        }
        if (name == null || name.length() <= 0 || name.indexOf(46) != -1 || name.indexOf(95) != -1 || name.indexOf(32) != -1) {
            result.addError("name");
        }
        if (result.getErrors() == null) {
            MetadataSchema schema = metadataSchemaService.create(context, name, namespace);
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_add_metadata_schema_success_notice);
            result.setParameter("schemaID", (Object)schema.getSchemaID());
        }
        return result;
    }

    public static FlowResult processDeleteMetadataSchemas(Context context, String[] schemaIDs) throws SQLException, AuthorizeException, NonUniqueMetadataException {
        FlowResult result = new FlowResult();
        int count = 0;
        for (String id : schemaIDs) {
            MetadataSchema schema = metadataSchemaService.find(context, Integer.valueOf(id).intValue());
            List fields = metadataFieldService.findAllInSchema(context, schema);
            for (MetadataField field : fields) {
                metadataFieldService.delete(context, field);
            }
            metadataSchemaService.delete(context, schema);
            ++count;
        }
        if (count > 0) {
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_delete_metadata_schema_success_notice);
        }
        return result;
    }

    public static FlowResult processAddMetadataField(Context context, int schemaID, String element, String qualifier, String note) throws IOException, AuthorizeException, SQLException, UIException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        try {
            element = URLDecoder.decode(element, "UTF-8");
            qualifier = URLDecoder.decode(qualifier, "UTF-8");
            note = URLDecoder.decode(note, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new UIException((Throwable)uee);
        }
        result.setErrors(FlowRegistryUtils.checkMetadataFieldName((String)element, (String)qualifier));
        if ("".equals(qualifier)) {
            qualifier = null;
        }
        if (result.getErrors() == null) {
            try {
                MetadataSchema schema = metadataSchemaService.find(context, schemaID);
                MetadataField field = metadataFieldService.create(context, schema, element, qualifier, note);
                result.setContinue(true);
                result.setOutcome(true);
                result.setMessage(T_add_metadata_field_success_notice);
                result.setParameter("fieldID", (Object)field.getFieldID());
            }
            catch (NonUniqueMetadataException nume) {
                result.addError("duplicate_field");
            }
        }
        return result;
    }

    public static FlowResult processEditMetadataField(Context context, int schemaID, int fieldID, String element, String qualifier, String note) throws IOException, AuthorizeException, SQLException, UIException {
        MetadataField possibleDuplicate;
        FlowResult result = new FlowResult();
        result.setContinue(false);
        try {
            element = URLDecoder.decode(element, "UTF-8");
            qualifier = URLDecoder.decode(qualifier, "UTF-8");
            note = URLDecoder.decode(note, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new UIException((Throwable)uee);
        }
        result.setErrors(FlowRegistryUtils.checkMetadataFieldName((String)element, (String)qualifier));
        if ("".equals(qualifier)) {
            qualifier = null;
        }
        if ((possibleDuplicate = metadataFieldService.findByElement(context, metadataSchemaService.find(context, schemaID), element, qualifier)) != null && possibleDuplicate.getFieldID() != fieldID) {
            result.addError("duplicate_field");
        }
        if (result.getErrors() == null) {
            try {
                MetadataField field = metadataFieldService.find(context, fieldID);
                field.setElement(element);
                field.setQualifier(qualifier);
                field.setScopeNote(note);
                metadataFieldService.update(context, field);
                result.setContinue(true);
                result.setOutcome(true);
                result.setMessage(T_edit_metadata_field_success_notice);
            }
            catch (NonUniqueMetadataException nume) {
                result.addError("duplicate_field");
            }
        }
        return result;
    }

    private static List<String> checkMetadataFieldName(String element, String qualifier) {
        ArrayList<String> errors = new ArrayList<String>();
        if (element == null || element.length() <= 0) {
            element = "";
            errors.add("element_empty");
        }
        if (element.indexOf(46) != -1 || element.indexOf(95) != -1 || element.indexOf(32) != -1) {
            errors.add("element_badchar");
        }
        if (element.length() > 64) {
            errors.add("element_tolong");
        }
        if (qualifier != null && qualifier.length() > 0) {
            if (qualifier.length() > 64) {
                errors.add("qualifier_tolong");
            }
            if (qualifier.indexOf(46) != -1 || qualifier.indexOf(95) != -1 || qualifier.indexOf(32) != -1) {
                errors.add("qualifier_badchar");
            }
        }
        if (errors.size() == 0) {
            return null;
        }
        return errors;
    }

    public static FlowResult processMoveMetadataField(Context context, int schemaID, String[] fieldIDs) throws NumberFormatException, SQLException, AuthorizeException, NonUniqueMetadataException, IOException {
        FlowResult result = new FlowResult();
        int count = 0;
        for (String id : fieldIDs) {
            MetadataField field = metadataFieldService.find(context, Integer.valueOf(id).intValue());
            field.setMetadataSchema(metadataSchemaService.find(context, schemaID));
            metadataFieldService.update(context, field);
            ++count;
        }
        if (count > 0) {
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_move_metadata_field_sucess_notice);
        }
        return result;
    }

    public static FlowResult processDeleteMetadataField(Context context, String[] fieldIDs) throws NumberFormatException, SQLException, AuthorizeException {
        FlowResult result = new FlowResult();
        int count = 0;
        for (String id : fieldIDs) {
            MetadataField field = metadataFieldService.find(context, Integer.valueOf(id).intValue());
            metadataFieldService.delete(context, field);
            ++count;
        }
        if (count > 0) {
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_delete_metadata_field_success_notice);
        }
        return result;
    }

    public static FlowResult processEditBitstreamFormat(Context context, int formatID, Request request) throws SQLException, AuthorizeException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        String mimeType = request.getParameter("mimetype");
        String shortDescription = request.getParameter("short_description");
        String description = request.getParameter("description");
        String supportLevel = request.getParameter("support_level");
        String internal = request.getParameter("internal");
        List extensionsList = RequestUtils.getFieldValues((Request)request, (String)"extensions");
        if (formatID != 1 && (shortDescription == null || shortDescription.length() == 0)) {
            result.addError("short_description");
            return result;
        }
        for (int i = 0; i < extensionsList.size(); ++i) {
            if (!((String)extensionsList.get(i)).startsWith(".")) continue;
            extensionsList.set(i, ((String)extensionsList.get(i)).substring(1));
        }
        BitstreamFormat format = formatID >= 0 ? (BitstreamFormat)bitstreamFormatService.find(context, formatID) : (BitstreamFormat)bitstreamFormatService.create(context);
        format.setMIMEType(mimeType);
        if (formatID != 1) {
            format.setShortDescription(context, shortDescription);
        }
        format.setDescription(description);
        format.setSupportLevel(Integer.valueOf(supportLevel).intValue());
        if (internal == null) {
            format.setInternal(false);
        } else {
            format.setInternal(true);
        }
        format.setExtensions(extensionsList);
        bitstreamFormatService.update(context, (Object)format);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_edit_bitstream_format_success_notice);
        result.setParameter("formatID", (Object)format.getID());
        return result;
    }

    public static FlowResult processDeleteBitstreamFormats(Context context, String[] formatIDs) throws NumberFormatException, SQLException, AuthorizeException {
        FlowResult result = new FlowResult();
        int count = 0;
        for (String id : formatIDs) {
            BitstreamFormat format = (BitstreamFormat)bitstreamFormatService.find(context, Integer.valueOf(id).intValue());
            bitstreamFormatService.delete(context, (Object)format);
            ++count;
        }
        if (count > 0) {
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_delete_bitstream_format_success_notice);
        }
        return result;
    }
}

