/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.collection;

import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Radio;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.factory.HarvestServiceFactory;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class EditCollectionHarvestingForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = EditCollectionHarvestingForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_collection_trail = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.general.collection_trail");
    private static final Message T_options_metadata = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.general.options_metadata");
    private static final Message T_options_roles = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.general.options_roles");
    private static final Message T_options_curate = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.general.options_curate");
    private static final Message T_main_head = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionMetadataForm.main_head");
    private static final Message T_options_harvest = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.options_harvest");
    private static final Message T_title = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.title");
    private static final Message T_trail = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.trail");
    private static final Message T_label_source = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.label_source");
    private static final Message T_source_normal = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.source_normal");
    private static final Message T_source_harvested = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.source_harvested");
    private static final Message T_submit_return = EditCollectionHarvestingForm.message((String)"xmlui.general.return");
    private static final Message T_submit_save = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.submit_save");
    private static final Message T_main_settings_head = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.main_settings_head");
    private static final Message T_label_oai_provider = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.label_oai_provider");
    private static final Message T_label_setid = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.label_setid");
    private static final Message T_label_metadata_format = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.label_metadata_format");
    private static final Message T_label_harvest_level = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.label_harvest_level");
    private static final Message T_label_harvest_result = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.label_harvest_result");
    private static final Message T_harvest_result_new = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.harvest_result_new");
    private static final Message T_label_harvest_status = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.label_harvest_status");
    private static final Message T_harvest_status_ready = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.harvest_status_ready");
    private static final Message T_harvest_status_busy = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.harvest_status_busy");
    private static final Message T_harvest_status_queued = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.harvest_status_queued");
    private static final Message T_harvest_status_oai_error = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.harvest_status_oai_error");
    private static final Message T_harvest_status_unknown_error = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.harvest_status_unknown_error");
    private static final Message T_option_md_only = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.option_md_only");
    private static final Message T_option_md_and_ref = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.option_md_and_ref");
    private static final Message T_option_md_and_bs = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.option_md_and_bs");
    private static final Message T_submit_change_settings = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.submit_change_settings");
    private static final Message T_submit_import_now = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.submit_import_now");
    private static final Message T_submit_reimport_collection = EditCollectionHarvestingForm.message((String)"xmlui.administrative.collection.EditCollectionHarvestingForm.submit_reimport_collection");
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected HarvestedCollectionService harvestedCollectionService = HarvestServiceFactory.getInstance().getHarvestedCollectionService();

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_collection_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        UUID collectionID = UUID.fromString(this.parameters.getParameter("collectionID", null));
        Collection thisCollection = (Collection)this.collectionService.find(this.context, collectionID);
        HarvestedCollection hc = this.harvestedCollectionService.find(this.context, thisCollection);
        String baseURL = this.contextPath + "/admin/collection?administrative-continue=" + this.knot.getId();
        String oaiProviderValue = hc.getOaiSource();
        String oaiSetIdValue = hc.getOaiSetId();
        String metadataFormatValue = hc.getHarvestMetadataConfig();
        int harvestLevelValue = hc.getHarvestType();
        int harvestStatusValue = hc.getHarvestStatus();
        Division main = body.addInteractiveDivision("collection-harvesting-edit", this.contextPath + "/admin/collection", "multipart", "primary administrative collection");
        main.setHead(T_main_head.parameterize(new Object[]{this.collectionService.getMetadata((DSpaceObject)thisCollection, "name")}));
        List options = main.addList("options", "simple", "horizontal");
        options.addItem().addXref(baseURL + "&submit_metadata", T_options_metadata);
        options.addItem().addXref(baseURL + "&submit_roles", T_options_roles);
        options.addItem().addHighlight("bold").addXref(baseURL + "&submit_harvesting", T_options_harvest);
        options.addItem().addXref(baseURL + "&submit_curate", T_options_curate);
        List harvestSource = main.addList("harvestSource", "form");
        harvestSource.addLabel(T_label_source);
        Radio source = harvestSource.addItem().addRadio("source");
        source.addOption(false, "source_normal", T_source_normal);
        source.addOption(true, "source_harvested", T_source_harvested);
        List settings = main.addList("harvestSettings", "form");
        settings.setHead(T_main_settings_head);
        settings.addLabel(T_label_oai_provider);
        settings.addItem(oaiProviderValue);
        settings.addLabel(T_label_setid);
        settings.addItem(oaiSetIdValue);
        settings.addLabel(T_label_metadata_format);
        String key = "harvester.oai.metadataformats." + metadataFormatValue;
        String metadataString = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("oai." + key);
        String displayName = metadataString.indexOf(44) != -1 ? metadataString.substring(metadataString.indexOf(44) + 1) : metadataFormatValue + "(" + metadataString + ")";
        settings.addItem(displayName);
        settings.addLabel(T_label_harvest_level);
        Item harvestLevel = settings.addItem();
        switch (harvestLevelValue) {
            case 1: {
                harvestLevel.addContent(T_option_md_only);
                break;
            }
            case 2: {
                harvestLevel.addContent(T_option_md_and_ref);
                break;
            }
            default: {
                harvestLevel.addContent(T_option_md_and_bs);
            }
        }
        if (harvestLevelValue > 0) {
            settings.addLabel(T_label_harvest_result);
            Item harvestResult = settings.addItem();
            if (hc.getHarvestMessage() != null) {
                harvestResult.addContent(hc.getHarvestMessage() + " on " + hc.getHarvestStartTime());
            } else {
                harvestResult.addContent(T_harvest_result_new);
            }
        }
        settings.addLabel(T_label_harvest_status);
        Item harvestStatus = settings.addItem();
        switch (harvestStatusValue) {
            case 0: {
                harvestStatus.addContent(T_harvest_status_ready);
                break;
            }
            case 1: {
                harvestStatus.addContent(T_harvest_status_busy);
                break;
            }
            case 2: {
                harvestStatus.addContent(T_harvest_status_queued);
                break;
            }
            case 3: {
                harvestStatus.addContent(T_harvest_status_oai_error);
                break;
            }
            case -1: {
                harvestStatus.addContent(T_harvest_status_unknown_error);
            }
        }
        settings.addLabel();
        Item harvestButtons = settings.addItem();
        harvestButtons.addButton("submit_change").setValue(T_submit_change_settings);
        harvestButtons.addButton("submit_import_now").setValue(T_submit_import_now);
        harvestButtons.addButton("submit_reimport").setValue(T_submit_reimport_collection);
        Para buttonList = main.addPara();
        buttonList.addButton("submit_save").setValue(T_submit_save);
        buttonList.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

