/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.general;

import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.selection.Selector;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

public class AuthenticatedSelector
extends AbstractLogEnabled
implements Selector {
    private static Logger log = Logger.getLogger(AuthenticatedSelector.class);
    public static final String EPERSON = "eperson";
    public static final String ADMINISTRATOR = "administrator";
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    public boolean select(String expression, Map objectModel, Parameters parameters) {
        try {
            Context context = ContextUtil.obtainContext((Map)objectModel);
            EPerson eperson = context.getCurrentUser();
            if (eperson == null) {
                return false;
            }
            if (EPERSON.equals(expression)) {
                return true;
            }
            if (ADMINISTRATOR.equals(expression)) {
                return this.authorizeService.isAdmin(context);
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Error selecting based on authentication status: " + e.getMessage()));
            return false;
        }
    }
}

