/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.aspect.submission.AbstractStep;
import org.dspace.app.xmlui.aspect.submission.submit.AccessStepUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class EditFileStep
extends AbstractStep {
    protected static final Message T_head = EditFileStep.message((String)"xmlui.Submission.submit.EditFileStep.head");
    protected static final Message T_file = EditFileStep.message((String)"xmlui.Submission.submit.EditFileStep.file");
    protected static final Message T_description = EditFileStep.message((String)"xmlui.Submission.submit.EditFileStep.description");
    protected static final Message T_description_help = EditFileStep.message((String)"xmlui.Submission.submit.EditFileStep.description_help");
    protected static final Message T_info1 = EditFileStep.message((String)"xmlui.Submission.submit.EditFileStep.info1");
    protected static final Message T_format_detected = EditFileStep.message((String)"xmlui.Submission.submit.EditFileStep.format_detected");
    protected static final Message T_format_selected = EditFileStep.message((String)"xmlui.Submission.submit.EditFileStep.format_selected");
    protected static final Message T_format_default = EditFileStep.message((String)"xmlui.Submission.submit.EditFileStep.format_default");
    protected static final Message T_info2 = EditFileStep.message((String)"xmlui.Submission.submit.EditFileStep.info2");
    protected static final Message T_format_user = EditFileStep.message((String)"xmlui.Submission.submit.EditFileStep.format_user");
    protected static final Message T_format_user_help = EditFileStep.message((String)"xmlui.Submission.submit.EditFileStep.format_user_help");
    protected static final Message T_submit_save = EditFileStep.message((String)"xmlui.general.save");
    protected static final Message T_submit_cancel = EditFileStep.message((String)"xmlui.general.cancel");
    private Bitstream bitstream;
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();

    public EditFileStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.bitstream = this.submissionInfo.getBitstream();
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        BitstreamFormat currentFormat = this.bitstream.getFormat(this.context);
        BitstreamFormat guessedFormat = this.bitstreamFormatService.guessFormat(this.context, this.bitstream);
        List bitstreamFormats = this.bitstreamFormatService.findNonInternal(this.context);
        UUID itemID = this.submissionInfo.getSubmissionItem().getItem().getID();
        String fileUrl = this.contextPath + "/bitstream/item/" + itemID + "/" + this.bitstream.getName();
        String fileName = this.bitstream.getName();
        Division div = body.addInteractiveDivision("submit-edit-file", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        org.dspace.app.xmlui.wing.element.List edit = div.addList("submit-edit-file", "form");
        edit.setHead(T_head);
        edit.addLabel(T_file);
        edit.addItem().addXref(fileUrl, fileName);
        Text description = edit.addItem().addText("description");
        description.setLabel(T_description);
        description.setHelp(T_description_help);
        description.setValue(this.bitstream.getDescription());
        boolean isAdvancedFormEnabled = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("webui.submission.restrictstep.enableAdvancedForm", false);
        if (!isAdvancedFormEnabled) {
            AccessStepUtil asu = new AccessStepUtil(this.context);
            asu.addEmbargoDateSimpleForm((DSpaceObject)this.bitstream, edit, this.errorFlag);
            asu.addReason(null, edit, this.errorFlag);
        }
        edit.addItem(T_info1);
        if (guessedFormat != null) {
            edit.addLabel(T_format_detected);
            edit.addItem(guessedFormat.getShortDescription());
        }
        Select format = edit.addItem().addSelect("format");
        format.setLabel(T_format_selected);
        format.addOption(-1, T_format_default);
        for (BitstreamFormat bitstreamFormat : bitstreamFormats) {
            String supportLevel = "Unknown";
            if (bitstreamFormat.getSupportLevel() == 1) {
                supportLevel = "known";
            } else if (bitstreamFormat.getSupportLevel() == 2) {
                supportLevel = "Supported";
            }
            String name = bitstreamFormat.getShortDescription() + " (" + supportLevel + ")";
            int id = bitstreamFormat.getID();
            format.addOption(id, name);
        }
        if (currentFormat != null) {
            format.setOptionSelected(currentFormat.getID());
        } else if (guessedFormat != null) {
            format.setOptionSelected(guessedFormat.getID());
        } else {
            format.setOptionSelected(-1);
        }
        edit.addItem(T_info2);
        Text userFormat = edit.addItem().addText("format_description");
        userFormat.setLabel(T_format_user);
        userFormat.setHelp(T_format_user_help);
        userFormat.setValue(this.bitstream.getUserFormatDescription());
        div.addHidden("bitstream_id").setValue(this.bitstream.getID().toString());
        Item actions = edit.addItem();
        actions.addButton("submit_save").setValue(T_submit_save);
        actions.addButton("submit_edit_cancel").setValue(T_submit_cancel);
    }
}

