/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.time.DateFormatUtils;
import org.dspace.app.xmlui.aspect.submission.AbstractStep;
import org.dspace.app.xmlui.aspect.submission.submit.AccessStepUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.xml.sax.SAXException;

public class EditPolicyStep
extends AbstractStep {
    protected static final Message T_head = EditPolicyStep.message((String)"xmlui.Submission.submit.EditPolicyStep.head");
    protected static final Message T_submit_save = EditPolicyStep.message((String)"xmlui.general.save");
    protected static final Message T_submit_cancel = EditPolicyStep.message((String)"xmlui.general.cancel");
    private ResourcePolicy resourcePolicy;
    private Bitstream bitstream;

    public EditPolicyStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.resourcePolicy = (ResourcePolicy)this.submissionInfo.get((Object)"SUB_INFO_SELECTED_RP");
        this.bitstream = this.submissionInfo.getBitstream();
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        Division div = body.addInteractiveDivision("submit-edit-policy", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        List edit = div.addList("submit-edit-file", "form");
        edit.setHead(T_head);
        div.addHidden("policy_id").setValue(this.resourcePolicy.getID().intValue());
        if (this.bitstream != null) {
            div.addHidden("bitstream_id").setValue(this.bitstream.getID().toString());
        }
        AccessStepUtil asu = new AccessStepUtil(this.context);
        asu.addListGroups(String.valueOf(this.resourcePolicy.getGroup()), edit, this.errorFlag, collection);
        String selectedRadio = Integer.toString(0);
        if (this.resourcePolicy.getStartDate() != null) {
            selectedRadio = Integer.toString(1);
        }
        String dateValue = "";
        if (this.resourcePolicy.getStartDate() != null) {
            dateValue = DateFormatUtils.format((Date)this.resourcePolicy.getStartDate(), (String)"yyyy-MM-dd");
        }
        asu.addAccessRadios(selectedRadio, dateValue, edit, this.errorFlag, null);
        asu.addName(this.resourcePolicy.getRpName(), edit, this.errorFlag);
        asu.addReason(this.resourcePolicy.getRpDescription(), edit, this.errorFlag);
        Item actions = edit.addItem();
        actions.addButton("submit_save").setValue(T_submit_save);
        actions.addButton("submit_edit_cancel").setValue(T_submit_cancel);
    }
}

