/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmlworkflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class Submissions
extends AbstractDSpaceTransformer {
    protected static final Message T_title = Submissions.message((String)"xmlui.Submission.Submissions.title");
    protected static final Message T_dspace_home = Submissions.message((String)"xmlui.general.dspace_home");
    protected static final Message T_trail = Submissions.message((String)"xmlui.Submission.Submissions.trail");
    protected static final Message T_head = Submissions.message((String)"xmlui.Submission.Submissions.head");
    protected static final Message T_untitled = Submissions.message((String)"xmlui.Submission.Submissions.untitled");
    protected static final Message T_email = Submissions.message((String)"xmlui.Submission.Submissions.email");
    protected static final Message T_w_head1 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_head1");
    protected static final Message T_w_info1 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_info1");
    protected static final Message T_w_head2 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_head2");
    protected static final Message T_w_column1 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_column1");
    protected static final Message T_w_column2 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_column2");
    protected static final Message T_w_column3 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_column3");
    protected static final Message T_w_column4 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_column4");
    protected static final Message T_w_column5 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_column5");
    protected static final Message T_w_submit_return = Submissions.message((String)"xmlui.Submission.Submissions.workflow_submit_return");
    protected static final Message T_w_info2 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_info2");
    protected static final Message T_w_head3 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_head3");
    protected static final Message T_w_submit_take = Submissions.message((String)"xmlui.Submission.Submissions.workflow_submit_take");
    protected static final Message T_w_info3 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_info3");
    protected static final Message T_p_head1 = Submissions.message((String)"xmlui.Submission.Submissions.progress_head1");
    protected static final Message T_p_info1 = Submissions.message((String)"xmlui.Submission.Submissions.progress_info1");
    protected static final Message T_p_column1 = Submissions.message((String)"xmlui.Submission.Submissions.progress_column1");
    protected static final Message T_p_column2 = Submissions.message((String)"xmlui.Submission.Submissions.progress_column2");
    protected static final Message T_p_column3 = Submissions.message((String)"xmlui.Submission.Submissions.progress_column3");
    private static final Logger log = Logger.getLogger(Submissions.class);
    protected ClaimedTaskService claimedTaskService = XmlWorkflowServiceFactory.getInstance().getClaimedTaskService();
    protected PoolTaskService poolTaskService = XmlWorkflowServiceFactory.getInstance().getPoolTaskService();
    protected XmlWorkflowItemService xmlWorkflowItemService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowItemService();
    protected XmlWorkflowFactory workflowFactory = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory();

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/submissions", T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Division div = body.addInteractiveDivision("submissions", this.contextPath + "/submissions", "post", "primary");
        div.setHead(T_head);
        this.addWorkflowTasks(div);
        this.addSubmissionsInWorkflow(div);
    }

    private void addWorkflowTasksDiv(Division division) throws SQLException, WingException, AuthorizeException, IOException {
        division.addDivision("start-submision");
    }

    private void addWorkflowTasks(Division division) throws SQLException, WingException, AuthorizeException, IOException {
        Row row;
        Workflow wf;
        XmlWorkflowItem item;
        String actionID;
        String stepID;
        List ownedItems = this.claimedTaskService.findByEperson(this.context, this.context.getCurrentUser());
        List pooledItems = this.poolTaskService.findByEperson(this.context, this.context.getCurrentUser());
        if (ownedItems.size() <= 0 && pooledItems.size() <= 0) {
            return;
        }
        Division workflow = division.addDivision("workflow-tasks");
        workflow.setHead(T_w_head1);
        workflow.addPara(T_w_info1);
        Table table = workflow.addTable("workflow-tasks", ownedItems.size() + 2, 5);
        table.setHead(T_w_head2);
        Row header = table.addRow("header");
        header.addCellContent(T_w_column1);
        header.addCellContent(T_w_column2);
        header.addCellContent(T_w_column3);
        header.addCellContent(T_w_column4);
        header.addCellContent(T_w_column5);
        boolean showReturnToPoolButton = false;
        if (ownedItems.size() > 0) {
            for (ClaimedTask owned : ownedItems) {
                stepID = owned.getStepID();
                actionID = owned.getActionID();
                item = owned.getWorkflowItem();
                try {
                    wf = this.workflowFactory.getWorkflow(item.getCollection());
                    Step step = wf.getStep(stepID);
                    WorkflowActionConfig action = step.getActionConfig(actionID);
                    String url = this.contextPath + "/handle/" + item.getCollection().getHandle() + "/xmlworkflow?workflowID=" + item.getID() + "&stepID=" + stepID + "&actionID=" + actionID;
                    String title = item.getItem().getName();
                    String collectionName = item.getCollection().getName();
                    EPerson submitter = item.getSubmitter();
                    String submitterName = submitter.getFullName();
                    String submitterEmail = submitter.getEmail();
                    boolean taskHasPool = step.getUserSelectionMethod().getProcessingAction().usesTaskPool();
                    if (taskHasPool) {
                        showReturnToPoolButton = true;
                    }
                    Row row2 = table.addRow();
                    Cell firstCell = row2.addCell();
                    if (taskHasPool) {
                        CheckBox remove = firstCell.addCheckBox("workflowandstepID");
                        remove.setLabel("selected");
                        remove.addOption(item.getID() + ":" + step.getId());
                    }
                    row2.addCell().addXref(url, Submissions.message((String)("xmlui.XMLWorkflow." + wf.getID() + "." + stepID + "." + actionID)));
                    if (title != null && title.length() > 0) {
                        String displayTitle = title;
                        if (displayTitle.length() > 50) {
                            displayTitle = displayTitle.substring(0, 50) + " ...";
                        }
                        row2.addCell().addXref(url, displayTitle);
                    } else {
                        row2.addCell().addXref(url, T_untitled);
                    }
                    row2.addCell().addXref(url, collectionName);
                    Cell cell = row2.addCell();
                    cell.addContent(T_email);
                    cell.addXref("mailto:" + submitterEmail, submitterName);
                }
                catch (WorkflowConfigurationException e) {
                    Row row3 = table.addRow();
                    row3.addCell().addContent("Error: Configuration error in workflow.");
                    log.error((Object)LogManager.getHeader((Context)this.context, (String)"Error while adding owned tasks on the submissions page", (String)""), (Throwable)e);
                }
                catch (Exception e) {
                    log.error((Object)LogManager.getHeader((Context)this.context, (String)"Error while adding owned tasks on the submissions page", (String)""), (Throwable)e);
                }
            }
            if (showReturnToPoolButton) {
                row = table.addRow();
                row.addCell(0, 5).addButton("submit_return_tasks").setValue(T_w_submit_return);
            }
        } else {
            row = table.addRow();
            row.addCell(0, 5).addHighlight("italic").addContent(T_w_info2);
        }
        table = workflow.addTable("workflow-tasks", pooledItems.size() + 2, 5);
        table.setHead(T_w_head3);
        header = table.addRow("header");
        header.addCellContent(T_w_column1);
        header.addCellContent(T_w_column2);
        header.addCellContent(T_w_column3);
        header.addCellContent(T_w_column4);
        header.addCellContent(T_w_column5);
        if (pooledItems.size() > 0) {
            for (PoolTask pooled : pooledItems) {
                stepID = pooled.getStepID();
                actionID = pooled.getActionID();
                try {
                    item = pooled.getWorkflowItem();
                    wf = this.workflowFactory.getWorkflow(item.getCollection());
                    String url = this.contextPath + "/handle/" + item.getCollection().getHandle() + "/xmlworkflow?workflowID=" + item.getID() + "&stepID=" + stepID + "&actionID=" + actionID;
                    String title = item.getItem().getName();
                    String collectionName = item.getCollection().getName();
                    EPerson submitter = item.getSubmitter();
                    String submitterName = submitter.getFullName();
                    String submitterEmail = submitter.getEmail();
                    Row row4 = table.addRow();
                    CheckBox claimTask = row4.addCell().addCheckBox("workflowID");
                    claimTask.setLabel("selected");
                    claimTask.addOption(item.getID());
                    row4.addCell().addXref(url, Submissions.message((String)("xmlui.XMLWorkflow." + wf.getID() + "." + stepID + "." + actionID)));
                    if (title != null && title.length() > 0) {
                        String displayTitle = title;
                        if (displayTitle.length() > 50) {
                            displayTitle = displayTitle.substring(0, 50) + " ...";
                        }
                        row4.addCell().addXref(url, displayTitle);
                    } else {
                        row4.addCell().addXref(url, T_untitled);
                    }
                    row4.addCell().addXref(url, collectionName);
                    Cell cell = row4.addCell();
                    cell.addContent(T_email);
                    cell.addXref("mailto:" + submitterEmail, submitterName);
                }
                catch (WorkflowConfigurationException e) {
                    Row row5 = table.addRow();
                    row5.addCell().addContent("Error: Configuration error in workflow.");
                    log.error((Object)LogManager.getHeader((Context)this.context, (String)"Error while adding pooled tasks on the submissions page", (String)""), (Throwable)e);
                }
                catch (Exception e) {
                    log.error((Object)LogManager.getHeader((Context)this.context, (String)"Error while adding pooled tasks on the submissions page", (String)""), (Throwable)e);
                }
            }
            row = table.addRow();
            row.addCell(0, 5).addButton("submit_take_tasks").setValue(T_w_submit_take);
        } else {
            row = table.addRow();
            row.addCell(0, 4).addHighlight("italic").addContent(T_w_info3);
        }
    }

    private void addUnfinishedSubmissions(Division division) throws SQLException, WingException {
        division.addInteractiveDivision("unfinished-submisions", this.contextPath + "/submit", "post");
    }

    private void addSubmissionsInWorkflow(Division division) throws SQLException, WingException, AuthorizeException, IOException {
        try {
            List inprogressItems = this.xmlWorkflowItemService.findBySubmitter(this.context, this.context.getCurrentUser());
            if (inprogressItems.size() <= 0) {
                return;
            }
            Division inprogress = division.addDivision("submissions-inprogress");
            inprogress.setHead(T_p_head1);
            inprogress.addPara(T_p_info1);
            Table table = inprogress.addTable("submissions-inprogress", inprogressItems.size() + 1, 3);
            Row header = table.addRow("header");
            header.addCellContent(T_p_column1);
            header.addCellContent(T_p_column2);
            header.addCellContent(T_p_column3);
            for (XmlWorkflowItem workflowItem : inprogressItems) {
                Step step;
                Workflow wf;
                String title = workflowItem.getItem().getName();
                String collectionName = workflowItem.getCollection().getName();
                List pooltasks = this.poolTaskService.find(this.context, workflowItem);
                List claimedtasks = this.claimedTaskService.find(this.context, workflowItem);
                Message state = Submissions.message((String)"xmlui.XMLWorkflow.step.unknown");
                for (PoolTask task : pooltasks) {
                    wf = this.workflowFactory.getWorkflow(workflowItem.getCollection());
                    step = wf.getStep(task.getStepID());
                    state = Submissions.message((String)("xmlui.XMLWorkflow." + wf.getID() + "." + step.getId() + "." + task.getActionID()));
                }
                for (PoolTask task : claimedtasks) {
                    wf = this.workflowFactory.getWorkflow(workflowItem.getCollection());
                    step = wf.getStep(task.getStepID());
                    state = Submissions.message((String)("xmlui.XMLWorkflow." + wf.getID() + "." + step.getId() + "." + task.getActionID()));
                }
                Row row = table.addRow();
                if (StringUtils.isNotBlank((String)title)) {
                    String displayTitle = title;
                    if (displayTitle.length() > 50) {
                        displayTitle = displayTitle.substring(0, 50) + " ...";
                    }
                    row.addCellContent(displayTitle);
                } else {
                    row.addCellContent(T_untitled);
                }
                row.addCellContent(collectionName);
                row.addCellContent(state);
            }
        }
        catch (Exception e) {
            Row row = division.addTable("table0", 1, 1).addRow();
            row.addCell().addContent("Error: Configuration error in workflow.");
        }
    }

    private void addPreviousSubmissions(Division division) throws SQLException, WingException {
        division.addDivision("completed-submissions");
    }
}

