/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.objectmanager;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.objectmanager.AbstractAdapter;
import org.dspace.app.xmlui.objectmanager.SAXFilter;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.ItemCountException;
import org.dspace.browse.ItemCounter;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.SAXOutputter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContainerAdapter
extends AbstractAdapter {
    private static final Logger log = Logger.getLogger(ContainerAdapter.class);
    private DSpaceObject dso;
    private StringBuffer dmdSecIDS;
    private Context dspaceContext;
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();

    public ContainerAdapter(Context context, DSpaceObject dso, String contextPath) {
        super(contextPath);
        this.dso = dso;
        this.dspaceContext = context;
    }

    public DSpaceObject getContainer() {
        return this.dso;
    }

    protected String getMETSOBJID() {
        if (this.dso.getHandle() != null) {
            return this.contextPath + "/handle/" + this.dso.getHandle();
        }
        return null;
    }

    protected String getMETSOBJEDIT() {
        return null;
    }

    protected String getMETSID() {
        if (this.dso.getHandle() == null) {
            if (this.dso instanceof Collection) {
                return "collection:" + this.dso.getID();
            }
            return "community:" + this.dso.getID();
        }
        return "hdl:" + this.dso.getHandle();
    }

    protected String getMETSProfile() throws WingException {
        return "DSPACE METS SIP Profile 1.0";
    }

    protected String getMETSLabel() {
        if (this.dso instanceof Community) {
            return "DSpace Community";
        }
        return "DSpace Collection";
    }

    protected String getFileID(Bitstream bitstream) {
        return "file_" + bitstream.getID();
    }

    protected String getGroupFileID(Bitstream bitstream) {
        return "group_file_" + bitstream.getID();
    }

    protected void renderDescriptiveSection() throws WingException, SAXException, CrosswalkException, IOException, SQLException {
        AttributeMap attributes;
        String groupID = this.getGenericID("group_dmd_");
        this.dmdSecIDS = new StringBuffer();
        if (this.dmdTypes.size() == 0 || this.dmdTypes.contains("DIM")) {
            String identifier_uri;
            String description_table;
            String description_abstract;
            String description;
            String dmdID = this.getGenericID("dmd_");
            this.dmdSecIDS.append(dmdID);
            attributes = new AttributeMap();
            attributes.put((Object)"ID", (Object)dmdID);
            attributes.put((Object)"GROUPID", (Object)groupID);
            this.startElement(METS, "dmdSec", new AttributeMap[]{attributes});
            attributes = new AttributeMap();
            attributes.put((Object)"MDTYPE", (Object)"OTHER");
            attributes.put((Object)"OTHERMDTYPE", (Object)"DIM");
            this.startElement(METS, "mdWrap", new AttributeMap[]{attributes});
            this.startElement(METS, "xmlData", new AttributeMap[0]);
            attributes = new AttributeMap();
            attributes.put((Object)"dspaceType", (Object)Constants.typeText[this.dso.getType()]);
            this.startElement(DIM, "dim", new AttributeMap[]{attributes});
            if (this.dso.getType() == 3) {
                Collection collection = (Collection)this.dso;
                description = this.collectionService.getMetadata((DSpaceObject)collection, "introductory_text");
                description_abstract = this.collectionService.getMetadata((DSpaceObject)collection, "short_description");
                description_table = this.collectionService.getMetadata((DSpaceObject)collection, "side_bar_text");
                identifier_uri = "http://hdl.handle.net/" + collection.getHandle();
                String provenance = this.collectionService.getMetadata((DSpaceObject)collection, "provenance_description");
                String rights = this.collectionService.getMetadata((DSpaceObject)collection, "copyright_text");
                String rights_license = this.collectionService.getMetadata((DSpaceObject)collection, "license");
                String title = this.collectionService.getMetadata((DSpaceObject)collection, "name");
                this.createField("dc", "description", null, null, description);
                this.createField("dc", "description", "abstract", null, description_abstract);
                this.createField("dc", "description", "tableofcontents", null, description_table);
                this.createField("dc", "identifier", "uri", null, identifier_uri);
                this.createField("dc", "provenance", null, null, provenance);
                this.createField("dc", "rights", null, null, rights);
                this.createField("dc", "rights", "license", null, rights_license);
                this.createField("dc", "title", null, null, title);
                boolean showCount = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("webui.strengths.show");
                if (showCount) {
                    try {
                        int size = new ItemCounter(this.dspaceContext).getCount((DSpaceObject)collection);
                        this.createField("dc", "format", "extent", null, String.valueOf(size));
                    }
                    catch (ItemCountException e) {
                        throw new IOException("Could not obtain Collection item count", e);
                    }
                }
            } else if (this.dso.getType() == 4) {
                Community community = (Community)this.dso;
                description = this.communityService.getMetadata(community, "introductory_text");
                description_abstract = this.communityService.getMetadata(community, "short_description");
                description_table = this.communityService.getMetadata(community, "side_bar_text");
                identifier_uri = "http://hdl.handle.net/" + community.getHandle();
                String rights = this.communityService.getMetadata(community, "copyright_text");
                String title = this.communityService.getMetadata(community, "name");
                this.createField("dc", "description", null, null, description);
                this.createField("dc", "description", "abstract", null, description_abstract);
                this.createField("dc", "description", "tableofcontents", null, description_table);
                this.createField("dc", "identifier", "uri", null, identifier_uri);
                this.createField("dc", "rights", null, null, rights);
                this.createField("dc", "title", null, null, title);
                boolean showCount = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("webui.strengths.show");
                if (showCount) {
                    try {
                        int size = new ItemCounter(this.dspaceContext).getCount((DSpaceObject)community);
                        this.createField("dc", "format", "extent", null, String.valueOf(size));
                    }
                    catch (ItemCountException e) {
                        throw new IOException("Could not obtain Collection item count", e);
                    }
                }
            }
            this.endElement(DIM, "dim");
            this.endElement(METS, "xmlData");
            this.endElement(METS, "mdWrap");
            this.endElement(METS, "dmdSec");
        }
        for (String dmdType : this.dmdTypes) {
            DisseminationCrosswalk crosswalk;
            if ("DIM".equals(dmdType) || (crosswalk = this.getDisseminationCrosswalk(dmdType)) == null) continue;
            String dmdID = this.getGenericID("dmd_");
            this.dmdSecIDS.append(" ").append(dmdID);
            attributes = new AttributeMap();
            attributes.put((Object)"ID", (Object)dmdID);
            attributes.put((Object)"GROUPID", (Object)groupID);
            this.startElement(METS, "dmdSec", new AttributeMap[]{attributes});
            attributes = new AttributeMap();
            if (this.isDefinedMETStype(dmdType)) {
                attributes.put((Object)"MDTYPE", (Object)dmdType);
            } else {
                attributes.put((Object)"MDTYPE", (Object)"OTHER");
                attributes.put((Object)"OTHERMDTYPE", (Object)dmdType);
            }
            this.startElement(METS, "mdWrap", new AttributeMap[]{attributes});
            this.startElement(METS, "xmlData", new AttributeMap[0]);
            try {
                Element dissemination = crosswalk.disseminateElement(this.dspaceContext, this.dso);
                SAXFilter filter = new SAXFilter(this.contentHandler, this.lexicalHandler, this.namespaces);
                filter.allowElements().allowIgnorableWhitespace().allowCharacters().allowCDATA().allowPrefixMappings();
                SAXOutputter outputter = new SAXOutputter();
                outputter.setContentHandler((ContentHandler)filter);
                outputter.setLexicalHandler((LexicalHandler)filter);
                outputter.output(dissemination);
            }
            catch (JDOMException jdome) {
                throw new WingException((Throwable)jdome);
            }
            catch (AuthorizeException authorizeException) {
                // empty catch block
            }
            this.endElement(METS, "xmlData");
            this.endElement(METS, "mdWrap");
            this.endElement(METS, "dmdSec");
            if (this.dmdSecIDS == null) {
                this.dmdSecIDS = new StringBuffer(dmdID);
                continue;
            }
            this.dmdSecIDS.append(" ").append(dmdID);
        }
    }

    protected void renderFileSection(Context context) throws SAXException, SQLException {
        Bitstream logo = this.getLogo();
        if (logo != null) {
            this.startElement(METS, "fileSec", new AttributeMap[0]);
            AttributeMap attributes = new AttributeMap();
            attributes.put((Object)"USE", (Object)"LOGO");
            this.startElement(METS, "fileGrp", new AttributeMap[]{attributes});
            String fileID = this.getFileID(logo);
            String groupID = this.getGroupFileID(logo);
            this.renderFile(context, null, logo, fileID, groupID);
            this.endElement(METS, "fileGrp");
            this.endElement(METS, "fileSec");
        }
    }

    protected void renderStructureMap() throws SQLException, SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"TYPE", (Object)"LOGICAL");
        attributes.put((Object)"LABEL", (Object)"DSpace");
        this.startElement(METS, "structMap", new AttributeMap[]{attributes});
        attributes = new AttributeMap();
        attributes.put((Object)"TYPE", (Object)this.getMETSLabel());
        if (this.dmdSecIDS != null) {
            attributes.put((Object)"DMDID", (Object)this.dmdSecIDS.toString());
        }
        this.startElement(METS, "div", new AttributeMap[]{attributes});
        Bitstream logo = this.getLogo();
        if (logo != null) {
            attributes = new AttributeMap();
            attributes.put((Object)"FILEID", (Object)this.getFileID(logo));
            this.startElement(METS, "fptr", new AttributeMap[]{attributes});
            this.endElement(METS, "fptr");
            attributes = new AttributeMap();
            attributes.put((Object)"ID", (Object)this.getGenericID("div_"));
            attributes.put((Object)"TYPE", (Object)"DSpace Content Bitstream");
            this.startElement(METS, "div", new AttributeMap[]{attributes});
            attributes = new AttributeMap();
            attributes.put((Object)"FILEID", (Object)this.getFileID(logo));
            this.startElement(METS, "fptr", new AttributeMap[]{attributes});
            this.endElement(METS, "fptr");
            this.endElement(METS, "div");
        }
        this.endElement(METS, "div");
        this.endElement(METS, "structMap");
    }

    private Bitstream getLogo() {
        if (this.dso instanceof Community) {
            Community community = (Community)this.dso;
            return community.getLogo();
        }
        if (this.dso instanceof Collection) {
            Collection collection = (Collection)this.dso;
            return collection.getLogo();
        }
        return null;
    }

    private int countOccurences(String string, char character) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int fromIndex = -1;
        int count = 0;
        while ((fromIndex = string.indexOf(62, fromIndex + 1)) != -1) {
            ++count;
        }
        return count;
    }

    private boolean substringCompare(String string, int index, char ... characters) {
        if (string.length() <= index + characters.length) {
            return false;
        }
        for (char character : characters) {
            if (string.charAt(index) != character) {
                return false;
            }
            ++index;
        }
        return false;
    }

    private void createField(String schema, String element, String qualifier, String language, String value) throws SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"mdschema", (Object)schema);
        attributes.put((Object)"element", (Object)element);
        if (qualifier != null) {
            attributes.put((Object)"qualifier", (Object)qualifier);
        }
        if (language != null) {
            attributes.put((Object)"language", (Object)language);
        }
        this.startElement(DIM, "field", new AttributeMap[]{attributes});
        if (value != null) {
            int countOpen = this.countOccurences(value, '<');
            int countClose = this.countOccurences(value, '>');
            Element xmlDocument = null;
            if (countOpen > 0 && countOpen == countClose) {
                int amp = -1;
                while ((amp = value.indexOf(38, amp + 1)) > -1) {
                    if (this.substringCompare(value, amp + 1, new char[]{'#'}) || this.substringCompare(value, amp + 1, new char[]{'a', 'm', 'p', ';'}) || this.substringCompare(value, amp + 1, new char[]{'a', 'p', 'o', 's', ';'}) || this.substringCompare(value, amp + 1, new char[]{'q', 'u', 'o', 't', ';'}) || this.substringCompare(value, amp + 1, new char[]{'l', 't', ';'}) || this.substringCompare(value, amp + 1, new char[]{'g', 't', ';'})) continue;
                    value = value.substring(0, amp) + "&amp;" + value.substring(amp + 1);
                }
                try {
                    String xml = "<?xml version='1.0' encoding='UTF-8'?><fragment xmlns=\"http://www.w3.org/1999/xhtml\">" + value + "</fragment>";
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                    SAXBuilder builder = new SAXBuilder();
                    Document document = builder.build((InputStream)inputStream);
                    xmlDocument = document.getRootElement();
                }
                catch (Exception e) {
                    log.trace((Object)"Caught exception", (Throwable)e);
                }
            }
            if (xmlDocument != null) {
                SAXFilter filter = new SAXFilter(this.contentHandler, this.lexicalHandler, this.namespaces);
                filter.allowElements().allowIgnorableWhitespace().allowCharacters().allowCDATA().allowPrefixMappings();
                filter.allowElements(1);
                SAXOutputter outputter = new SAXOutputter();
                outputter.setContentHandler((ContentHandler)filter);
                outputter.setLexicalHandler((LexicalHandler)filter);
                try {
                    outputter.output(xmlDocument);
                }
                catch (JDOMException jdome) {
                    this.sendCharacters(value);
                }
            } else {
                this.sendCharacters(value);
            }
        }
        this.endElement(DIM, "field");
    }
}

