/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.opensearch;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.ExpiresValidity;
import org.dspace.app.util.factory.UtilServiceFactory;
import org.dspace.app.util.service.OpenSearchService;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbstractOpenSearchGenerator
extends AbstractGenerator
implements CacheableProcessingComponent,
Recyclable {
    private ExpiresValidity validity = null;
    protected String format = null;
    protected String query = null;
    protected DSpaceObject scope = null;
    protected SortOption sort = null;
    protected String sortOrder = null;
    protected int rpp = 0;
    protected int start = 1;
    protected Document resultsDoc = null;
    public static int DEFAULT_RPP = 20;
    public static int MAX_RPP = 100;
    protected OpenSearchService openSearchService = UtilServiceFactory.getInstance().getOpenSearchService();

    public Serializable getKey() {
        StringBuffer key = new StringBuffer("key:");
        key.append(this.getClass().getName());
        if (this.scope != null) {
            key.append(this.scope.getHandle());
        }
        key.append(this.query);
        if (this.format != null) {
            key.append(this.format);
        }
        if (this.sort != null) {
            key.append(this.sort.getNumber());
        }
        key.append(this.start);
        key.append(this.rpp);
        key.append(this.sortOrder);
        return Long.valueOf(HashUtil.hash((String)key.toString()));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            long expiry = DSpaceServicesFactory.getInstance().getConfigurationService().getLongProperty("websvc.opensearch.validity") * 60L * 60L * 1000L;
            this.validity = new ExpiresValidity(expiry);
        }
        return this.validity;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        Context context = null;
        try {
            context = ContextUtil.obtainContext((Map)objectModel);
        }
        catch (SQLException e) {
            throw new ProcessingException("Couldn't get DSpace Context object", (Throwable)e);
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        this.query = request.getParameter("query");
        if (this.query == null) {
            this.query = "";
        }
        this.query = URLDecoder.decode(this.query, "UTF-8");
        this.format = request.getParameter("format");
        if (this.format == null || this.format.length() == 0 || !this.openSearchService.getFormats().contains(this.format)) {
            this.format = "atom";
        }
        String scopeParam = request.getParameter("scope");
        try {
            this.scope = this.openSearchService.resolveScope(context, scopeParam);
        }
        catch (SQLException e) {
            throw new ProcessingException("Error resolving scope handle param " + scopeParam, (Throwable)e);
        }
        String srt = request.getParameter("sort_by");
        int sortValue = -1;
        try {
            if (srt != null && srt.length() > 0) {
                sortValue = Integer.valueOf(srt);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.sort = SortOption.getSortOption((int)sortValue);
        }
        catch (SortException e) {
            throw new ProcessingException("Error obtaining SortOptions", (Throwable)e);
        }
        if (this.sort != null) {
            String order = request.getParameter("order");
            this.sortOrder = order == null || order.length() == 0 || order.toLowerCase().startsWith("asc") ? "ASC" : "DESC";
        }
        String st = request.getParameter("start");
        try {
            int n = this.start = st == null || st.length() == 0 ? 0 : Integer.valueOf(st);
            if (this.start < 1) {
                this.start = 1;
            }
        }
        catch (NumberFormatException e) {
            this.start = 1;
        }
        String pp = request.getParameter("rpp");
        try {
            int n = this.rpp = pp == null || pp.length() == 0 ? DEFAULT_RPP : Integer.valueOf(pp);
            if (this.rpp <= 0 || this.rpp > MAX_RPP) {
                this.rpp = DEFAULT_RPP;
            }
        }
        catch (NumberFormatException e) {
            this.rpp = DEFAULT_RPP;
        }
    }

    public void recycle() {
        this.format = null;
        this.query = null;
        this.scope = null;
        this.sort = null;
        this.rpp = 0;
        this.start = 1;
        this.sortOrder = null;
        this.resultsDoc = null;
        this.validity = null;
        super.recycle();
    }
}

