/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.springmvc;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;

public class BibTexView
implements View {
    private static final Logger LOGGER = LoggerFactory.getLogger(BibTexView.class);
    private static final String EOL = "\r\n";
    private String resourceIdentifier = null;
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public String getContentType() {
        return "text/plain;charset=utf-8";
    }

    public BibTexView(String resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DSpaceObject item = (DSpaceObject)request.getAttribute("dspace.object");
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        String fileName = this.getFileName(item);
        this.write(response, this.getBibTex((Item)item, this.resourceIdentifier), fileName);
        ServletOutputStream aOutputStream = response.getOutputStream();
        aOutputStream.close();
    }

    private void write(HttpServletResponse aResponse, String aContent, String aFileName) throws IOException {
        aResponse.setContentType("text/plain;charset=utf-8");
        aResponse.setContentLength(aContent.length());
        aResponse.setHeader("Content-Disposition", "attachment; filename=\"" + aFileName + "\"");
        PrintWriter writer = aResponse.getWriter();
        writer.print(aContent);
        writer.close();
    }

    private String getFileName(DSpaceObject item) {
        String fileName = this.resourceIdentifier;
        if (this.resourceIdentifier.lastIndexOf("/") != -1) {
            fileName = this.resourceIdentifier.replaceAll("/", "_") + ".bib";
        }
        return fileName;
    }

    private String getBibTex(Item item, String resourceIdentifier) {
        StringBuilder builder = new StringBuilder("@misc{");
        String[] authors = this.getAuthors(item);
        String year = this.getYear(item);
        String title = this.getMetadataValue(item, "dc.title");
        builder.append(resourceIdentifier).append(',').append(EOL);
        if (title != null) {
            builder.append("  title = {").append(title).append("},");
            builder.append(EOL);
        }
        if (authors.length > 0) {
            builder.append("  author = {");
            for (int index = 0; index < authors.length; ++index) {
                if (index + 1 >= authors.length) {
                    builder.append(authors[index].replace(" ", ", "));
                    continue;
                }
                if (index + 1 >= authors.length) continue;
                builder.append(authors[index].replace(" ", ", "));
                builder.append(" and ");
            }
            builder.append("},").append(EOL);
        }
        if (year != null) {
            builder.append("  year = {").append(year).append("},").append(EOL);
        }
        return builder.append("}").append(EOL).toString();
    }

    private String getMetadataValue(Item item, String metadatafield) {
        Iterator i$ = this.itemService.getMetadataByMetadataString((DSpaceObject)item, metadatafield).iterator();
        if (i$.hasNext()) {
            MetadataValue value = (MetadataValue)i$.next();
            return value.getValue();
        }
        return null;
    }

    private String[] getAuthors(Item aItem) {
        ArrayList authors = new ArrayList();
        authors.addAll(this.getAuthors(this.itemService.getMetadataByMetadataString((DSpaceObject)aItem, "dc.contributor.author")));
        authors.addAll(this.getAuthors(this.itemService.getMetadataByMetadataString((DSpaceObject)aItem, "dc.creator")));
        authors.addAll(this.getAuthors(this.itemService.getMetadataByMetadataString((DSpaceObject)aItem, "dc.contributor")));
        return authors.toArray(new String[authors.size()]);
    }

    private String getYear(Item aItem) {
        Iterator i$ = this.itemService.getMetadataByMetadataString((DSpaceObject)aItem, "dc.date.issued").iterator();
        if (i$.hasNext()) {
            MetadataValue date = (MetadataValue)i$.next();
            return date.getValue().substring(0, 4);
        }
        return null;
    }

    private List<String> getAuthors(List<MetadataValue> aMetadata) {
        ArrayList<String> authors = new ArrayList<String>();
        for (MetadataValue metadata : aMetadata) {
            String[] parts;
            StringBuilder builder = new StringBuilder();
            if (metadata.getValue().indexOf(",") != -1) {
                parts = metadata.getValue().split(",");
                if (parts.length > 1) {
                    StringTokenizer tokenizer = new StringTokenizer(parts[1], ". ");
                    builder.append(parts[0]).append(" ");
                    while (tokenizer.hasMoreTokens()) {
                        builder.append(tokenizer.nextToken().charAt(0));
                    }
                } else {
                    builder.append(metadata.getValue());
                }
                authors.add(builder.toString());
                continue;
            }
            parts = metadata.getValue().split("\\s+|\\.");
            String name = parts[parts.length - 1].replace("\\s+|\\.", "");
            builder.append(name).append(" ");
            for (int index = 0; index < parts.length - 1; ++index) {
                if (parts[index].length() <= 0) continue;
                name = parts[index].replace("\\s+|\\.", "");
                builder.append(name.charAt(0));
            }
        }
        return authors;
    }
}

