/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.administrative.controlpanel.AbstractControlPanelTab;
import org.dspace.app.xmlui.aspect.administrative.controlpanel.ControlPanelTab;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ControlPanel
extends AbstractDSpaceTransformer
implements Serviceable,
Disposable {
    private static final Logger log = Logger.getLogger(ControlPanel.class);
    private static final Message T_DSPACE_HOME = ControlPanel.message((String)"xmlui.general.dspace_home");
    private static final Message T_title = ControlPanel.message((String)"xmlui.administrative.ControlPanel.title");
    private static final Message T_trail = ControlPanel.message((String)"xmlui.administrative.ControlPanel.trail");
    private static final Message T_head = ControlPanel.message((String)"xmlui.administrative.ControlPanel.head");
    private static final Message T_select_panel = ControlPanel.message((String)"xmlui.administrative.ControlPanel.select_panel");
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private ServiceManager serviceManager;
    private Settings settings;
    private StoreJanitor storeJanitor;
    private Store storeDefault;
    private Store storePersistent;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
        this.settings = (Settings)this.serviceManager.lookup(Settings.ROLE);
        if (this.serviceManager.hasService(StoreJanitor.ROLE)) {
            this.storeJanitor = (StoreJanitor)this.serviceManager.lookup(StoreJanitor.ROLE);
        }
        if (this.serviceManager.hasService(Store.ROLE)) {
            this.storeDefault = (Store)this.serviceManager.lookup(Store.ROLE);
        }
        if (this.serviceManager.hasService(Store.PERSISTENT_STORE)) {
            this.storePersistent = (Store)this.serviceManager.lookup(Store.PERSISTENT_STORE);
        }
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_DSPACE_HOME);
        pageMeta.addTrailLink(null, T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String[] tabs;
        if (!this.authorizeService.isAdmin(this.context)) {
            throw new AuthorizeException("You are not authorized to view this page.");
        }
        Division div = body.addInteractiveDivision("control-panel", this.contextPath + "/admin/panel", "post", "primary administrative");
        div.setHead(T_head);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String selected_tab = "";
        if (request.getParameter("tab") != null) {
            selected_tab = request.getParameter("tab");
            div.addHidden("tab").setValue(selected_tab);
        }
        List options = div.addList("options", "simple", "horizontal");
        for (String tab : tabs = this.configurationService.getArrayProperty("controlpanel.tabs")) {
            tab = tab.trim();
            Message linkText = ControlPanel.message((String)("xmlui.administrative.ControlPanel.tabs." + tab));
            if (tab.equals(selected_tab)) {
                options.addItem().addHighlight("bold").addXref("?tab=" + selected_tab, linkText);
                continue;
            }
            options.addItemXref(this.contextPath + "/admin/panel?tab=" + tab, linkText);
        }
        if (selected_tab.equals("")) {
            div.addPara(T_select_panel);
        } else {
            ControlPanelTab cpTab = (ControlPanelTab)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(ControlPanelTab.class, selected_tab);
            if (cpTab instanceof AbstractControlPanelTab) {
                try {
                    ((AbstractControlPanelTab)cpTab).setup(null, this.objectModel, null, this.parameters);
                    ((AbstractControlPanelTab)cpTab).service(this.serviceManager);
                    ((AbstractControlPanelTab)cpTab).setWebLink(this.contextPath + "/admin/panel?tab=" + selected_tab);
                }
                catch (ServiceException e) {
                    log.error((Object)e);
                }
                catch (ProcessingException e) {
                    log.error((Object)e);
                }
            }
            cpTab.addBody(this.objectModel, div);
        }
    }

    public void dispose() {
        if (this.serviceManager != null) {
            this.serviceManager.release((Object)this.storePersistent);
            this.serviceManager.release((Object)this.storeJanitor);
            this.serviceManager.release((Object)this.storeDefault);
            this.serviceManager.release((Object)this.settings);
            this.storePersistent = null;
            this.storeJanitor = null;
            this.storeDefault = null;
            this.settings = null;
        }
        super.dispose();
    }
}

