/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.aspect.administrative.FlowCurationUtils;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.browse.BrowseException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.curate.Curator;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.harvest.HarvestScheduler;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.OAIHarvester;
import org.dspace.harvest.factory.HarvestServiceFactory;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.WorkflowUtils;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowContainerUtils {
    public static final String ROLE_ADMIN = "ADMIN";
    public static final String ROLE_WF_STEP1 = "WF_STEP1";
    public static final String ROLE_WF_STEP2 = "WF_STEP2";
    public static final String ROLE_WF_STEP3 = "WF_STEP3";
    public static final String ROLE_SUBMIT = "SUBMIT";
    public static final String ROLE_DEFAULT_READ = "DEFAULT_READ";
    protected static final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected static final ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    protected static final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected static final GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected static final HarvestedCollectionService harvestedCollectionService = HarvestServiceFactory.getInstance().getHarvestedCollectionService();
    protected static final WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();

    public static FlowResult processEditCollection(Context context, UUID collectionID, boolean deleteLogo, Request request) throws SQLException, IOException, AuthorizeException {
        FlowResult result = new FlowResult();
        Collection collection = (Collection)collectionService.find(context, collectionID);
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        String license = request.getParameter("license");
        String provenanceDescription = request.getParameter("provenance_description");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        if (license != null && license.length() == 0) {
            license = null;
        }
        if (provenanceDescription != null && provenanceDescription.length() == 0) {
            provenanceDescription = null;
        }
        collectionService.setMetadata(context, collection, "name", name);
        collectionService.setMetadata(context, collection, "short_description", shortDescription);
        collectionService.setMetadata(context, collection, "introductory_text", introductoryText);
        collectionService.setMetadata(context, collection, "copyright_text", copyrightText);
        collectionService.setMetadata(context, collection, "side_bar_text", sideBarText);
        collectionService.setMetadata(context, collection, "license", license);
        collectionService.setMetadata(context, collection, "provenance_description", provenanceDescription);
        if (deleteLogo) {
            collectionService.setLogo(context, collection, null);
        } else {
            Object object = request.get("logo");
            Part filePart = null;
            if (object instanceof Part) {
                filePart = (Part)object;
            }
            if (filePart != null && filePart.getSize() > 0) {
                InputStream is = filePart.getInputStream();
                collectionService.setLogo(context, collection, is);
            }
        }
        collectionService.update(context, (DSpaceObject)collection);
        result.setContinue(true);
        return result;
    }

    public static FlowResult processSetupCollectionHarvesting(Context context, UUID collectionID, Request request) throws SQLException, IOException, AuthorizeException {
        FlowResult result = new FlowResult();
        Collection collection = (Collection)collectionService.find(context, collectionID);
        HarvestedCollection hc = harvestedCollectionService.find(context, collection);
        String contentSource = request.getParameter("source");
        if (contentSource.equals("source_normal")) {
            if (hc != null) {
                harvestedCollectionService.delete(context, hc);
            }
            result.setContinue(true);
        } else {
            FlowResult subResult = FlowContainerUtils.testOAISettings((Context)context, (Request)request);
            if (hc == null) {
                hc = harvestedCollectionService.create(context, collection);
            }
            if (!subResult.getErrors().isEmpty()) {
                result.setErrors(subResult.getErrors());
                result.setContinue(false);
                return result;
            }
            String oaiProvider = request.getParameter("oai_provider");
            boolean oaiAllSets = "all".equals(request.getParameter("oai-set-setting"));
            String oaiSetId = oaiAllSets ? "all" : request.getParameter("oai_setid");
            String metadataKey = request.getParameter("metadata_format");
            String harvestType = request.getParameter("harvest_level");
            hc.setHarvestParams(Integer.parseInt(harvestType), oaiProvider, oaiSetId, metadataKey);
            hc.setHarvestStatus(0);
            harvestedCollectionService.update(context, hc);
        }
        result.setOutcome(true);
        result.setContinue(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlowResult processRunCollectionHarvest(Context context, UUID collectionID, Request request) throws SQLException, IOException, AuthorizeException, CrosswalkException, ParserConfigurationException, SAXException, TransformerException {
        FlowResult result;
        block6: {
            result = new FlowResult();
            ArrayList<String> testErrors = new ArrayList<String>();
            Collection collection = (Collection)collectionService.find(context, collectionID);
            HarvestedCollection hc = harvestedCollectionService.find(context, collection);
            try {
                if (!HarvestScheduler.hasStatus((int)4)) {
                    Object object = HarvestScheduler.lock;
                    synchronized (object) {
                        HarvestScheduler.setInterrupt((int)4, (UUID)collectionID);
                        HarvestScheduler.lock.notify();
                        break block6;
                    }
                }
                OAIHarvester harvester = new OAIHarvester(context, (DSpaceObject)collection, hc);
                harvester.runHarvest();
            }
            catch (Exception e) {
                testErrors.add(e.getMessage());
                result.setErrors(testErrors);
                result.setContinue(false);
                return result;
            }
        }
        result.setContinue(true);
        return result;
    }

    public static FlowResult processReimportCollection(Context context, UUID collectionID, Request request) throws SQLException, IOException, AuthorizeException, CrosswalkException, ParserConfigurationException, SAXException, TransformerException, BrowseException {
        boolean originalMode = context.isBatchModeEnabled();
        context.enableBatchMode(true);
        Collection collection = (Collection)collectionService.find(context, collectionID);
        HarvestedCollection hc = harvestedCollectionService.find(context, collection);
        Iterator it = itemService.findByCollection(context, collection);
        while (it.hasNext()) {
            Item item = (Item)it.next();
            collectionService.removeItem(context, collection, item);
        }
        hc.setLastHarvested(null);
        hc.setHarvestMessage("");
        harvestedCollectionService.update(context, hc);
        collectionService.update(context, (DSpaceObject)collection);
        context.enableBatchMode(originalMode);
        return FlowContainerUtils.processRunCollectionHarvest((Context)context, (UUID)collectionID, (Request)request);
    }

    public static FlowResult testOAISettings(Context context, Request request) {
        FlowResult result = new FlowResult();
        String oaiProvider = request.getParameter("oai_provider");
        String oaiSetId = request.getParameter("oai_setid");
        oaiSetId = request.getParameter("oai-set-setting");
        if (!"all".equals(oaiSetId)) {
            oaiSetId = request.getParameter("oai_setid");
        }
        String metadataKey = request.getParameter("metadata_format");
        String harvestType = request.getParameter("harvest_level");
        int harvestTypeInt = 0;
        if (oaiProvider == null || oaiProvider.length() == 0) {
            result.addError("oai_provider");
        }
        if (oaiSetId == null || oaiSetId.length() == 0) {
            result.addError("oai_setid");
        }
        if (metadataKey == null || metadataKey.length() == 0) {
            result.addError("metadata_format");
        }
        if (harvestType == null || harvestType.length() == 0) {
            result.addError("harvest_level");
        } else {
            harvestTypeInt = Integer.parseInt(harvestType);
        }
        if (result.getErrors() == null) {
            List testErrors = OAIHarvester.verifyOAIharvester((String)oaiProvider, (String)oaiSetId, (String)metadataKey, (harvestTypeInt > 1 ? 1 : 0) != 0);
            result.setErrors(testErrors);
        }
        if (result.getErrors() == null || result.getErrors().isEmpty()) {
            result.setOutcome(true);
            result.setMessage(new Message("default", "Harvesting settings are valid."));
        } else {
            result.setOutcome(false);
            result.setContinue(false);
        }
        return result;
    }

    public static UUID getTemplateItemID(Context context, UUID collectionID) throws SQLException, AuthorizeException, IOException {
        Collection collection = (Collection)collectionService.find(context, collectionID);
        Item template = collection.getTemplateItem();
        if (template == null) {
            collectionService.createTemplateItem(context, collection);
            template = collection.getTemplateItem();
            collectionService.update(context, (DSpaceObject)collection);
            itemService.update(context, (DSpaceObject)template);
        }
        return template.getID();
    }

    public static UUID getCollectionRole(Context context, UUID collectionID, String roleName) throws SQLException, AuthorizeException, IOException, TransformerException, SAXException, WorkflowConfigurationException, ParserConfigurationException, WorkflowException {
        Collection collection = (Collection)collectionService.find(context, collectionID);
        Group roleGroup = null;
        if ("ADMIN".equals(roleName)) {
            roleGroup = collection.getAdministrators();
            if (roleGroup == null) {
                roleGroup = collectionService.createAdministrators(context, collection);
            }
        } else if ("SUBMIT".equals(roleName)) {
            roleGroup = collection.getSubmitters();
            if (roleGroup == null) {
                roleGroup = collectionService.createSubmitters(context, collection);
            }
        } else {
            roleGroup = workflowService.getWorkflowRoleGroup(context, collection, roleName, roleGroup);
        }
        collectionService.update(context, (DSpaceObject)collection);
        if (roleGroup != null) {
            return roleGroup.getID();
        }
        return null;
    }

    public static FlowResult processDeleteCollectionRole(Context context, UUID collectionID, String roleName, UUID groupID) throws SQLException, UIException, IOException, AuthorizeException, WorkflowConfigurationException {
        FlowResult result = new FlowResult();
        Collection collection = (Collection)collectionService.find(context, collectionID);
        Group role = (Group)groupService.find(context, groupID);
        if ("ADMIN".equals(roleName)) {
            collectionService.removeAdministrators(context, collection);
        } else if ("SUBMIT".equals(roleName)) {
            collectionService.removeSubmitters(context, collection);
        } else if (StringUtils.equals((String)DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("workflow.framework"), (String)"xmlworkflow")) {
            WorkflowUtils.deleteRoleGroup((Context)context, (Collection)collection, (String)roleName);
        } else if ("WF_STEP1".equals(roleName)) {
            collection.setWorkflowGroup(1, null);
        } else if ("WF_STEP2".equals(roleName)) {
            collection.setWorkflowGroup(2, null);
        } else if ("WF_STEP3".equals(roleName)) {
            collection.setWorkflowGroup(3, null);
        }
        List policies = authorizeService.getPolicies(context, (DSpaceObject)collection);
        for (ResourcePolicy policy : policies) {
            if (policy.getGroup() == null || !policy.getGroup().getID().equals(groupID)) continue;
            resourcePolicyService.delete(context, (Object)policy);
        }
        collectionService.update(context, (DSpaceObject)collection);
        groupService.delete(context, (DSpaceObject)role);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The role was successfully deleted."));
        return result;
    }

    public static Group getCollectionDefaultRead(Context context, Collection collection) throws SQLException, AuthorizeException {
        List itemGroups = authorizeService.getAuthorizedGroups(context, (DSpaceObject)collection, 10);
        List bitstreamGroups = authorizeService.getAuthorizedGroups(context, (DSpaceObject)collection, 9);
        Group itemGroup = null;
        if (itemGroups.size() != 1 || bitstreamGroups.size() != 1) {
            itemGroup = null;
        } else {
            itemGroup = (Group)itemGroups.get(0);
            Group bitstreamGroup = (Group)bitstreamGroups.get(0);
            if (!itemGroup.getID().equals(bitstreamGroup.getID())) {
                itemGroup = null;
            }
        }
        return itemGroup;
    }

    public static UUID createCollectionDefaultReadGroup(Context context, UUID collectionID) throws SQLException, AuthorizeException, UIException {
        Collection collection = (Collection)collectionService.find(context, collectionID);
        Group defaultRead = FlowContainerUtils.getCollectionDefaultRead((Context)context, (Collection)collection);
        if (defaultRead != null && !defaultRead.getName().equals("Anonymous")) {
            throw new UIException("Unable to create a new default read group because either the group already exists or multiple groups are assigned the default privileges.");
        }
        Group role = groupService.create(context);
        groupService.setName(role, "COLLECTION_" + collection.getID().toString() + "_DEFAULT_READ");
        authorizeService.removePoliciesActionFilter(context, (DSpaceObject)collection, 10);
        authorizeService.removePoliciesActionFilter(context, (DSpaceObject)collection, 9);
        authorizeService.addPolicy(context, (DSpaceObject)collection, 10, role);
        authorizeService.addPolicy(context, (DSpaceObject)collection, 9, role);
        groupService.update(context, (DSpaceObject)role);
        return role.getID();
    }

    public static FlowResult changeCollectionDefaultReadToAnonymous(Context context, UUID collectionID) throws SQLException, AuthorizeException, UIException, IOException {
        FlowResult result = new FlowResult();
        Collection collection = (Collection)collectionService.find(context, collectionID);
        Group defaultRead = FlowContainerUtils.getCollectionDefaultRead((Context)context, (Collection)collection);
        if (defaultRead == null || defaultRead.getName().equals("Anonymous")) {
            throw new UIException("Unable to delete the default read role because the role is either already assigned to the anonymous group or multiple groups are assigned the default privileges.");
        }
        Group anonymous = groupService.findByName(context, "Anonymous");
        groupService.delete(context, (DSpaceObject)defaultRead);
        authorizeService.addPolicy(context, (DSpaceObject)collection, 10, anonymous);
        authorizeService.addPolicy(context, (DSpaceObject)collection, 9, anonymous);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "All new items submitted to this collection will default to anonymous read."));
        return result;
    }

    public static FlowResult processDeleteCollection(Context context, UUID collectionID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        Collection collection = (Collection)collectionService.find(context, collectionID);
        collectionService.delete(context, (DSpaceObject)collection);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The collection was successfully deleted."));
        return result;
    }

    public static FlowResult processCreateCollection(Context context, UUID communityID, Request request) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        Community parent = (Community)communityService.find(context, communityID);
        Collection newCollection = collectionService.create(context, parent);
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        String license = request.getParameter("license");
        String provenanceDescription = request.getParameter("provenance_description");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        if (license != null && license.length() == 0) {
            license = null;
        }
        if (provenanceDescription != null && provenanceDescription.length() == 0) {
            provenanceDescription = null;
        }
        collectionService.setMetadata(context, newCollection, "name", name);
        collectionService.setMetadata(context, newCollection, "short_description", shortDescription);
        collectionService.setMetadata(context, newCollection, "introductory_text", introductoryText);
        collectionService.setMetadata(context, newCollection, "copyright_text", copyrightText);
        collectionService.setMetadata(context, newCollection, "side_bar_text", sideBarText);
        collectionService.setMetadata(context, newCollection, "license", license);
        collectionService.setMetadata(context, newCollection, "provenance_description", provenanceDescription);
        Object object = request.get("logo");
        Part filePart = null;
        if (object instanceof Part) {
            filePart = (Part)object;
        }
        if (filePart != null && filePart.getSize() > 0) {
            InputStream is = filePart.getInputStream();
            collectionService.setLogo(context, newCollection, is);
        }
        collectionService.update(context, (DSpaceObject)newCollection);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The collection was successfully created."));
        result.setParameter("collectionID", (Object)newCollection.getID());
        return result;
    }

    public static FlowResult processCreateCommunity(Context context, UUID communityID, Request request) throws AuthorizeException, IOException, SQLException {
        FlowResult result = new FlowResult();
        Community newCommunity = communityID != null ? communityService.createSubcommunity(context, (Community)communityService.find(context, communityID)) : communityService.create(null, context);
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        communityService.setMetadata(context, newCommunity, "name", name);
        communityService.setMetadata(context, newCommunity, "short_description", shortDescription);
        communityService.setMetadata(context, newCommunity, "introductory_text", introductoryText);
        communityService.setMetadata(context, newCommunity, "copyright_text", copyrightText);
        communityService.setMetadata(context, newCommunity, "side_bar_text", sideBarText);
        Object object = request.get("logo");
        Part filePart = null;
        if (object instanceof Part) {
            filePart = (Part)object;
        }
        if (filePart != null && filePart.getSize() > 0) {
            InputStream is = filePart.getInputStream();
            communityService.setLogo(context, newCommunity, is);
        }
        communityService.update(context, (DSpaceObject)newCommunity);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The community was successfully created."));
        result.setParameter("communityID", (Object)newCommunity.getID());
        return result;
    }

    public static FlowResult processEditCommunity(Context context, UUID communityID, boolean deleteLogo, Request request) throws AuthorizeException, IOException, SQLException {
        FlowResult result = new FlowResult();
        Community community = (Community)communityService.find(context, communityID);
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        communityService.setMetadata(context, community, "name", name);
        communityService.setMetadata(context, community, "short_description", shortDescription);
        communityService.setMetadata(context, community, "introductory_text", introductoryText);
        communityService.setMetadata(context, community, "copyright_text", copyrightText);
        communityService.setMetadata(context, community, "side_bar_text", sideBarText);
        if (deleteLogo) {
            communityService.setLogo(context, community, null);
        } else {
            Object object = request.get("logo");
            Part filePart = null;
            if (object instanceof Part) {
                filePart = (Part)object;
            }
            if (filePart != null && filePart.getSize() > 0) {
                InputStream is = filePart.getInputStream();
                communityService.setLogo(context, community, is);
            }
        }
        communityService.update(context, (DSpaceObject)community);
        result.setContinue(true);
        return result;
    }

    public static FlowResult processDeleteCommunity(Context context, UUID communityID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        Community community = (Community)communityService.find(context, communityID);
        communityService.delete(context, (DSpaceObject)community);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The community was successfully deleted."));
        return result;
    }

    public static UUID getCommunityRole(Context context, UUID communityID, String roleName) throws SQLException, AuthorizeException, IOException {
        Community community = (Community)communityService.find(context, communityID);
        Group role = null;
        if ("ADMIN".equals(roleName) && (role = community.getAdministrators()) == null) {
            role = communityService.createAdministrators(context, community);
        }
        communityService.update(context, (DSpaceObject)community);
        if (role != null) {
            return role.getID();
        }
        return null;
    }

    public static FlowResult processDeleteCommunityRole(Context context, UUID communityID, String roleName, UUID groupID) throws SQLException, UIException, IOException, AuthorizeException {
        FlowResult result = new FlowResult();
        Community community = (Community)communityService.find(context, communityID);
        Group role = (Group)groupService.find(context, groupID);
        if ("ADMIN".equals(roleName)) {
            communityService.removeAdministrators(context, community);
        }
        List policies = authorizeService.getPolicies(context, (DSpaceObject)community);
        for (ResourcePolicy policy : policies) {
            if (policy.getGroup() == null || !policy.getGroup().getID().equals(groupID)) continue;
            resourcePolicyService.delete(context, (Object)policy);
        }
        communityService.update(context, (DSpaceObject)community);
        groupService.delete(context, (DSpaceObject)role);
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The role was successfully deleted."));
        return result;
    }

    public static FlowResult processDeleteTemplateItem(Context context, UUID collectionID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        Collection collection = (Collection)collectionService.find(context, collectionID);
        collectionService.removeTemplateItem(context, collection);
        result.setContinue(true);
        result.setOutcome(true);
        return result;
    }

    public static FlowResult processCurateCollection(Context context, UUID dsoID, Request request) throws AuthorizeException, IOException, SQLException, Exception {
        String task = request.getParameter("curate_task");
        Curator curator = FlowCurationUtils.getCurator((String)task);
        try {
            Collection collection = (Collection)collectionService.find(context, dsoID);
            if (collection != null) {
                curator.curate(context, collection.getHandle());
            }
            return FlowCurationUtils.getRunFlowResult((String)task, (Curator)curator, (boolean)true);
        }
        catch (Exception e) {
            curator.setResult(task, e.getMessage());
            return FlowCurationUtils.getRunFlowResult((String)task, (Curator)curator, (boolean)false);
        }
    }

    public static FlowResult processQueueCollection(Context context, UUID dsoID, Request request) throws AuthorizeException, IOException, SQLException, Exception {
        String task = request.getParameter("curate_task");
        Curator curator = FlowCurationUtils.getCurator((String)task);
        String objId = String.valueOf(dsoID);
        String taskQueueName = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("curate.ui.queuename");
        boolean status = false;
        Collection collection = (Collection)collectionService.find(context, dsoID);
        if (collection != null) {
            objId = collection.getHandle();
            try {
                curator.queue(context, objId, taskQueueName);
                status = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return FlowCurationUtils.getQueueFlowResult((String)task, (boolean)status, (String)objId, (String)taskQueueName);
    }

    public static FlowResult processCurateCommunity(Context context, UUID dsoID, Request request) throws AuthorizeException, IOException, SQLException, Exception {
        String task = request.getParameter("curate_task");
        Curator curator = FlowCurationUtils.getCurator((String)task);
        try {
            Community community = (Community)communityService.find(context, dsoID);
            if (community != null) {
                curator.curate(context, community.getHandle());
            }
            return FlowCurationUtils.getRunFlowResult((String)task, (Curator)curator, (boolean)true);
        }
        catch (Exception e) {
            curator.setResult(task, e.getMessage());
            return FlowCurationUtils.getRunFlowResult((String)task, (Curator)curator, (boolean)false);
        }
    }

    public static FlowResult processQueueCommunity(Context context, UUID dsoID, Request request) throws AuthorizeException, IOException, SQLException, Exception {
        String task = request.getParameter("curate_task");
        Curator curator = FlowCurationUtils.getCurator((String)task);
        String objId = String.valueOf(dsoID);
        String taskQueueName = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("curate.ui.queuename");
        boolean status = false;
        Community community = (Community)communityService.find(context, dsoID);
        if (community != null) {
            objId = community.getHandle();
            try {
                curator.queue(context, objId, taskQueueName);
                status = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return FlowCurationUtils.getQueueFlowResult((String)task, (boolean)status, (String)objId, (String)taskQueueName);
    }

    public static String checkXMLFragment(String value) {
        value = FlowContainerUtils.escapeXMLEntities((String)value);
        String xml = "<?xml version='1.0' encoding='UTF-8'?><fragment>" + value + "</fragment>";
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            inputStream = new ByteArrayInputStream(xml.getBytes());
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            builder.build((InputStream)inputStream);
        }
        catch (JDOMException jdome) {
            return jdome.getMessage();
        }
        catch (IOException ioe) {
            return ioe.getMessage();
        }
        return null;
    }

    public static String escapeXMLEntities(String value) {
        if (value == null) {
            return null;
        }
        int amp = -1;
        while ((amp = value.indexOf(38, amp + 1)) > -1) {
            if (FlowContainerUtils.substringCompare((String)value, (int)(amp + 1), (char[])new char[]{'#'})) continue;
            if (FlowContainerUtils.substringCompare((String)value, (int)(amp + 1), (char[])new char[]{'a', 'm', 'p', ';'})) continue;
            if (FlowContainerUtils.substringCompare((String)value, (int)(amp + 1), (char[])new char[]{'a', 'p', 'o', 's', ';'})) continue;
            if (FlowContainerUtils.substringCompare((String)value, (int)(amp + 1), (char[])new char[]{'q', 'u', 'o', 't', ';'})) continue;
            if (FlowContainerUtils.substringCompare((String)value, (int)(amp + 1), (char[])new char[]{'l', 't', ';'})) continue;
            if (FlowContainerUtils.substringCompare((String)value, (int)(amp + 1), (char[])new char[]{'g', 't', ';'})) continue;
            value = value.substring(0, amp) + "&amp;" + value.substring(amp + 1);
        }
        return value;
    }

    private static boolean substringCompare(String string, int index, char ... characters) {
        if (string.length() <= index + characters.length) {
            return false;
        }
        for (char character : characters) {
            if (string.charAt(index) != character) {
                return false;
            }
            ++index;
        }
        return false;
    }
}

